/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.internal.core;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.core.Declaration;
import org.eclipse.rcptt.ecl.core.Global;
import org.eclipse.rcptt.ecl.core.Val;
import org.eclipse.rcptt.ecl.internal.core.AbstractSession;
import org.eclipse.rcptt.ecl.internal.core.CorePlugin;
import org.eclipse.rcptt.ecl.internal.core.DeclarationContainer;
import org.eclipse.rcptt.ecl.runtime.ICommandService;
import org.eclipse.rcptt.ecl.runtime.IProcess;
import org.eclipse.rcptt.ecl.runtime.ISession;

public class GlobalService
implements ICommandService {
    @Override
    public IStatus service(Command command, IProcess context) throws InterruptedException, CoreException {
        if (!(command instanceof Global)) {
            return Status.CANCEL_STATUS;
        }
        Global global = (Global)command;
        DeclarationContainer globals = GlobalService.getGlobals(context);
        for (Declaration decl : global.getVals()) {
            if (!(decl instanceof Val)) continue;
            Val val = (Val)decl;
            if (val.isInput()) {
                throw new CoreException(CorePlugin.err("Cannot initialize global value from input"));
            }
            if (val.getValue() == null) {
                throw new CoreException(CorePlugin.err("Cannot declare uninitialized global value"));
            }
            globals.declare(val.getName(), val, global.isOverride());
        }
        return Status.OK_STATUS;
    }

    protected static DeclarationContainer getGlobals(IProcess context) {
        ISession session = context.getSession();
        if (!(session instanceof AbstractSession)) {
            return null;
        }
        return ((AbstractSession)session).getRoot().getGlobals();
    }
}

