/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search.dependencies;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.eclipse.pde.internal.core.text.bundle.ExportPackageHeader;
import org.eclipse.pde.internal.core.text.bundle.ExportPackageObject;
import org.eclipse.pde.internal.core.util.PDEJavaHelper;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class CalculateUsesOperation
extends WorkspaceModifyOperation {
    private final IProject fProject;
    private final IBundlePluginModelBase fModel;

    public CalculateUsesOperation(IProject project, IBundlePluginModelBase model) {
        this.fProject = project;
        this.fModel = model;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        try {
            Collection<String> packages = this.getPublicExportedPackages();
            if (packages.isEmpty()) {
                return;
            }
            Map<String, HashSet<String>> pkgsAndUses = this.findPackageReferences(packages, monitor);
            if (monitor.isCanceled()) {
                return;
            }
            this.handleSetUsesDirectives(pkgsAndUses);
        }
        finally {
            monitor.done();
        }
    }

    protected Collection<String> getPublicExportedPackages() {
        IBundle bundle = this.fModel.getBundleModel().getBundle();
        IManifestHeader header = bundle.getManifestHeader("Export-Package");
        if (header == null) {
            return Collections.emptySet();
        }
        ArrayList<String> list = new ArrayList<String>();
        ExportPackageObject[] pkgs = ((ExportPackageHeader)header).getPackages();
        int i = 0;
        while (i < pkgs.length) {
            if (!pkgs[i].isInternal()) {
                list.add(pkgs[i].getName());
            }
            ++i;
        }
        return list;
    }

    protected Map<String, HashSet<String>> findPackageReferences(Collection<String> packages, IProgressMonitor monitor) {
        IJavaProject jp = JavaCore.create((IProject)this.fProject);
        HashMap<String, HashSet<String>> pkgsAndUses = new HashMap<String, HashSet<String>>();
        IPackageFragment[] frags = PDEJavaHelper.getPackageFragments((IJavaProject)jp, Collections.emptySet(), (boolean)false);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(frags.length * 2));
        IPackageFragment[] iPackageFragmentArray = frags;
        int n = frags.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragment fragment = iPackageFragmentArray[n2];
            SubMonitor iterationMonitor = subMonitor.split(2);
            if (iterationMonitor.isCanceled()) {
                return pkgsAndUses;
            }
            iterationMonitor.subTask(NLS.bind((String)PDEUIMessages.CalculateUsesOperation_calculatingDirective, (Object)fragment.getElementName()));
            if (packages.contains(fragment.getElementName())) {
                HashSet<String> pkgs = new HashSet<String>();
                pkgsAndUses.put(fragment.getElementName(), pkgs);
                try {
                    this.findReferences((ITypeRoot[])fragment.getCompilationUnits(), pkgs, (IProgressMonitor)iterationMonitor.split(1), false);
                    this.findReferences((ITypeRoot[])fragment.getClassFiles(), pkgs, (IProgressMonitor)iterationMonitor.split(1), true);
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
            }
            ++n2;
        }
        return pkgsAndUses;
    }

    protected void findReferences(ITypeRoot[] roots, Set<String> pkgs, IProgressMonitor monitor, boolean binary) throws JavaModelException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)roots.length);
        ITypeRoot[] iTypeRootArray = roots;
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeRoot root = iTypeRootArray[n2];
            this.findReferences(root.findPrimaryType(), pkgs, binary, (IProgressMonitor)subMonitor.split(1));
            ++n2;
        }
    }

    protected void findReferences(IType type, Set<String> pkgs, boolean binary, IProgressMonitor monitor) throws JavaModelException {
        if (type == null) {
            return;
        }
        if (Flags.isPrivate((int)type.getFlags())) {
            return;
        }
        IMethod[] methods = type.getMethods();
        IField[] fields = type.getFields();
        IType[] subTypes = type.getTypes();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(methods.length * 3 + fields.length + 2 + subTypes.length));
        int i = 0;
        while (i < methods.length) {
            if (!Flags.isPrivate((int)methods[i].getFlags())) {
                String methodSignature = methods[i].getSignature();
                this.addPackages(Signature.getThrownExceptionTypes((String)methodSignature), pkgs, type, binary, (IProgressMonitor)subMonitor.split(1));
                this.addPackages(Signature.getParameterTypes((String)methodSignature), pkgs, type, binary, (IProgressMonitor)subMonitor.split(1));
                this.addPackage(Signature.getReturnType((String)methodSignature), pkgs, type, binary, (IProgressMonitor)subMonitor.split(1));
            }
            ++i;
        }
        i = 0;
        while (i < fields.length) {
            if (!Flags.isPrivate((int)fields[i].getFlags())) {
                this.addPackage(fields[i].getTypeSignature(), pkgs, type, binary, (IProgressMonitor)subMonitor.split(1));
            }
            ++i;
        }
        this.addPackage(type.getSuperclassTypeSignature(), pkgs, type, binary, (IProgressMonitor)subMonitor.split(1));
        this.addPackages(type.getSuperInterfaceTypeSignatures(), pkgs, type, binary, (IProgressMonitor)subMonitor.split(1));
        IType[] iTypeArray = subTypes;
        int n = subTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IType subType = iTypeArray[n2];
            this.findReferences(subType, pkgs, binary, (IProgressMonitor)subMonitor.split(1));
            ++n2;
        }
    }

    protected final void addPackage(String typeSignature, Set<String> pkgs, IType type, boolean binary, IProgressMonitor monitor) throws JavaModelException {
        if (typeSignature == null) {
            return;
        }
        if (binary) {
            typeSignature = typeSignature.replace('/', '.');
        }
        if (typeSignature.indexOf(46) != -1) {
            try {
                String[][] temp = type.resolveType(new String(Signature.toCharArray((char[])typeSignature.toCharArray())));
                if (temp != null) {
                    pkgs.add(temp[0][0]);
                    return;
                }
            }
            catch (IllegalArgumentException temp) {
                // empty catch block
            }
            String pkg = Signature.getSignatureQualifier((String)typeSignature);
            if (pkg.length() > 0) {
                pkgs.add(pkg);
                return;
            }
        } else {
            String typeName = Signature.getSignatureSimpleName((String)typeSignature);
            String[][] result = type.resolveType(typeName);
            if (result != null) {
                pkgs.add(result[0][0]);
            }
        }
    }

    protected final void addPackages(String[] typeSignatures, Set<String> pkgs, IType type, boolean binary, IProgressMonitor monitor) throws JavaModelException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)typeSignatures.length);
        String[] stringArray = typeSignatures;
        int n = typeSignatures.length;
        int n2 = 0;
        while (n2 < n) {
            String typeSignature = stringArray[n2];
            this.addPackage(typeSignature, pkgs, type, binary, (IProgressMonitor)subMonitor.split(1));
            ++n2;
        }
    }

    protected void handleSetUsesDirectives(Map<String, HashSet<String>> pkgsAndUses) {
        if (pkgsAndUses.isEmpty()) {
            return;
        }
        this.setUsesDirectives(pkgsAndUses);
    }

    protected void setUsesDirectives(Map<String, HashSet<String>> pkgsAndUses) {
        IBundle bundle = this.fModel.getBundleModel().getBundle();
        IManifestHeader header = bundle.getManifestHeader("Export-Package");
        ExportPackageObject[] pkgs = ((ExportPackageHeader)header).getPackages();
        int i = 0;
        while (i < pkgs.length) {
            if (pkgsAndUses.containsKey(pkgs[i].getName())) {
                String value = this.getDirectiveValue(pkgs[i].getName(), pkgsAndUses);
                pkgs[i].setUsesDirective(value);
            }
            ++i;
        }
    }

    protected String getDirectiveValue(String pkgName, Map<String, HashSet<String>> pkgsAndUses) {
        Set usesPkgs = pkgsAndUses.get(pkgName);
        usesPkgs.remove(pkgName);
        StringBuilder buffer = null;
        Iterator it = usesPkgs.iterator();
        while (it.hasNext()) {
            String usedPkgName = (String)it.next();
            if (usedPkgName.startsWith("java.")) {
                it.remove();
                continue;
            }
            if (buffer == null) {
                buffer = new StringBuilder();
            } else {
                buffer.append(',');
            }
            buffer.append(usedPkgName);
            it.remove();
        }
        if (usesPkgs.isEmpty()) {
            pkgsAndUses.remove(pkgName);
        }
        return buffer == null ? null : buffer.toString();
    }
}

