/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.resources.ui.imports;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.rcptt.core.persistence.IPersistenceModel;
import org.eclipse.rcptt.core.persistence.PersistenceManager;
import org.eclipse.rcptt.resources.ImportUtils;
import org.eclipse.rcptt.resources.WSUtils;
import org.eclipse.rcptt.ui.wizards.imports.BaseProjectsImportPage;
import org.eclipse.rcptt.ui.wizards.imports.ProjectRecord;
import org.eclipse.rcptt.util.FileUtil;
import org.eclipse.rcptt.workspace.WSFile;
import org.eclipse.rcptt.workspace.WSFolder;
import org.eclipse.rcptt.workspace.WSProject;
import org.eclipse.rcptt.workspace.WorkspaceData;
import org.eclipse.rcptt.workspace.WorkspaceFactory;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;

public class WizardProjectsImportPage
extends BaseProjectsImportPage {
    private WorkspaceData workspaceData;

    public WizardProjectsImportPage(WorkspaceData workspaceData) {
        this(workspaceData, null);
    }

    public WizardProjectsImportPage(WorkspaceData workspaceData, String initialPath) {
        super(initialPath);
        this.workspaceData = workspaceData;
    }

    protected boolean createExistingProject(ProjectRecord record, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        String projectName = record.getProjectName();
        WSProject project = WorkspaceFactory.eINSTANCE.createWSProject();
        project.setName(projectName);
        if (record.projectArchiveFile != null) {
            List fileSystemObjects = this.structureProvider.getChildren(record.parent);
            this.structureProvider.setStrip(record.level);
            this.workspaceData.getContent().getProjects().add((Object)project);
            IPersistenceModel model = PersistenceManager.getInstance().getModel(this.workspaceData.eResource());
            if (model != null) {
                for (Object object : fileSystemObjects) {
                    this.importFileSystemObject(object, (IImportStructureProvider)this.structureProvider, project, model);
                }
            }
            return true;
        }
        File importSource = null;
        URI locationURI = record.description.getLocationURI();
        if (locationURI != null) {
            importSource = new File(locationURI);
        }
        if (importSource == null) {
            importSource = record.projectSystemFile.getParentFile();
        }
        if (importSource != null) {
            this.workspaceData.getContent().getProjects().add((Object)project);
            FileSystemStructureProvider provider = FileSystemStructureProvider.INSTANCE;
            List filesToImport = provider.getChildren((Object)importSource);
            IPersistenceModel model = PersistenceManager.getInstance().getModel(this.workspaceData.eResource());
            if (model != null) {
                for (Object object : filesToImport) {
                    this.importFileSystemObject(object, (IImportStructureProvider)provider, project, model);
                }
            }
        }
        return true;
    }

    private void importFileSystemObject(Object object, IImportStructureProvider provider, WSProject project, IPersistenceModel model) {
        if (provider.isFolder(object)) {
            Path fullPath = new Path(provider.getFullPath(object));
            WSFolder folder = WSUtils.getFolder((WSFolder)project, (String)fullPath.lastSegment(), (boolean)true);
            this.importFolder(folder, provider.getChildren(object), model, provider);
        } else {
            Path fullPath = new Path(provider.getFullPath(object));
            WSFile file = WSUtils.getFile((WSFolder)project, (String)fullPath.lastSegment(), (boolean)true);
            String fName = ImportUtils.getName((WSFile)file);
            OutputStream store = model.store(fName);
            InputStream inputStream = provider.getContents(object);
            try {
                FileUtil.copy((InputStream)inputStream, (OutputStream)store);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void importFolder(WSFolder root, List children, IPersistenceModel model, IImportStructureProvider provider) {
        for (Object object : children) {
            Path fullPath;
            if (provider.isFolder(object)) {
                fullPath = new Path(provider.getFullPath(object));
                WSFolder folder = WSUtils.getFolder((WSFolder)root, (String)fullPath.lastSegment(), (boolean)true);
                this.importFolder(folder, provider.getChildren(object), model, provider);
                continue;
            }
            fullPath = new Path(provider.getFullPath(object));
            WSFile file = WSUtils.getFile((WSFolder)root, (String)fullPath.lastSegment(), (boolean)true);
            String fName = ImportUtils.getName((WSFile)file);
            OutputStream store = model.store(fName);
            InputStream inputStream = provider.getContents(object);
            try {
                FileUtil.copy((InputStream)inputStream, (OutputStream)store);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected boolean isProjectExists(String projectName) {
        if (projectName == null) {
            return false;
        }
        for (WSProject project : this.workspaceData.getContent().getProjects()) {
            if (!projectName.equals(project.getName())) continue;
            return true;
        }
        return false;
    }
}

