/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.runtime.ui;

import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.rcptt.internal.runtime.ui.Activator;
import org.eclipse.rcptt.reporting.core.ReportManager;
import org.eclipse.rcptt.runtime.ui.AutEventManager;
import org.eclipse.rcptt.runtime.ui.Q7ServerStarter;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.PlatformUI;

public class Q7RuntimeStartup
implements IStartup {
    public void earlyStartup() {
        try {
            Q7ServerStarter.INSTANCE.start();
            PlatformUI.getWorkbench().addWorkbenchListener(new IWorkbenchListener(){

                public boolean preShutdown(IWorkbench workbench, boolean forced) {
                    Activator.info(new Exception("Just to get a current stack trace logged. This is not an error."), "Workbench is about to shut down", new Object[0]);
                    return true;
                }

                public void postShutdown(IWorkbench workbench) {
                    ReportManager.storeState();
                    Q7RuntimeStartup.this.tryTerminateLaunches();
                }
            });
        }
        finally {
            AutEventManager.getInstance().sendStartup();
        }
    }

    private void tryTerminateLaunches() {
        try {
            ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
            ILaunch[] iLaunchArray = manager.getLaunches();
            int n = iLaunchArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunch launch = iLaunchArray[n2];
                launch.terminate();
                ++n2;
            }
        }
        catch (Throwable throwable) {}
    }
}

