/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.sshd;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.PublicKey;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.agent.SshAgentFactory;
import org.apache.sshd.agent.SshAgentKeyConstraint;
import org.apache.sshd.client.auth.pubkey.KeyAgentIdentity;
import org.apache.sshd.client.auth.pubkey.PublicKeyIdentity;
import org.apache.sshd.client.auth.pubkey.UserAuthPublicKey;
import org.apache.sshd.client.auth.pubkey.UserAuthPublicKeyIterator;
import org.apache.sshd.client.config.hosts.HostConfigEntry;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.u2f.SecurityKeyPublicKey;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.signature.SignatureFactoriesManager;
import org.apache.sshd.common.util.GenericUtils;
import org.eclipse.jgit.internal.transport.ssh.OpenSshConfigFile;
import org.eclipse.jgit.internal.transport.sshd.AuthenticationCanceledException;
import org.eclipse.jgit.internal.transport.sshd.JGitClientSession;
import org.eclipse.jgit.internal.transport.sshd.SshdText;
import org.eclipse.jgit.internal.transport.sshd.pkcs11.Pkcs11Provider;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.StringUtils;

public class JGitPublicKeyAuthentication
extends UserAuthPublicKey {
    private static final String LOG_FORMAT = "{}";
    private SshAgent agent;
    private HostConfigEntry hostConfig;
    private boolean addKeysToAgent;
    private boolean askBeforeAdding;
    private String skProvider;
    private SshAgentKeyConstraint[] constraints;

    JGitPublicKeyAuthentication(List<NamedFactory<Signature>> factories) {
        super(factories);
    }

    public void init(ClientSession rawSession, String service) throws Exception {
        List localFactories;
        if (!(rawSession instanceof JGitClientSession)) {
            throw new IllegalStateException("Wrong session type: " + rawSession.getClass().getCanonicalName());
        }
        JGitClientSession session = (JGitClientSession)rawSession;
        this.hostConfig = session.getHostConfigEntry();
        String pubkeyAlgos = this.hostConfig.getProperty("PubkeyAcceptedAlgorithms");
        if (!StringUtils.isEmptyOrNull((String)pubkeyAlgos)) {
            List<String> signatures = session.getSignatureFactoriesNames();
            if (!(signatures = session.modifyAlgorithmList(signatures, session.getAllAvailableSignatureAlgorithms(), pubkeyAlgos, "PubkeyAcceptedAlgorithms")).isEmpty()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("PubkeyAcceptedAlgorithms " + String.valueOf(signatures));
                }
                this.setSignatureFactoriesNames(signatures);
                super.init((ClientSession)session, service);
                return;
            }
            this.log.warn(LOG_FORMAT, (Object)MessageFormat.format(SshdText.get().configNoKnownAlgorithms, "PubkeyAcceptedAlgorithms", pubkeyAlgos));
        }
        if ((localFactories = this.getSignatureFactories()) == null || localFactories.isEmpty()) {
            this.setSignatureFactoriesNames(session.getSignatureFactoriesNames());
        }
        super.init((ClientSession)session, service);
    }

    protected Iterator<PublicKeyIdentity> createPublicKeyIterator(ClientSession session, SignatureFactoriesManager manager) throws Exception {
        this.agent = this.getAgent(session);
        if (this.agent != null) {
            this.parseAddKeys(this.hostConfig);
            if (this.addKeysToAgent) {
                this.skProvider = this.hostConfig.getProperty("SecurityKeyProvider");
            }
        }
        return new KeyIterator(session, manager);
    }

    protected PublicKeyIdentity resolveAttemptedPublicKeyIdentity(ClientSession session, String service) throws Exception {
        KeyPair key;
        PublicKeyIdentity id = super.resolveAttemptedPublicKeyIdentity(session, service);
        if (this.addKeysToAgent && id != null && !(id instanceof KeyAgentIdentity) && (key = id.getKeyIdentity()) != null && key.getPublic() != null && key.getPrivate() != null) {
            PublicKey pk = key.getPublic();
            String fingerprint = KeyUtils.getFingerPrint((PublicKey)pk);
            String keyType = KeyUtils.getKeyType((KeyPair)key);
            try {
                if (this.agentHasKey(pk)) {
                    return id;
                }
                if (this.askBeforeAdding && session instanceof JGitClientSession) {
                    boolean result;
                    CredentialsProvider provider = ((JGitClientSession)session).getCredentialsProvider();
                    CredentialItem.YesNoType question = new CredentialItem.YesNoType(MessageFormat.format(SshdText.get().pubkeyAuthAddKeyToAgentQuestion, keyType, fingerprint));
                    boolean bl = result = provider != null && provider.supports(new CredentialItem[]{question}) && provider.get(this.getUri(), new CredentialItem[]{question});
                    if (!result || !question.getValue()) {
                        return id;
                    }
                }
                SshAgentKeyConstraint[] rules = this.constraints;
                if (pk instanceof SecurityKeyPublicKey && !StringUtils.isEmptyOrNull((String)this.skProvider)) {
                    rules = Arrays.copyOf(rules, rules.length + 1);
                    rules[rules.length - 1] = new SshAgentKeyConstraint.FidoProviderExtension(this.skProvider);
                }
                this.agent.addIdentity(key, null, rules);
            }
            catch (IOException e) {
                this.log.error(LOG_FORMAT, (Object)MessageFormat.format(SshdText.get().pubkeyAuthAddKeyToAgentError, keyType, fingerprint), (Object)e);
            }
        }
        return id;
    }

    private boolean agentHasKey(PublicKey pk) throws IOException {
        Iterable ids = this.agent.getIdentities();
        if (ids == null) {
            return false;
        }
        Iterator iter = ids.iterator();
        while (iter.hasNext()) {
            if (!KeyUtils.compareKeys((PublicKey)((PublicKey)((Map.Entry)iter.next()).getKey()), (PublicKey)pk)) continue;
            return true;
        }
        return false;
    }

    private URIish getUri() {
        Object uri = "ssh://";
        String userName = this.hostConfig.getUsername();
        if (!StringUtils.isEmptyOrNull((String)userName)) {
            uri = (String)uri + userName + "@";
        }
        uri = (String)uri + this.hostConfig.getHost();
        int port = this.hostConfig.getPort();
        if (port > 0 && port != 22) {
            uri = (String)uri + ":" + port;
        }
        try {
            return new URIish((String)uri);
        }
        catch (URISyntaxException e) {
            this.log.error(e.getLocalizedMessage(), (Throwable)e);
            return new URIish();
        }
    }

    private SshAgent getAgent(ClientSession session) throws Exception {
        FactoryManager manager = (FactoryManager)Objects.requireNonNull(session.getFactoryManager(), "No session factory manager");
        SshAgentFactory factory = manager.getAgentFactory();
        if (factory == null) {
            return null;
        }
        return factory.createClient((Session)session, manager);
    }

    private void parseAddKeys(HostConfigEntry config) {
        String value = config.getProperty("AddKeysToAgent");
        if (StringUtils.isEmptyOrNull((String)value)) {
            this.addKeysToAgent = false;
            return;
        }
        String[] values = value.split(",");
        ArrayList<Object> rules = new ArrayList<Object>(2);
        switch (values[0]) {
            case "yes": {
                this.addKeysToAgent = true;
                break;
            }
            case "no": {
                this.addKeysToAgent = false;
                break;
            }
            case "ask": {
                this.addKeysToAgent = true;
                this.askBeforeAdding = true;
                break;
            }
            case "confirm": {
                int seconds;
                this.addKeysToAgent = true;
                rules.add(SshAgentKeyConstraint.CONFIRM);
                if (values.length <= 1 || (seconds = OpenSshConfigFile.timeSpec((String)values[1])) <= 0) break;
                rules.add(new SshAgentKeyConstraint.LifeTime(seconds));
                break;
            }
            default: {
                int seconds = OpenSshConfigFile.timeSpec((String)values[0]);
                if (seconds <= 0) break;
                this.addKeysToAgent = true;
                rules.add(new SshAgentKeyConstraint.LifeTime(seconds));
            }
        }
        this.constraints = rules.toArray(new SshAgentKeyConstraint[0]);
    }

    protected void releaseKeys() throws IOException {
        block6: {
            this.addKeysToAgent = false;
            this.askBeforeAdding = false;
            this.skProvider = null;
            this.constraints = null;
            try {
                if (this.agent == null) break block6;
                try {
                    this.agent.close();
                }
                finally {
                    this.agent = null;
                }
            }
            finally {
                super.releaseKeys();
            }
        }
    }

    private class KeyIterator
    extends UserAuthPublicKeyIterator {
        private static final String PUB_KEY_SUFFIX = ".pub";

        public KeyIterator(ClientSession session, SignatureFactoriesManager manager) throws Exception {
            super(session, manager);
        }

        private List<PublicKey> getExplicitKeys(Collection<String> explicitFiles) {
            if (explicitFiles == null) {
                return null;
            }
            return explicitFiles.stream().map(s -> {
                PublicKey publicKey = this.readPublicKey((String)s, false);
                if (publicKey == null && !s.endsWith(PUB_KEY_SUFFIX)) {
                    publicKey = this.readPublicKey(s + PUB_KEY_SUFFIX, true);
                }
                return publicKey;
            }).filter(Objects::nonNull).collect(Collectors.toList());
        }

        private PublicKey readPublicKey(String keyFile, boolean isDerived) {
            block5: {
                try {
                    Path p = Paths.get(keyFile, new String[0]);
                    if (Files.isRegularFile(p, LinkOption.NOFOLLOW_LINKS)) {
                        return KeyUtils.loadPublicKey((Path)p);
                    }
                    if (!isDerived) {
                        JGitPublicKeyAuthentication.this.log.warn(JGitPublicKeyAuthentication.LOG_FORMAT, (Object)MessageFormat.format(SshdText.get().cannotReadPublicKey, keyFile));
                    }
                }
                catch (IOException | InvalidPathException e) {
                    JGitPublicKeyAuthentication.this.log.warn(JGitPublicKeyAuthentication.LOG_FORMAT, (Object)MessageFormat.format(SshdText.get().cannotReadPublicKey, keyFile), (Object)e);
                }
                catch (GeneralSecurityException e) {
                    if (!isDerived) break block5;
                    JGitPublicKeyAuthentication.this.log.warn(JGitPublicKeyAuthentication.LOG_FORMAT, (Object)MessageFormat.format(SshdText.get().cannotReadPublicKey, keyFile), (Object)e);
                }
            }
            return null;
        }

        protected Iterable<KeyAgentIdentity> initializeAgentIdentities(ClientSession session) throws IOException {
            Iterable<KeyAgentIdentity> allAgentKeys = this.getAgentIdentities();
            if (allAgentKeys == null) {
                return null;
            }
            final Collection<PublicKey> identityFiles = this.identitiesOnly();
            if (GenericUtils.isEmpty(identityFiles)) {
                return allAgentKeys;
            }
            return () -> new Iterator<KeyAgentIdentity>(allAgentKeys){
                private final Iterator<KeyAgentIdentity> identities;
                private KeyAgentIdentity next;
                {
                    this.identities = iterable.iterator();
                }

                @Override
                public boolean hasNext() {
                    while (this.next == null && this.identities.hasNext()) {
                        KeyAgentIdentity val = this.identities.next();
                        PublicKey pk = val.getKeyIdentity().getPublic();
                        if (identityFiles.stream().anyMatch(k -> KeyUtils.compareKeys((PublicKey)k, (PublicKey)pk))) {
                            this.next = val;
                            return true;
                        }
                        if (!JGitPublicKeyAuthentication.this.log.isTraceEnabled()) continue;
                        JGitPublicKeyAuthentication.this.log.trace("Ignoring SSH agent or PKCS11 {} key not in explicit IdentityFile in SSH config: {}", (Object)KeyUtils.getKeyType((Key)pk), (Object)KeyUtils.getFingerPrint((PublicKey)pk));
                    }
                    return this.next != null;
                }

                @Override
                public KeyAgentIdentity next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    KeyAgentIdentity result = this.next;
                    this.next = null;
                    return result;
                }
            };
        }

        private Collection<PublicKey> identitiesOnly() {
            if (JGitPublicKeyAuthentication.this.hostConfig != null && JGitPublicKeyAuthentication.this.hostConfig.isIdentitiesOnly()) {
                return this.getExplicitKeys(JGitPublicKeyAuthentication.this.hostConfig.getIdentities());
            }
            return Collections.emptyList();
        }

        private Iterable<KeyAgentIdentity> getAgentIdentities() throws IOException {
            Iterable<KeyAgentIdentity> pkcs11Keys = this.getPkcs11Keys();
            if (JGitPublicKeyAuthentication.this.agent == null) {
                return pkcs11Keys;
            }
            Iterable agentKeys = JGitPublicKeyAuthentication.this.agent.getIdentities();
            if (GenericUtils.isEmpty((Iterable)agentKeys)) {
                return pkcs11Keys;
            }
            Iterable<KeyAgentIdentity> fromAgent = () -> new Iterator<KeyAgentIdentity>(agentKeys){
                private final Iterator<? extends Map.Entry<PublicKey, String>> iter;
                {
                    this.iter = iterable.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iter.hasNext();
                }

                @Override
                public KeyAgentIdentity next() {
                    Map.Entry<PublicKey, String> next = this.iter.next();
                    return new KeyAgentIdentity(((KeyIterator)KeyIterator.this).JGitPublicKeyAuthentication.this.agent, next.getKey(), next.getValue());
                }
            };
            if (GenericUtils.isEmpty(pkcs11Keys)) {
                return fromAgent;
            }
            return () -> new Iterator<KeyAgentIdentity>(pkcs11Keys, fromAgent){
                private final Iterator<Iterator<KeyAgentIdentity>> keyIter;
                private Iterator<KeyAgentIdentity> currentKeys;
                private Boolean hasElement;
                {
                    this.keyIter = List.of(iterable.iterator(), iterable2.iterator()).iterator();
                }

                /*
                 * Unable to fully structure code
                 */
                @Override
                public boolean hasNext() {
                    if (this.hasElement == null) ** GOTO lbl9
                    return this.hasElement;
lbl-1000:
                    // 1 sources

                    {
                        if (this.keyIter.hasNext()) {
                            this.currentKeys = this.keyIter.next();
                            continue;
                        }
                        this.currentKeys = null;
                        this.hasElement = Boolean.FALSE;
                        return false;
lbl9:
                        // 2 sources

                        ** while (this.currentKeys == null || !this.currentKeys.hasNext())
                    }
lbl10:
                    // 1 sources

                    this.hasElement = Boolean.TRUE;
                    return true;
                }

                @Override
                public KeyAgentIdentity next() {
                    KeyAgentIdentity result;
                    if (this.hasElement == null && !this.hasNext() || !this.hasElement.booleanValue()) {
                        throw new NoSuchElementException();
                    }
                    this.hasElement = null;
                    try {
                        result = this.currentKeys.next();
                    }
                    catch (NoSuchElementException e) {
                        result = null;
                    }
                    return result;
                }
            };
        }

        private Iterable<KeyAgentIdentity> getPkcs11Keys() throws IOException {
            Iterable<KeyAgentIdentity> pkcs11Identities;
            String value;
            block9: {
                Path library;
                value = JGitPublicKeyAuthentication.this.hostConfig.getProperty("PKCS11Provider");
                if (StringUtils.isEmptyOrNull((String)value) || "none".equals(value)) {
                    return null;
                }
                if (value.startsWith("~/") || value.startsWith("~" + File.separator)) {
                    value = new File(FS.DETECTED.userHome(), value.substring(2)).toString();
                }
                if (!(library = Paths.get(value, new String[0])).isAbsolute()) {
                    throw new IOException(MessageFormat.format(SshdText.get().pkcs11NotAbsolute, JGitPublicKeyAuthentication.this.hostConfig.getHost(), JGitPublicKeyAuthentication.this.hostConfig.getHostName(), "PKCS11Provider", value));
                }
                if (!Files.isRegularFile(library, new LinkOption[0])) {
                    throw new IOException(MessageFormat.format(SshdText.get().pkcs11NonExisting, JGitPublicKeyAuthentication.this.hostConfig.getHost(), JGitPublicKeyAuthentication.this.hostConfig.getHostName(), "PKCS11Provider", value));
                }
                int slotListIndex = OpenSshConfigFile.positive((String)JGitPublicKeyAuthentication.this.hostConfig.getProperty("PKCS11SlotListIndex"));
                Pkcs11Provider provider = Pkcs11Provider.getProvider(library, slotListIndex);
                if (provider == null) {
                    throw new UnsupportedOperationException();
                }
                pkcs11Identities = provider.getKeys((SessionContext)this.getSession());
                if (!GenericUtils.isEmpty(pkcs11Identities)) break block9;
                JGitPublicKeyAuthentication.this.log.warn(JGitPublicKeyAuthentication.LOG_FORMAT, (Object)MessageFormat.format(SshdText.get().pkcs11NoKeys, JGitPublicKeyAuthentication.this.hostConfig.getHost(), JGitPublicKeyAuthentication.this.hostConfig.getHostName(), "PKCS11Provider", value));
                return null;
            }
            try {
                return pkcs11Identities;
            }
            catch (UnsupportedOperationException e) {
                throw new UnsupportedOperationException(MessageFormat.format(SshdText.get().pkcs11Unsupported, JGitPublicKeyAuthentication.this.hostConfig.getHost(), JGitPublicKeyAuthentication.this.hostConfig.getHostName(), "PKCS11Provider", value), e);
            }
            catch (Exception e) {
                this.checkCancellation(e);
                throw new IOException(MessageFormat.format(SshdText.get().pkcs11FailedInstantiation, JGitPublicKeyAuthentication.this.hostConfig.getHost(), JGitPublicKeyAuthentication.this.hostConfig.getHostName(), "PKCS11Provider", value), e);
            }
        }

        private void checkCancellation(Throwable e) {
            Throwable t = e;
            while (t != null) {
                if (t instanceof AuthenticationCanceledException) {
                    throw (AuthenticationCanceledException)t;
                }
                t = t.getCause();
            }
        }
    }
}

