/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching.aut;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeoutException;
import java.util.function.BooleanSupplier;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.rcptt.core.ContextType;
import org.eclipse.rcptt.core.Scenarios;
import org.eclipse.rcptt.core.VerificationType;
import org.eclipse.rcptt.core.ecl.core.model.EnterContext;
import org.eclipse.rcptt.core.ecl.core.model.ExecVerification;
import org.eclipse.rcptt.core.ecl.core.model.ExecutionPhase;
import org.eclipse.rcptt.core.ecl.core.model.Q7CoreFactory;
import org.eclipse.rcptt.core.ecl.core.model.Q7Information;
import org.eclipse.rcptt.core.launching.events.AutBundleState;
import org.eclipse.rcptt.core.launching.events.AutEvent;
import org.eclipse.rcptt.core.launching.events.AutEventInit;
import org.eclipse.rcptt.core.launching.events.AutEventLocation;
import org.eclipse.rcptt.core.launching.events.AutEventStart;
import org.eclipse.rcptt.core.model.IContext;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ITestCase;
import org.eclipse.rcptt.core.model.IVerification;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.scenario.NamedElement;
import org.eclipse.rcptt.core.scenario.Scenario;
import org.eclipse.rcptt.core.scenario.ScenarioProperty;
import org.eclipse.rcptt.core.scenario.Verification;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.core.CoreFactory;
import org.eclipse.rcptt.ecl.core.CorePackage;
import org.eclipse.rcptt.ecl.core.Declaration;
import org.eclipse.rcptt.ecl.core.RestoreState;
import org.eclipse.rcptt.ecl.core.Script;
import org.eclipse.rcptt.ecl.core.Sequence;
import org.eclipse.rcptt.ecl.core.SessionState;
import org.eclipse.rcptt.ecl.core.Val;
import org.eclipse.rcptt.ecl.debug.commands.CommandsFactory;
import org.eclipse.rcptt.ecl.debug.commands.DebugCommand;
import org.eclipse.rcptt.ecl.debug.commands.DebugScript;
import org.eclipse.rcptt.ecl.gen.ast.AstExec;
import org.eclipse.rcptt.ecl.parser.EclCoreParser;
import org.eclipse.rcptt.ecl.parser.ScriptErrorStatus;
import org.eclipse.rcptt.ecl.runtime.BoxedValues;
import org.eclipse.rcptt.ecl.runtime.CoreUtils;
import org.eclipse.rcptt.ecl.runtime.IPipe;
import org.eclipse.rcptt.ecl.runtime.IProcess;
import org.eclipse.rcptt.ecl.runtime.ISession;
import org.eclipse.rcptt.internal.core.model.Q7InternalContext;
import org.eclipse.rcptt.internal.core.model.Q7InternalVerification;
import org.eclipse.rcptt.internal.launching.ExecutionStatus;
import org.eclipse.rcptt.internal.launching.Q7LaunchingPlugin;
import org.eclipse.rcptt.internal.launching.aut.BaseAut;
import org.eclipse.rcptt.internal.launching.aut.BaseAutManager;
import org.eclipse.rcptt.internal.launching.aut.IBaseAutLaunchRetarget;
import org.eclipse.rcptt.internal.launching.aut.LaunchInfoCache;
import org.eclipse.rcptt.internal.launching.ecl.EclContextExecutable;
import org.eclipse.rcptt.internal.launching.ecl.ExecAdvancedInfoUtil;
import org.eclipse.rcptt.launching.AutLaunch;
import org.eclipse.rcptt.launching.AutLaunchListener;
import org.eclipse.rcptt.launching.AutLaunchState;
import org.eclipse.rcptt.launching.Q7Launcher;
import org.eclipse.rcptt.launching.Q7TeslaProblemInformer;
import org.eclipse.rcptt.launching.TestCaseDebugger;
import org.eclipse.rcptt.tesla.core.TeslaLimits;
import org.eclipse.rcptt.tesla.core.TeslaScenarioContainer;
import org.eclipse.rcptt.tesla.core.network.TeslaNetworkReplayer;
import org.eclipse.rcptt.tesla.core.protocol.raw.TeslaScenario;
import org.eclipse.rcptt.tesla.ecl.model.ShutdownAut;
import org.eclipse.rcptt.tesla.ecl.model.TeslaFactory;
import org.eclipse.rcptt.tesla.ecl.model.TeslaPackage;
import org.eclipse.rcptt.tesla.internal.core.network.IProgressInformer;

public class BaseAutLaunch
implements AutLaunch,
IBaseAutLaunchRetarget {
    private final String id;
    private BaseAut aut;
    private volatile AutLaunchState state = AutLaunchState.LAUNCH;
    private volatile ILaunch launch;
    private volatile IStatus status;
    private final CopyOnWriteArrayList<AutLaunchListener> listeners = new CopyOnWriteArrayList();
    private IProgressMonitor currentTestMonitor = null;
    private String locationOnRestart = null;
    private String lastActivateID = "";
    private AutEventInit autInit;
    private AutEventStart autStart;
    private Context context;
    private SessionState currentState;
    private static final String RESTART_COMMAND_NAME = CoreUtils.getScriptletNameByClass((EClass)TeslaPackage.eINSTANCE.getWaitUntilEclipseIsReady());

    BaseAutLaunch(ILaunch launch, BaseAut aut, Context context) {
        this.context = Objects.requireNonNull(context);
        this.id = UUID.randomUUID().toString();
        this.aut = aut;
        this.setLaunch(launch);
    }

    public String getLastActivateID() {
        return this.lastActivateID;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public BaseAut getAut() {
        return this.aut;
    }

    @Override
    public AutLaunchState getState() {
        return this.state;
    }

    @Override
    public void addListener(AutLaunchListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(AutLaunchListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public synchronized Object execute(Command command) throws CoreException, InterruptedException {
        return this.execute(command, Q7Launcher.getLaunchTimeout() * 1000);
    }

    @Override
    public synchronized Object execute(Command command, long timeout) throws CoreException, InterruptedException {
        return this.execute(command, timeout, (IProgressMonitor)new NullProgressMonitor());
    }

    @Override
    public void handleAutEvent(AutEvent autEvent) {
        block5: {
            block6: {
                block4: {
                    if (this.getState().equals((Object)AutLaunchState.TERMINATE)) {
                        return;
                    }
                    if (!(autEvent instanceof AutEventStart)) break block4;
                    this.autStart = (AutEventStart)autEvent;
                    for (AutLaunchListener listener : this.listeners) {
                        listener.autStarted(this, this.autStart.getEclPort(), this.autStart.getTeslaPort());
                    }
                    break block5;
                }
                if (!(autEvent instanceof AutEventInit)) break block6;
                this.autInit = (AutEventInit)autEvent;
                for (AutLaunchListener listener : this.listeners) {
                    listener.autInit(this, (List<AutBundleState>)this.autInit.getBundleState());
                }
                break block5;
            }
            if (!(autEvent instanceof AutEventLocation)) break block5;
            for (AutLaunchListener listener : this.listeners) {
                listener.autLocationChange(this, ((AutEventLocation)autEvent).getLocation());
            }
        }
    }

    @Override
    public synchronized Object execute(Command command, long timeout, IProgressMonitor monitor) throws CoreException, InterruptedException {
        return this.unsafeExecute(command, timeout, monitor);
    }

    private <T> T computeInNewSession(Interruption isCancelled, final Computation<T> computation) throws CoreException, InterruptedException {
        final Object[] result = new Object[1];
        final Exception[] wrappedException = new Exception[1];
        Thread execThread = new Thread(){

            @Override
            public void run() {
                ISession session = null;
                try {
                    try {
                        session = BaseAutLaunch.this.createEclSession();
                        result[0] = computation.get(session);
                    }
                    catch (Exception e) {
                        wrappedException[0] = e;
                        if (session != null) {
                            BaseAutLaunch.this.safeClose(session);
                        }
                    }
                }
                finally {
                    if (session != null) {
                        BaseAutLaunch.this.safeClose(session);
                    }
                }
            }
        };
        execThread.start();
        try {
            while (execThread.isAlive()) {
                isCancelled.checkInterruption();
                execThread.join(100L);
            }
        }
        finally {
            execThread.interrupt();
        }
        Exception wrapped = wrappedException[0];
        if (wrapped != null) {
            if (wrapped instanceof CoreException) {
                throw new CoreException((IStatus)new MultiStatus("org.eclipse.rcptt.launching", 0, new IStatus[]{((CoreException)((Object)wrapped)).getStatus()}, wrapped.getMessage(), (Throwable)wrapped));
            }
            throw new CoreException(Q7LaunchingPlugin.createStatus(4, wrapped.getMessage(), wrapped));
        }
        return (T)result[0];
    }

    private IStatus createTimeoutStatus(long timeout) {
        Status status = new Status(4, "org.eclipse.rcptt.ecl.core", 123130, "Execution has timed out after " + (double)timeout / 1000.0 + " seconds", (Throwable)new TimeoutException());
        IStatus statusWithAdvancedInfo = ExecAdvancedInfoUtil.askForAdvancedInfo((AutLaunch)this, (IStatus)status);
        return statusWithAdvancedInfo instanceof ExecutionStatus ? statusWithAdvancedInfo : status;
    }

    private Object unsafeExecute(Command command, long timeout, IProgressMonitor monitor) throws CoreException, InterruptedException {
        try {
            long stop = System.currentTimeMillis() + timeout;
            return this.computeInNewSession(TimeoutInterruption.forTimeout(monitor, timeout, this), session -> {
                IPipe out = session.createPipe();
                IProcess rc = session.execute(command, null, out);
                IStatus status = rc.waitFor(stop - System.currentTimeMillis(), monitor);
                if (!status.isOK()) {
                    throw new CoreException(status);
                }
                Object rv = out.take(stop - System.currentTimeMillis());
                if (rv == null && stop <= System.currentTimeMillis()) {
                    throw new CoreException(this.createTimeoutStatus(timeout));
                }
                return rv;
            });
        }
        catch (Exception wrapped) {
            String message = "Failed to execute command " + command;
            if (wrapped instanceof CoreException) {
                throw new CoreException((IStatus)new MultiStatus("org.eclipse.rcptt.launching", 0, new IStatus[]{((CoreException)((Object)wrapped)).getStatus()}, message, (Throwable)wrapped));
            }
            throw new CoreException(Q7LaunchingPlugin.createStatus(4, message, wrapped));
        }
    }

    private List<Object> executeAndTakeAll(ISession session, Command command, long timeout, IProgressMonitor monitor) throws CoreException, InterruptedException {
        IPipe out = session.createPipe();
        IProcess rc = session.execute(command, null, out);
        IStatus status = rc.waitFor(timeout, monitor);
        if (!status.isOK()) {
            throw new CoreException(status);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        Object o;
        while (!((o = out.take(timeout)) instanceof IStatus)) {
            result.add(o);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate(String host, int ecl, int tesla, String platform, String capability, float seconds, IProgressMonitor monitor) throws CoreException {
        Q7LaunchingPlugin.logInfo("Activating AUT at host %s. ECL port: %d. Tesla port: %d", host, ecl, tesla);
        monitor.beginTask("AUT pinging", (int)seconds);
        ILaunch iLaunch = this.launch;
        synchronized (iLaunch) {
            this.launch.setAttribute("org.eclipse.rcptt.launching.HOST", host);
            this.launch.setAttribute("org.eclipse.rcptt.launching.ECL_PORT_ATTR", Integer.toString(ecl));
            this.launch.setAttribute("org.eclipse.rcptt.launching.TESLA_PORT_ATTR", Integer.toString(tesla));
            this.launch.setAttribute("org.eclipse.rcptt.launching.AUT_PLATFORM_ATTR", platform);
            this.launch.setAttribute("org.eclipse.rcptt.launching.AUT_CAPABILITY_ATTR", capability);
        }
        long start = System.currentTimeMillis();
        try {
            try {
                try {
                    while (!((float)(System.currentTimeMillis() - start) > seconds * 1000.0f)) {
                        try {
                            this.ping();
                        }
                        catch (CoreException coreException) {
                            Thread.sleep(1000L);
                            monitor.worked(1);
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new CoreException(Status.CANCEL_STATUS);
                }
            }
            finally {
                monitor.done();
            }
            try {
                this.ping();
            }
            catch (CoreException e) {
                throw new CoreException(Q7LaunchingPlugin.createStatus("AUT connection has been failing for " + seconds + " seconds", e));
            }
            monitor.done();
        }
        catch (InterruptedException interruptedException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        this.setState(AutLaunchState.ACTIVE);
        this.lastActivateID = UUID.randomUUID().toString();
    }

    @Override
    public void ping() throws CoreException, InterruptedException {
        block5: {
            try {
                Object object = this.unsafeExecute((Command)Q7CoreFactory.eINSTANCE.createGetQ7Information(), TeslaLimits.getAUTStartupTimeout(), (IProgressMonitor)new NullProgressMonitor());
                if (object instanceof Q7Information) {
                    Q7Information info = (Q7Information)object;
                    if (!info.isTeslaActive()) {
                        throw new CoreException(Q7LaunchingPlugin.createStatus("Tesla is not activated"));
                    }
                    if (info.getWindowCount() == 0) {
                        throw new CoreException(Q7LaunchingPlugin.createStatus("AUT has no windows"));
                    }
                    break block5;
                }
                throw new CoreException(Q7LaunchingPlugin.createStatus("Expect Q7Information but found: " + object));
            }
            catch (CoreException e) {
                throw new CoreException(Q7LaunchingPlugin.createStatus("Couldn't connect to AUT: " + e.getMessage(), e));
            }
        }
    }

    public void restart() {
        try {
            this.setState(AutLaunchState.RESTART);
            ILaunchConfiguration launchConfiguration = this.launch.getLaunchConfiguration();
            ILaunchConfigurationWorkingCopy copy = launchConfiguration.isWorkingCopy() ? ((ILaunchConfigurationWorkingCopy)launchConfiguration).getOriginal().getWorkingCopy() : launchConfiguration.getWorkingCopy();
            LaunchInfoCache.copyCache(launchConfiguration, copy);
            LaunchInfoCache.remove(launchConfiguration);
            copy.setAttribute("restart", true);
            copy.setAttribute("org.eclipse.rcptt.launching.ATTR_AUT_LAUNCH_ID", this.getId());
            if (this.locationOnRestart != null) {
                copy.setAttribute("location", this.locationOnRestart);
            }
            ILaunch oldLaunch = this.launch;
            this.launch.setAttribute("org.eclipse.rcptt.launching.ATTR_AUT_LAUNCH_ID", "");
            this.launch = copy.launch(this.launch.getLaunchMode(), (IProgressMonitor)new NullProgressMonitor());
            BaseAutManager.INSTANCE.handleRestart(this, oldLaunch, this.launch, copy);
        }
        catch (Exception e) {
            this.terminated(e);
            Q7LaunchingPlugin.log(e);
            this.setState(AutLaunchState.TERMINATE);
        }
    }

    public ILaunch setLaunch(ILaunch launch) {
        Preconditions.checkNotNull((Object)launch);
        ILaunch oldLaunch = this.launch;
        this.launch = launch;
        launch.setAttribute("org.eclipse.rcptt.launching.ATTR_AUT_LAUNCH_ID", this.id);
        return oldLaunch;
    }

    private void safeClose(ISession session) {
        try {
            session.close();
        }
        catch (Exception e) {
            Q7LaunchingPlugin.log(e);
        }
    }

    @Override
    public ILaunch getLaunch() {
        return this.launch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTeslaPort() {
        ILaunch iLaunch = this.launch;
        synchronized (iLaunch) {
            String attr = this.launch.getAttribute("org.eclipse.rcptt.launching.TESLA_PORT_ATTR");
            return Integer.parseInt(attr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getEclPort() {
        ILaunch iLaunch = this.launch;
        synchronized (iLaunch) {
            String port = this.launch.getAttribute("org.eclipse.rcptt.launching.ECL_PORT_ATTR");
            return Integer.valueOf(port);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHost() {
        ILaunch iLaunch = this.launch;
        synchronized (iLaunch) {
            return this.launch.getAttribute("org.eclipse.rcptt.launching.HOST");
        }
    }

    public IStatus getStatus() {
        return this.status;
    }

    public void terminateProcess(int exitCode) {
        if (exitCode == 23 || exitCode == 24) {
            this.restart();
        } else {
            this.terminated(exitCode);
        }
    }

    public void terminated(int exitCode) {
        if (exitCode == 15) {
            String message = "AUT workspace already in use";
            String workspace = this.getWorkspace(this.launch);
            if (workspace != null) {
                message = String.valueOf(message) + ": " + workspace;
            }
            this.terminated(Q7LaunchingPlugin.createStatus(message));
        } else if (exitCode == 13) {
            this.terminated(Q7LaunchingPlugin.createStatus("The application could not start. Details can be found in the log."));
        } else {
            this.terminated(Status.OK_STATUS);
        }
    }

    public void terminated(Exception e) {
        this.terminated(Q7LaunchingPlugin.createStatus(e.getMessage(), e));
    }

    public void terminated(IStatus status) {
        this.setState(AutLaunchState.TERMINATE);
        this.autInit = null;
        this.autStart = null;
        LaunchInfoCache.remove(this.launch.getLaunchConfiguration());
        this.status = status;
        if (this.launch.canTerminate()) {
            try {
                Q7LaunchingPlugin.logInfo("AUT terminated by RCPTT", new Object[0]);
                this.launch.terminate();
            }
            catch (DebugException e) {
                Q7LaunchingPlugin.log("Termination failed", e);
            }
        }
    }

    public void setState(AutLaunchState state) {
        this.state = state;
        for (AutLaunchListener listener : this.listeners) {
            listener.stateChanged(this, state);
        }
    }

    private String getWorkspace(ILaunch launch) {
        try {
            ILaunchConfiguration launchConfiguration = launch.getLaunchConfiguration();
            return launchConfiguration.getAttribute("location", "");
        }
        catch (Exception e) {
            Q7LaunchingPlugin.log("Couldn't find launch workspace", e);
            return null;
        }
    }

    @Override
    public synchronized void run(IQ7NamedElement element, long timeout, IProgressMonitor monitor, ExecutionPhase phase) throws CoreException {
        this.execElement(element, timeout, monitor, null, phase);
    }

    @Override
    public synchronized void debug(IQ7NamedElement element, IProgressMonitor monitor, TestCaseDebugger debugger, ExecutionPhase phase) throws CoreException {
        this.execElement(element, 1000L * (long)Q7Launcher.getDebugTimeout(), monitor, debugger, phase);
    }

    @Override
    public void cancelTestExecution() {
        if (this.currentTestMonitor != null) {
            this.currentTestMonitor.setCanceled(true);
        }
    }

    private void execElement(IQ7NamedElement element, long timeout, IProgressMonitor monitor, TestCaseDebugger debugger, ExecutionPhase phase) throws CoreException {
        if (!element.exists()) {
            throw new CoreException(Q7LaunchingPlugin.createStatus("Resource does not exist: " + element));
        }
        if (element instanceof ITestCase || EclContextExecutable.isEclScriptContext(element)) {
            this.execTestOrEclContext(element, timeout, monitor, debugger);
        } else if (element instanceof IContext) {
            this.execContext((IContext)element, monitor);
        } else if (element instanceof IVerification) {
            this.execVerification((IVerification)element, monitor, phase);
        }
    }

    private void execContext(IContext contextElement, IProgressMonitor monitor) throws CoreException {
        ContextType type;
        org.eclipse.rcptt.core.scenario.Context context = (org.eclipse.rcptt.core.scenario.Context)EcoreUtil.copy((EObject)contextElement.getModifiedNamedElement());
        if (!(contextElement instanceof Q7InternalContext) && (type = contextElement.getType()) != null) {
            type.getMaker().makeExecutable(context, (IQ7NamedElement)contextElement);
        }
        EnterContext ec = Q7CoreFactory.eINSTANCE.createEnterContext();
        ec.setData(context);
        try {
            IStatus result = this.internalExecute((Command)ec, TeslaLimits.getContextRunnableTimeout(), monitor, null);
            if (!result.isOK()) {
                throw new CoreException(ExecAdvancedInfoUtil.askForAdvancedInfo((AutLaunch)this, result));
            }
        }
        catch (InterruptedException interruptedException) {
            throw new CoreException(ExecAdvancedInfoUtil.askForAdvancedInfo((AutLaunch)this, "Failed to apply context: " + contextElement.getElementName()));
        }
    }

    private void execVerification(IVerification verificationElement, IProgressMonitor monitor, ExecutionPhase phase) throws CoreException {
        VerificationType type;
        Verification verification = (Verification)EcoreUtil.copy((EObject)verificationElement.getModifiedNamedElement());
        if (!(verificationElement instanceof Q7InternalVerification) && (type = verificationElement.getType()) != null) {
            type.getMaker().makeExecutable(verification, (IQ7NamedElement)verificationElement);
        }
        ExecVerification command = Q7CoreFactory.eINSTANCE.createExecVerification();
        command.setVerification(verification);
        command.setPhase(phase);
        try {
            IStatus result = this.internalExecute((Command)command, TeslaLimits.getContextRunnableTimeout(), monitor, null);
            if (!result.isOK()) {
                throw new CoreException(ExecAdvancedInfoUtil.askForAdvancedInfo((AutLaunch)this, result));
            }
        }
        catch (InterruptedException interruptedException) {
            throw new CoreException(ExecAdvancedInfoUtil.askForAdvancedInfo((AutLaunch)this, "Failed to apply verification: " + verificationElement.getElementName()));
        }
    }

    private void execTestOrEclContext(IQ7NamedElement test, long timeout, IProgressMonitor monitor, TestCaseDebugger debugger) throws CoreException {
        block10: {
            this.currentTestMonitor = monitor;
            try {
                try {
                    NamedElement element = (NamedElement)EcoreUtil.copy((EObject)test.getModifiedNamedElement());
                    Script ecl = this.extractScript(element);
                    Map<String, String> properties = this.extractProperties(element);
                    TeslaScenario tesla = this.extractTesla(element);
                    HashMap<String, String> idToPathMap = new HashMap<String, String>();
                    if (ecl != null) {
                        if (debugger != null) {
                            DebugScript ds = CommandsFactory.eINSTANCE.createDebugScript();
                            IPath path = test.getPath();
                            ds.setPath(path.toString());
                            ds.setSession(debugger.getSessionId());
                            ds.setContent(ecl.getContent());
                            ds.setHost(ecl.getHost());
                            ds.getBindings().addAll(EcoreUtil.copyAll((Collection)ecl.getBindings()));
                            HashSet contexts = new HashSet();
                            RcpttCore.getInstance().findAllContexts(test, contexts);
                            for (IContext ctx : contexts) {
                                if (ctx.getResource() == null) continue;
                                String ctxId = ctx.getID();
                                String ctxPath = ctx.getResource().getFullPath().toPortableString();
                                ds.getPaths().put((Object)ctxId, (Object)ctxPath);
                                idToPathMap.put(ctxId, ctxPath);
                            }
                            ecl = ds;
                        }
                        this.doExecute(ecl, debugger, timeout, monitor, test.getID(), idToPathMap, properties);
                        break block10;
                    }
                    if (tesla != null) {
                        this.runTeslaScenario(tesla, monitor);
                        break block10;
                    }
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.launching", "Couldn't launch test case: invalid format"));
                }
                catch (CoreException e) {
                    if (e.getStatus() instanceof ExecutionStatus) {
                        ((ExecutionStatus)e.getStatus()).setElement(test);
                    }
                    throw e;
                }
            }
            finally {
                this.currentTestMonitor = null;
            }
        }
    }

    private Map<String, String> extractProperties(NamedElement element) {
        EList properties;
        HashMap<String, String> result = new HashMap<String, String>();
        if (element instanceof Scenario && (properties = ((Scenario)element).getProperties()).size() > 0) {
            for (ScenarioProperty p : properties) {
                result.put(p.getName(), p.getValue());
            }
        }
        return result;
    }

    private TeslaScenario extractTesla(NamedElement element) throws ModelException {
        if (element instanceof Scenario && Scenarios.isTeslaMode((Scenario)((Scenario)element))) {
            return Scenarios.getTesla((Scenario)((Scenario)element));
        }
        return null;
    }

    private Script extractScript(NamedElement element) throws ModelException {
        EStructuralFeature scriptFeature;
        if (element instanceof Scenario && Scenarios.isEclMode((Scenario)((Scenario)element))) {
            Script ecl = Scenarios.getEcl((Scenario)((Scenario)element));
            return ecl == null ? CoreFactory.eINSTANCE.createScript() : ecl;
        }
        if (element instanceof org.eclipse.rcptt.core.scenario.Context && (scriptFeature = element.eClass().getEStructuralFeature("script")) != null && scriptFeature.getEType().equals(CorePackage.Literals.SCRIPT)) {
            return (Script)element.eGet(scriptFeature);
        }
        return null;
    }

    @Override
    public synchronized void execute(Script script, long timeout, IProgressMonitor progressMonitor) throws CoreException {
        this.doExecute(script, null, timeout, progressMonitor, null, null, null);
    }

    protected void doExecute(Script script, TestCaseDebugger debugger, long timeout, IProgressMonitor progressMonitor, String id, Map<String, String> idToPathMap, Map<String, String> properties) throws CoreException {
        if (script == null) {
            return;
        }
        long stop = System.currentTimeMillis() + timeout;
        try {
            try {
                script = (Script)EcoreUtil.copy((EObject)script);
                List<Command> parts = BaseAutLaunch.splitByRestart((Command)script, id);
                SubMonitor sm = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)(parts.size() * 2 + 2));
                this.setupPlayer(stop - System.currentTimeMillis(), (IProgressMonitor)sm.newChild(1));
                Assert.isTrue((parts.size() > 0 ? 1 : 0) != 0);
                BaseAutLaunch.debugHook(script, parts, idToPathMap);
                Iterator<Command> it = parts.iterator();
                while (it.hasNext()) {
                    this.status = this.internalExecute(it.next(), stop - System.currentTimeMillis(), (IProgressMonitor)sm.newChild(1), properties);
                    if (!this.status.isOK()) {
                        throw new CoreException(this.status);
                    }
                    if (it.hasNext()) {
                        if (debugger != null) {
                            debugger.beforeRestart();
                        }
                        this.waitForRestart((IProgressMonitor)new NullProgressMonitor());
                        if (debugger != null) {
                            debugger.afterRestart();
                        }
                        this.setupPlayer(stop - System.currentTimeMillis(), (IProgressMonitor)sm.newChild(1));
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                throw new CoreException((IStatus)new Status(8, "org.eclipse.rcptt.launching", e.getMessage(), (Throwable)e));
            }
            catch (CoreException e) {
                if (e.getStatus() instanceof ScriptErrorStatus) {
                    throw new CoreException((IStatus)new ExecutionStatus(e.getStatus()));
                }
                throw e;
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.launching", "Failed to launch ECL scenario", (Throwable)e));
            }
        }
        catch (Throwable throwable) {
            try {
                this.shutdownPlayer();
            }
            catch (CoreException e) {
                Q7LaunchingPlugin.log(e.getStatus());
            }
            catch (InterruptedException interruptedException) {}
            throw throwable;
        }
        try {
            this.shutdownPlayer();
        }
        catch (CoreException e) {
            Q7LaunchingPlugin.log(e.getStatus());
        }
        catch (InterruptedException interruptedException) {}
    }

    private static void debugHook(Script main, List<Command> parts, Map<String, String> idToPathMap) {
        if (main instanceof DebugScript) {
            DebugScript ds = (DebugScript)main;
            ArrayList<Command> list = new ArrayList<Command>(parts);
            parts.clear();
            for (Command part : list) {
                DebugCommand dc = CommandsFactory.eINSTANCE.createDebugCommand();
                if (idToPathMap != null) {
                    for (Map.Entry<String, String> e : idToPathMap.entrySet()) {
                        dc.getPaths().put((Object)e.getKey(), (Object)e.getValue());
                    }
                }
                dc.setCommand(part);
                dc.setPath(ds.getPath());
                dc.setSession(ds.getSession());
                parts.add((Command)dc);
            }
        }
    }

    @Override
    public void waitForRestart(IProgressMonitor monitor) throws CoreException {
        this.aut.getExecutor().waitForRestart(this, monitor);
    }

    private void setupPlayer(long timeout, IProgressMonitor monitor) throws InterruptedException, CoreException {
        this.execute((Command)TeslaFactory.eINSTANCE.createSetupPlayer(), timeout, monitor);
    }

    private void shutdownPlayer() throws InterruptedException, CoreException {
        this.execute((Command)TeslaFactory.eINSTANCE.createShoutdownPlayer());
    }

    @Override
    public void shutdown() {
        try {
            ShutdownAut shutdownCmd = TeslaFactory.eINSTANCE.createShutdownAut();
            this.execute((Command)shutdownCmd);
        }
        catch (Exception e) {
            Q7LaunchingPlugin.log("Shutdown failed", e);
        }
        this.terminate();
    }

    /*
     * Exception decompiling
     */
    public void gracefulShutdown(int timeoutSeconds) throws CoreException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void terminate() {
        if (this.launch.canTerminate()) {
            try {
                this.launch.terminate();
            }
            catch (DebugException e) {
                Q7LaunchingPlugin.log("Termination failed", e);
            }
        }
    }

    @Override
    public void resetState() {
        this.currentState = null;
    }

    private void dumpState(ISession session) {
        try {
            List<Object> result = this.executeAndTakeAll(session, (Command)CoreFactory.eINSTANCE.createSaveState(), Q7Launcher.getLaunchTimeout() * 1000, (IProgressMonitor)new NullProgressMonitor());
            if (result.size() != 1) {
                return;
            }
            Object state = result.get(0);
            if (state instanceof SessionState) {
                this.currentState = (SessionState)state;
            }
        }
        catch (Exception e) {
            Q7LaunchingPlugin.log("error getting interpreter state", e);
        }
    }

    private void restoreState(ISession session, Map<String, String> properties) {
        if (this.currentState == null && properties == null) {
            return;
        }
        try {
            RestoreState command = CoreFactory.eINSTANCE.createRestoreState();
            if (this.currentState == null) {
                this.currentState = CoreFactory.eINSTANCE.createSessionState();
            }
            if (properties != null) {
                for (Map.Entry<String, String> e : properties.entrySet()) {
                    boolean found = false;
                    for (Declaration d : this.currentState.getDecls()) {
                        if (!(d instanceof Val) || !((Val)d).getName().equals(e.getKey())) continue;
                        ((Val)d).setValue((EObject)BoxedValues.box((String)e.getValue()));
                        found = true;
                        break;
                    }
                    if (found) continue;
                    Val declaration = CoreFactory.eINSTANCE.createVal();
                    declaration.setName(e.getKey());
                    declaration.setValue((EObject)BoxedValues.box((String)e.getValue()));
                    this.currentState.getDecls().add((Object)declaration);
                }
            }
            command.setState(this.currentState);
            session.execute((Command)command).waitFor();
        }
        catch (Exception e) {
            Q7LaunchingPlugin.log("error restoring interpreter state", e);
        }
    }

    private BooleanSupplier cancelledPredicate(IProgressMonitor monitor) {
        return monitor == null ? () -> false : () -> ((IProgressMonitor)monitor).isCanceled();
    }

    private IStatus internalExecute(Command command, long timeout, IProgressMonitor monitor, Map<String, String> properties) throws InterruptedException, CoreException {
        try {
            long stop = System.currentTimeMillis() + timeout;
            return (IStatus)this.computeInNewSession(TimeoutInterruption.forTimeout(monitor, timeout, this), session -> {
                this.restoreState(session, properties);
                try {
                    Command commandCopy = command;
                    IProcess process = session.execute(commandCopy);
                    IStatus processResult = process.waitFor(stop - System.currentTimeMillis(), monitor);
                    ExecutionStatus executionStatus = new ExecutionStatus(processResult);
                    return executionStatus;
                }
                finally {
                    if (monitor == null || !monitor.isCanceled()) {
                        this.dumpState(session);
                    }
                }
            });
        }
        catch (CoreException e) {
            throw new CoreException((IStatus)new MultiStatus("org.eclipse.rcptt.launching", 0, new IStatus[]{e.getStatus()}, "Failed to execute " + command, (Throwable)e));
        }
    }

    private IStatus runTeslaScenario(TeslaScenario scenario, IProgressMonitor progressMonitor) throws CoreException {
        IStatus[] s = new IStatus[]{Status.OK_STATUS};
        TeslaNetworkReplayer player = new TeslaNetworkReplayer(this.getHost(), this.getTeslaPort(), progressMonitor, new TeslaScenarioContainer(scenario), (IProgressInformer)new Q7TeslaProblemInformer(s));
        try {
            player.exec();
        }
        catch (Exception e) {
            throw new CoreException(Q7LaunchingPlugin.createStatus(e.getMessage(), e));
        }
        return s[0];
    }

    private static List<Command> splitByRestart(Command command, String id) throws CoreException {
        ArrayList<Command> list = new ArrayList<Command>();
        if (command instanceof Script) {
            Script script = (Script)command;
            return BaseAutLaunch.splitByRestart(EclCoreParser.newCommand((String)script.getContent(), (String)id), id);
        }
        if (command instanceof Sequence) {
            Sequence seq = (Sequence)command;
            if (!BaseAutLaunch.checkRestart((List<Command>)seq.getCommands())) {
                list.add(command);
                return list;
            }
            Sequence sub = CoreFactory.eINSTANCE.createSequence();
            for (Command c : seq.getCommands()) {
                if (BaseAutLaunch.isEclipseRestartCommand((EObject)c)) {
                    list.add((Command)sub);
                    sub = CoreFactory.eINSTANCE.createSequence();
                    continue;
                }
                sub.getCommands().add((Object)BaseAutLaunch.copy(c));
            }
            list.add((Command)sub);
        } else {
            BaseAutLaunch.checkForUnexpectedRestartInside(command);
            list.add(command);
        }
        return list;
    }

    private static Command copy(Command c) {
        return c != null ? (Command)EcoreUtil.copy((EObject)c) : null;
    }

    private static boolean checkRestart(List<Command> commands) throws CoreException {
        boolean haveRestarts = false;
        for (Command command : commands) {
            if (BaseAutLaunch.isEclipseRestartCommand((EObject)command)) {
                haveRestarts = true;
                continue;
            }
            BaseAutLaunch.checkForUnexpectedRestartInside(command);
        }
        return haveRestarts;
    }

    private static void checkForUnexpectedRestartInside(Command newCommand) throws CoreException {
        TreeIterator allContents = newCommand.eAllContents();
        while (allContents.hasNext()) {
            EObject o = (EObject)allContents.next();
            if (!BaseAutLaunch.isEclipseRestartCommand(o)) continue;
            StringBuilder msg = new StringBuilder();
            msg.append("Unexpected  use of ");
            msg.append(RESTART_COMMAND_NAME);
            msg.append(".\nIt must not be inside of pipes, blocks or substitutions.");
            ExecutionStatus es = new ExecutionStatus(4, "org.eclipse.rcptt.launching", msg.toString());
            AstExec restart = (AstExec)o;
            es.setLine(restart.getLine());
            es.setColumn(restart.getColumn());
            es.setLength(restart.getLength());
            throw new CoreException((IStatus)es);
        }
    }

    private static boolean isEclipseRestartCommand(EObject c) {
        AstExec exec;
        return c instanceof AstExec && RESTART_COMMAND_NAME.equals((exec = (AstExec)c).getName());
    }

    private ISession createEclSession() throws CoreException {
        try {
            return this.context.connect(this.getHost(), this.getEclPort());
        }
        catch (Exception e) {
            throw new CoreException(Q7LaunchingPlugin.createStatus("Couldn't open ECL session", e));
        }
    }

    @Override
    public void retarget(BaseAut newAut) {
        this.aut = newAut;
    }

    public void setLocationOnRestart(String location) {
        this.locationOnRestart = location;
    }

    public List<AutBundleState> getBundles() {
        if (this.autInit != null) {
            return new ArrayList<AutBundleState>((Collection<AutBundleState>)this.autInit.getBundleState());
        }
        return null;
    }

    @Override
    public String getCapability() {
        return this.autStart != null ? this.autStart.getCapability().getLiteral().toLowerCase() : null;
    }

    static interface Computation<T> {
        public T get(ISession var1) throws CoreException, InterruptedException;
    }

    public static interface Context {
        public ISession connect(String var1, int var2) throws IOException;
    }

    static interface Interruption {
        public void checkInterruption() throws CoreException;
    }

    private static final class TimeoutInterruption
    implements Interruption {
        private final BooleanSupplier isCancelled;
        private final long stop;
        private final long timeout;
        private final BaseAutLaunch launch;

        private TimeoutInterruption(BooleanSupplier isCancelled, long timeout, BaseAutLaunch launch) throws CoreException {
            this.isCancelled = isCancelled;
            this.launch = launch;
            if (timeout <= 0L) {
                throw new CoreException(launch.createTimeoutStatus(timeout));
            }
            this.stop = System.currentTimeMillis() + timeout;
            this.timeout = timeout;
        }

        public static TimeoutInterruption forTimeout(IProgressMonitor monitor, long timeout, BaseAutLaunch launch) throws CoreException {
            BooleanSupplier supplier = monitor == null ? () -> false : () -> ((IProgressMonitor)monitor).isCanceled();
            return new TimeoutInterruption(supplier, timeout, launch);
        }

        @Override
        public void checkInterruption() throws CoreException {
            if (this.isCancelled.getAsBoolean()) {
                throw new CoreException(Status.CANCEL_STATUS);
            }
            if (this.stop < System.currentTimeMillis()) {
                throw new CoreException(this.launch.createTimeoutStatus(this.timeout));
            }
        }
    }
}

