/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.reporting.html;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.rcptt.reporting.core.IReportRenderer;
import org.eclipse.rcptt.reporting.html.HtmlReportRenderer;
import org.eclipse.rcptt.reporting.html.internal.Plugin;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Node;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Report;
import org.eclipse.rcptt.util.FileUtil;

public class HtmlReporter
extends HtmlReportRenderer {
    private int nameIndex = 0;

    private String getNewFileName(Node node, IReportRenderer.IContentFactory factory) {
        String prefix = "_" + this.getNodeName(node);
        String fname = String.valueOf(prefix) + ".html";
        fname = String.valueOf(prefix) + "_" + this.nameIndex++ + ".html";
        return fname;
    }

    @Override
    protected void renderFailed(PrintWriter writer, IReportRenderer.IContentFactory content, Iterable<Report> failedReports) throws CoreException {
        writer.println("<table class=\"failure\">");
        for (Report report : failedReports) {
            try {
                this.renderNameAndDuration(writer, report, content);
            }
            catch (Exception e) {
                Plugin.UTILS.log(Plugin.UTILS.createError((Throwable)e));
                e.printStackTrace(writer);
            }
        }
        writer.println("</table>");
    }

    protected static void copyResource(IReportRenderer.IContentFactory content, IPath path) throws CoreException {
        try {
            FileUtil.copy((InputStream)HtmlReportRenderer.class.getResourceAsStream(path.toPortableString()), (OutputStream)content.createFileStream(path.lastSegment()));
        }
        catch (IOException e) {
            throw new CoreException(Plugin.UTILS.createError((Throwable)e));
        }
    }

    @Override
    protected void renderNameAndDuration(PrintWriter writer, Report report, IReportRenderer.IContentFactory content) throws CoreException {
        Node root = report.getRoot();
        if (root == null) {
            writer.println("<tr><td>Empty report</td><td></td></tr>");
            return;
        }
        long millseconds = root.getDuration();
        String duration = this.durationFormat.format((float)millseconds / 1000.0f);
        writer.println("<tr><td>");
        String fileName = this.getNewFileName(root, content);
        PrintWriter childWriter = null;
        try {
            OutputStream os = content.createFileStream(fileName);
            childWriter = new PrintWriter(new OutputStreamWriter(os, Charsets.UTF_8));
            childWriter.println("<html>");
            this.renderHead(childWriter, root.getName());
            childWriter.println("<body onload=\"installDetailsWorkaround()\">");
            this.renderFailed(childWriter, report, content);
            childWriter.println("</body></html>");
        }
        catch (Throwable throwable) {
            FileUtil.safeClose(childWriter);
            throw throwable;
        }
        FileUtil.safeClose((Closeable)childWriter);
        writer.println(String.format("<a href=\"%s\">%s</a>", fileName, root.getName()));
        writer.println("</td><td>" + duration + " s</td></tr>");
    }

    @Override
    protected void renderHead(PrintWriter writer, String title) {
        writer.println("<head>");
        if (!Strings.isNullOrEmpty((String)title)) {
            writer.println("<title>" + title + "</title>");
        }
        writer.println("<link href=\"rcptt.css\" rel=\"stylesheet\">");
        writer.println("<script type=\"text/javascript\" src =\"rcptt.js\"></script>");
        writer.println("</head>");
    }

    @Override
    protected void renderReport(PrintWriter writer, Iterable<Report> reports, IReportRenderer.IContentFactory content) throws CoreException {
        HtmlReporter.copyResource(content, Path.fromPortableString((String)"/templates/rcptt.css"));
        HtmlReporter.copyResource(content, Path.fromPortableString((String)"/templates/rcptt.js"));
        super.renderReport(writer, reports, content);
    }
}

