/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.sshd;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.CancellationException;
import org.eclipse.jgit.internal.transport.sshd.EncryptedFileKeyPairProvider;
import org.eclipse.jgit.internal.transport.sshd.SshdText;
import org.eclipse.jgit.transport.sshd.KeyCache;

public class CachingKeyPairProvider
extends EncryptedFileKeyPairProvider
implements Iterable<KeyPair> {
    private final KeyCache cache;

    public CachingKeyPairProvider(List<Path> paths, KeyCache cache) {
        super(paths);
        this.cache = cache;
    }

    @Override
    public Iterator<KeyPair> iterator() {
        Collection resources = this.getPaths();
        if (resources.isEmpty()) {
            return Collections.emptyListIterator();
        }
        return new CancellingKeyPairIterator(resources);
    }

    public Iterable<KeyPair> loadKeys() {
        return this;
    }

    protected KeyPair doLoadKey(Path resource) throws IOException, GeneralSecurityException {
        if (!Files.exists(resource, new LinkOption[0])) {
            this.log.warn(MessageFormat.format(SshdText.get().identityFileNotFound, resource));
            return null;
        }
        String resourceId = resource.toString();
        if (this.cache == null) {
            return this.doLoadKey(resourceId, resource, this.getPasswordFinder());
        }
        Throwable[] t = new Throwable[1];
        KeyPair key = this.cache.get(resource, p -> {
            try {
                return this.doLoadKey(resourceId, p, this.getPasswordFinder());
            }
            catch (IOException | GeneralSecurityException e) {
                throwableArray[0] = e;
                return null;
            }
        });
        if (t[0] != null) {
            if (t[0] instanceof CancellationException) {
                throw (CancellationException)t[0];
            }
            throw new IOException(MessageFormat.format(SshdText.get().keyLoadFailed, resource), t[0]);
        }
        return key;
    }

    private class CancellingKeyPairIterator
    implements Iterator<KeyPair> {
        private final Iterator<Path> paths;
        private KeyPair nextItem;
        private boolean nextSet;

        public CancellingKeyPairIterator(Collection<? extends Path> resources) {
            ArrayList<? extends Path> copy = new ArrayList<Path>(resources.size());
            copy.addAll(resources);
            this.paths = copy.iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.nextSet) {
                return this.nextItem != null;
            }
            this.nextSet = true;
            while (this.nextItem == null && this.paths.hasNext()) {
                try {
                    this.nextItem = CachingKeyPairProvider.this.doLoadKey(this.paths.next());
                }
                catch (CancellationException cancelled) {
                    throw cancelled;
                }
                catch (Exception other) {
                    CachingKeyPairProvider.this.log.warn(other.toString());
                }
            }
            return this.nextItem != null;
        }

        @Override
        public KeyPair next() {
            if (!this.nextSet && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            KeyPair result = this.nextItem;
            this.nextItem = null;
            this.nextSet = false;
            if (result == null) {
                throw new NoSuchElementException();
            }
            return result;
        }
    }
}

