/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.mapping;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.mapping.provider.ResourceDiffTree;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.mapping.ResourceModelParticipantAction;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.ui.PlatformUI;

public class RemoveFromViewAction
extends ResourceModelParticipantAction {
    public RemoveFromViewAction(ISynchronizePageConfiguration configuration) {
        super(null, configuration);
        Utils.initAction((IAction)this, "action.removeFromView.");
        this.setId("org.eclipse.team.internal.ui.RemoveFromView");
    }

    public void run() {
        if (this.confirmRemove()) {
            try {
                PlatformUI.getWorkbench().getProgressService().run(true, true, monitor -> {
                    try {
                        this.performRemove(monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                });
            }
            catch (InvocationTargetException e) {
                Utils.handle(e);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void performRemove(IProgressMonitor monitor) throws CoreException {
        IResource[] resources = this.getVisibleResources(monitor);
        if (resources.length == 0) {
            return;
        }
        ResourceDiffTree tree = (ResourceDiffTree)this.getSynchronizationContext().getDiffTree();
        try {
            tree.beginInput();
            int i = 0;
            while (i < resources.length) {
                IResource resource = resources[i];
                tree.remove(resource);
                ++i;
            }
        }
        finally {
            tree.endInput(monitor);
        }
    }

    private IResource[] getVisibleResources(IProgressMonitor monitor) throws CoreException {
        ResourceTraversal[] traversals = this.getResourceTraversals(this.getStructuredSelection(), monitor);
        IDiff[] diffs = this.getSynchronizationContext().getDiffTree().getDiffs(traversals);
        ArrayList<IResource> result = new ArrayList<IResource>();
        int i = 0;
        while (i < diffs.length) {
            IDiff diff = diffs[i];
            if (this.isVisible(diff)) {
                result.add(ResourceDiffTree.getResourceFor((IDiff)diff));
            }
            ++i;
        }
        return result.toArray(new IResource[result.size()]);
    }

    private boolean confirmRemove() {
        IPreferenceStore store = TeamUIPlugin.getPlugin().getPreferenceStore();
        if (store.getBoolean("org.eclipse.team.ui.remove_from_view_without_prompt")) {
            return true;
        }
        MessageDialogWithToggle dialog = MessageDialogWithToggle.openOkCancelConfirm((Shell)this.getConfiguration().getSite().getShell(), (String)TeamUIMessages.RemoveFromView_warningTitle, (String)TeamUIMessages.RemoveFromView_warningMessage, (String)TeamUIMessages.RemoveFromView_warningDontShow, (boolean)false, null, null);
        store.setValue("org.eclipse.team.ui.remove_from_view_without_prompt", dialog.getToggleState());
        return dialog.getReturnCode() == 0;
    }

    @Override
    protected boolean isEnabledForSelection(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        for (Object element : selection) {
            if (Utils.getResource(element) != null) continue;
            return false;
        }
        return true;
    }
}

