/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.activities;

import java.util.Set;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.internal.util.Util;

public final class ActivityManagerEvent {
    private IActivityManager activityManager;
    private boolean definedActivityIdsChanged;
    private boolean definedCategoryIdsChanged;
    private boolean enabledActivityIdsChanged;
    private final Set previouslyDefinedActivityIds;
    private final Set previouslyDefinedCategoryIds;
    private final Set previouslyEnabledActivityIds;

    public ActivityManagerEvent(IActivityManager activityManager, boolean definedActivityIdsChanged, boolean definedCategoryIdsChanged, boolean enabledActivityIdsChanged, Set previouslyDefinedActivityIds, Set previouslyDefinedCategoryIds, Set previouslyEnabledActivityIds) {
        if (activityManager == null) {
            throw new NullPointerException();
        }
        if (!definedActivityIdsChanged && previouslyDefinedActivityIds != null) {
            throw new IllegalArgumentException();
        }
        if (!definedCategoryIdsChanged && previouslyDefinedCategoryIds != null) {
            throw new IllegalArgumentException();
        }
        if (!enabledActivityIdsChanged && previouslyEnabledActivityIds != null) {
            throw new IllegalArgumentException();
        }
        this.previouslyDefinedActivityIds = definedActivityIdsChanged ? Util.safeCopy(previouslyDefinedActivityIds, String.class) : null;
        this.previouslyDefinedCategoryIds = definedCategoryIdsChanged ? Util.safeCopy(previouslyDefinedCategoryIds, String.class) : null;
        this.previouslyEnabledActivityIds = enabledActivityIdsChanged ? Util.safeCopy(previouslyEnabledActivityIds, String.class) : null;
        this.activityManager = activityManager;
        this.definedActivityIdsChanged = definedActivityIdsChanged;
        this.definedCategoryIdsChanged = definedCategoryIdsChanged;
        this.enabledActivityIdsChanged = enabledActivityIdsChanged;
    }

    public IActivityManager getActivityManager() {
        return this.activityManager;
    }

    public Set getPreviouslyDefinedActivityIds() {
        return this.previouslyDefinedActivityIds;
    }

    public Set getPreviouslyDefinedCategoryIds() {
        return this.previouslyDefinedCategoryIds;
    }

    public Set getPreviouslyEnabledActivityIds() {
        return this.previouslyEnabledActivityIds;
    }

    public boolean haveDefinedActivityIdsChanged() {
        return this.definedActivityIdsChanged;
    }

    public boolean haveDefinedCategoryIdsChanged() {
        return this.definedCategoryIdsChanged;
    }

    public boolean haveEnabledActivityIdsChanged() {
        return this.enabledActivityIdsChanged;
    }
}

