/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCacheEntry;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffData;
import org.eclipse.egit.core.internal.job.RuleUtil;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.actions.RepositoryActionHandler;
import org.eclipse.egit.ui.internal.commit.CommitUI;
import org.eclipse.egit.ui.internal.operations.GitScopeUtil;
import org.eclipse.egit.ui.internal.staging.StagingView;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class CommitActionHandler
extends RepositoryActionHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        final Repository repository = this.getRepository(true, event);
        if (repository == null) {
            return null;
        }
        IPreferenceStore uiPreferences = Activator.getDefault().getPreferenceStore();
        boolean useStagingView = uiPreferences.getBoolean("always_use_staging_view");
        if (useStagingView) {
            if (uiPreferences.getBoolean("auto_stage_on_commit")) {
                boolean includeUntracked = uiPreferences.getBoolean("commit_dialog_include_untracked");
                this.autoStage(repository, includeUntracked, this.getResourcesInScope(event));
            }
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        StagingView view = (StagingView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.egit.ui.StagingView");
                        if (view.getCurrentRepository() != repository) {
                            view.reload(repository);
                        }
                        view.setFocus();
                    }
                    catch (PartInitException e) {
                        Activator.logError(e.getMessage(), e);
                    }
                }
            });
        } else {
            Shell shell = this.getShell(event);
            IResource[] resourcesInScope = this.getResourcesInScope(event);
            if (resourcesInScope != null) {
                CommitUI commitUi = new CommitUI(shell, repository, resourcesInScope, false);
                commitUi.commit();
            }
        }
        return null;
    }

    private IResource[] getResourcesInScope(ExecutionEvent event) throws ExecutionException {
        try {
            IResource[] selectedResources = this.getSelectedResources(event);
            if (selectedResources.length > 0) {
                IWorkbenchPart part = this.getPart(event);
                return GitScopeUtil.getRelatedChanges(part, selectedResources);
            }
            return new IResource[0];
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    private IndexDiffData getIndexDiffData(final @NonNull Repository repository, final @NonNull Collection<IProject> projects) {
        IndexDiffCacheEntry diffCacheEntry = org.eclipse.egit.core.Activator.getDefault().getIndexDiffCache().getIndexDiffCacheEntry(repository);
        IndexDiffData diff = null;
        if (diffCacheEntry != null) {
            diff = diffCacheEntry.getIndexDiff();
        }
        if (diff != null) {
            return diff;
        }
        final IndexDiffData[] result = new IndexDiffData[1];
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        result[0] = new IndexDiffData(CommitUI.getIndexDiff(repository, projects.toArray(new IProject[projects.size()]), monitor));
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            Activator.handleError(UIText.CommitAction_errorComputingDiffs, e.getCause(), true);
            return null;
        }
        catch (InterruptedException e) {
            return null;
        }
        return result[0];
    }

    private void autoStage(final @NonNull Repository repository, boolean includeUntracked, IResource[] resourcesInScope) {
        if (resourcesInScope == null || resourcesInScope.length == 0) {
            return;
        }
        HashSet<IProject> projects = new HashSet<IProject>();
        IResource[] iResourceArray = resourcesInScope;
        int n = resourcesInScope.length;
        int n2 = 0;
        while (n2 < n) {
            IResource rsc = iResourceArray[n2];
            projects.add(rsc.getProject());
            ++n2;
        }
        IndexDiffData diff = this.getIndexDiffData(repository, projects);
        if (diff == null) {
            return;
        }
        HashSet<String> mayBeCommitted = new HashSet<String>();
        mayBeCommitted.addAll(diff.getAdded());
        mayBeCommitted.addAll(diff.getChanged());
        mayBeCommitted.addAll(diff.getRemoved());
        mayBeCommitted.addAll(diff.getModified());
        mayBeCommitted.addAll(diff.getMissing());
        if (!includeUntracked) {
            mayBeCommitted.removeAll(diff.getUntracked());
        } else {
            mayBeCommitted.addAll(diff.getUntracked());
        }
        mayBeCommitted.removeAll(diff.getAssumeUnchanged());
        final Set<String> toBeStaged = CommitUI.getSelectedFiles(repository, mayBeCommitted, resourcesInScope);
        if (toBeStaged.isEmpty()) {
            return;
        }
        Job job = new Job(UIText.AddToIndexAction_addingFiles){

            /*
             * Exception decompiling
             */
            protected IStatus run(IProgressMonitor monitor) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 13[WHILELOOP]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            public boolean belongsTo(Object family) {
                return JobFamilies.ADD_TO_INDEX.equals(family) || super.belongsTo(family);
            }
        };
        job.setUser(true);
        job.setRule(RuleUtil.getRule((Repository)repository));
        job.schedule();
    }

    @Override
    public boolean isEnabled() {
        return this.selectionMapsToSingleRepository();
    }
}

