/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.internal.core;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.rcptt.tesla.core.server.TeslaServerManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;

public class TeslaCore
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.rcptt.tesla.core";
    private static TeslaCore plugin;
    public static boolean LOGGING;
    private static Version platformVersion;

    static {
        LOGGING = false;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        DebugOptions service = null;
        ServiceReference reference = context.getServiceReference(DebugOptions.class.getName());
        if (reference != null) {
            service = (DebugOptions)context.getService(reference);
        }
        if (service == null) {
            return;
        }
        try {
            LOGGING = service.getBooleanOption("org.eclipse.rcptt.tesla.core/logging", false);
        }
        finally {
            context.ungetService(reference);
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
        TeslaServerManager.stopServer();
    }

    public static TeslaCore getDefault() {
        return plugin;
    }

    public static void log(Throwable t) {
        if (t instanceof ClassNotFoundException || t instanceof NoClassDefFoundError) {
            return;
        }
        if (TeslaCore.getDefault() != null) {
            TeslaCore.getDefault().getLog().log(TeslaCore.createError(t));
        }
    }

    public static void log(String message) {
        TeslaCore.getDefault().getLog().log(TeslaCore.createError(message));
    }

    public static IEclipsePreferences getPreferences() {
        return new InstanceScope().getNode(PLUGIN_ID);
    }

    public static Version getPlatformVersion() {
        if (platformVersion == null) {
            Bundle bundle = Platform.getBundle((String)"org.eclipse.ui");
            if (bundle == null) {
                bundle = Platform.getBundle((String)"org.eclipse.osgi");
            }
            platformVersion = bundle.getVersion();
        }
        return platformVersion;
    }

    public static boolean isEclipse4() {
        Version version = TeslaCore.getPlatformVersion();
        return version.getMajor() == 3 && version.getMinor() >= 103;
    }

    public static boolean isEclipse46() {
        Version version = TeslaCore.getPlatformVersion();
        return version.getMajor() == 3 && version.getMinor() >= 107;
    }

    public static IStatus createError(String message) {
        return TeslaCore.createError(message, null);
    }

    public static IStatus createError(Throwable t) {
        return TeslaCore.createError(t.getMessage(), t);
    }

    public static IStatus createError(String message, Throwable t) {
        return new Status(4, PLUGIN_ID, message, t);
    }
}

