/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.actions;

import java.lang.reflect.InvocationTargetException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.synchronize.FastSyncInfoFilter;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSet;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSetManager;
import org.eclipse.team.internal.core.subscribers.ChangeSet;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.synchronize.ChangeSetCapability;
import org.eclipse.team.internal.ui.synchronize.ChangeSetModelProvider;
import org.eclipse.team.internal.ui.synchronize.ChangeSetModelSorter;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.SubscriberParticipant;
import org.eclipse.team.ui.synchronize.SynchronizeModelAction;
import org.eclipse.team.ui.synchronize.SynchronizeModelOperation;
import org.eclipse.team.ui.synchronize.SynchronizePageActionGroup;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class ChangeSetActionGroup
extends SynchronizePageActionGroup {
    public static final String CHANGE_SET_GROUP = "change_set_group";
    private static final String P_LAST_COMMENTSORT = "org.eclipse.team.ui.P_LAST_COMMENT_SORT";
    public static final FastSyncInfoFilter OUTGOING_RESOURCE_FILTER = new FastSyncInfoFilter.SyncInfoDirectionFilter(new int[]{4, 12});
    private ChangeSetModelProvider provider;
    private MenuManager sortByComment;
    private CreateChangeSetAction createChangeSet;
    private MenuManager addToChangeSet;
    private EditChangeSetAction editChangeSet;
    private RemoveChangeSetAction removeChangeSet;
    private MakeDefaultChangeSetAction makeDefault;
    private SynchronizePageActionGroup subActions;
    private int sortCriteria = 1;

    public static int getSortCriteria(ISynchronizePageConfiguration configuration) {
        int sortCriteria = 1;
        try {
            IDialogSettings pageSettings = configuration.getSite().getPageSettings();
            if (pageSettings != null) {
                sortCriteria = pageSettings.getInt(P_LAST_COMMENTSORT);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        switch (sortCriteria) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                sortCriteria = 1;
            }
        }
        return sortCriteria;
    }

    public ChangeSetActionGroup(ChangeSetModelProvider provider) {
        this.provider = provider;
    }

    @Override
    public void initialize(ISynchronizePageConfiguration configuration) {
        super.initialize(configuration);
        if (this.getChangeSetCapability().supportsCheckedInChangeSets()) {
            this.sortCriteria = ChangeSetActionGroup.getSortCriteria(configuration);
            this.sortByComment = new MenuManager(TeamUIMessages.ChangeLogModelProvider_0a);
            this.sortByComment.add((IAction)new ToggleSortOrderAction(TeamUIMessages.ChangeLogModelProvider_1a, 2));
            this.sortByComment.add((IAction)new ToggleSortOrderAction(TeamUIMessages.ChangeLogModelProvider_2a, 1));
            this.sortByComment.add((IAction)new ToggleSortOrderAction(TeamUIMessages.ChangeLogModelProvider_3a, 3));
        }
        if (this.getChangeSetCapability().supportsActiveChangeSets()) {
            this.addToChangeSet = new MenuManager(TeamUIMessages.ChangeLogModelProvider_12);
            this.addToChangeSet.setRemoveAllWhenShown(true);
            this.addToChangeSet.addMenuListener(manager -> this.addChangeSets(manager));
            this.createChangeSet = new CreateChangeSetAction(configuration);
            this.addToChangeSet.add((IAction)this.createChangeSet);
            this.addToChangeSet.add((IContributionItem)new Separator());
            this.editChangeSet = new EditChangeSetAction(configuration);
            this.makeDefault = new MakeDefaultChangeSetAction(configuration);
            this.removeChangeSet = new RemoveChangeSetAction(configuration);
        }
        this.subActions = this.getChangeSetCapability().getActionGroup();
        if (this.subActions != null) {
            this.subActions.initialize(configuration);
        }
    }

    @Override
    public void fillContextMenu(IMenuManager menu) {
        if (this.getChangeSetCapability().enableCheckedInChangeSetsFor(this.getConfiguration())) {
            this.appendToGroup((IContributionManager)menu, "sort", (IContributionItem)this.sortByComment);
        }
        if (this.getChangeSetCapability().enableActiveChangeSetsFor(this.getConfiguration())) {
            this.appendToGroup((IContributionManager)menu, CHANGE_SET_GROUP, (IContributionItem)this.addToChangeSet);
            this.appendToGroup((IContributionManager)menu, CHANGE_SET_GROUP, (IAction)this.editChangeSet);
            this.appendToGroup((IContributionManager)menu, CHANGE_SET_GROUP, (IAction)this.removeChangeSet);
            this.appendToGroup((IContributionManager)menu, CHANGE_SET_GROUP, (IAction)this.makeDefault);
        }
        if (this.subActions != null) {
            this.subActions.fillContextMenu(menu);
        }
    }

    protected void addChangeSets(IMenuManager manager) {
        ChangeSet[] sets = this.getActiveChangeSetManager().getSets();
        Arrays.sort(sets, new Comparator<ChangeSet>(){
            private Collator collator = Collator.getInstance();

            @Override
            public int compare(ChangeSet o1, ChangeSet o2) {
                return this.collator.compare(o1.getName(), o2.getName());
            }
        });
        ISelection selection = this.getContext().getSelection();
        this.createChangeSet.selectionChanged(selection);
        this.addToChangeSet.add((IAction)this.createChangeSet);
        this.addToChangeSet.add((IContributionItem)new Separator());
        int i = 0;
        while (i < sets.length) {
            ActiveChangeSet set = (ActiveChangeSet)sets[i];
            AddToChangeSetAction action = new AddToChangeSetAction(this.getConfiguration(), set, selection);
            manager.add((IAction)action);
            ++i;
        }
        this.addToChangeSet.add((IContributionItem)new Separator());
        this.addToChangeSet.add((IAction)new AddToChangeSetAction(this.getConfiguration(), null, selection));
    }

    protected ActiveChangeSetManager getActiveChangeSetManager() {
        return this.getChangeSetCapability().getActiveChangeSetManager();
    }

    @Override
    public void dispose() {
        if (this.addToChangeSet != null) {
            this.addToChangeSet.dispose();
            this.addToChangeSet.removeAll();
        }
        if (this.sortByComment != null) {
            this.sortByComment.dispose();
            this.sortByComment.removeAll();
        }
        if (this.subActions != null) {
            this.subActions.dispose();
        }
        super.dispose();
    }

    public void updateActionBars() {
        if (this.editChangeSet != null) {
            this.editChangeSet.selectionChanged((IStructuredSelection)this.getContext().getSelection());
        }
        if (this.removeChangeSet != null) {
            this.removeChangeSet.selectionChanged((IStructuredSelection)this.getContext().getSelection());
        }
        if (this.makeDefault != null) {
            this.makeDefault.selectionChanged((IStructuredSelection)this.getContext().getSelection());
        }
        super.updateActionBars();
    }

    private void syncExec(Runnable runnable) {
        Control ctrl = this.getConfiguration().getPage().getViewer().getControl();
        if (ctrl != null && !ctrl.isDisposed()) {
            ctrl.getDisplay().syncExec(() -> {
                if (!ctrl.isDisposed()) {
                    runnable.run();
                }
            });
        }
    }

    public ViewerSorter getViewerSorter() {
        return new ChangeSetModelSorter(this.provider, this.sortCriteria);
    }

    private ActiveChangeSet createChangeSet(IDiff[] diffs) {
        return this.getChangeSetCapability().createChangeSet(this.getConfiguration(), diffs);
    }

    private void editChangeSet(ActiveChangeSet set) {
        this.getChangeSetCapability().editChangeSet(this.getConfiguration(), set);
    }

    private ChangeSetCapability getChangeSetCapability() {
        return this.provider.getChangeSetCapability();
    }

    private IDiff[] getDiffs(IResource[] resources) {
        ArrayList<IDiff> diffs = new ArrayList<IDiff>();
        Subscriber s = ((SubscriberParticipant)this.getConfiguration().getParticipant()).getSubscriber();
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            try {
                IDiff diff = s.getDiff(resource);
                if (diff != null) {
                    diffs.add(diff);
                }
            }
            catch (CoreException e) {
                TeamUIPlugin.log(e);
            }
            ++i;
        }
        IDiff[] diffArray = diffs.toArray(new IDiff[diffs.size()]);
        return diffArray;
    }

    private class AddToChangeSetAction
    extends SynchronizeModelAction {
        private final ActiveChangeSet set;

        public AddToChangeSetAction(ISynchronizePageConfiguration configuration, ActiveChangeSet set, ISelection selection) {
            super(set == null ? TeamUIMessages.ChangeSetActionGroup_2 : LegacyActionTools.escapeMnemonics((String)set.getTitle()), configuration);
            this.set = set;
            this.selectionChanged(selection);
        }

        @Override
        protected FastSyncInfoFilter getSyncInfoFilter() {
            return OUTGOING_RESOURCE_FILTER;
        }

        @Override
        protected boolean needsToSaveDirtyEditors() {
            return false;
        }

        @Override
        protected SynchronizeModelOperation getSubscriberOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
            return new SynchronizeModelOperation(configuration, elements){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    IResource[] resources = this.getSyncInfoSet().getResources();
                    if (AddToChangeSetAction.this.set != null) {
                        IDiff[] diffArray = ChangeSetActionGroup.this.getDiffs(resources);
                        AddToChangeSetAction.this.set.add(diffArray);
                    } else {
                        ChangeSet[] sets = ChangeSetActionGroup.this.getActiveChangeSetManager().getSets();
                        int i = 0;
                        while (i < sets.length) {
                            ActiveChangeSet activeSet = (ActiveChangeSet)sets[i];
                            activeSet.remove(resources);
                            ++i;
                        }
                    }
                }
            };
        }
    }

    private abstract class ChangeSetAction
    extends BaseSelectionListenerAction {
        public ChangeSetAction(String title, ISynchronizePageConfiguration configuration) {
            super(title);
        }

        protected boolean updateSelection(IStructuredSelection selection) {
            return this.getSelectedSet() != null;
        }

        protected ActiveChangeSet getSelectedSet() {
            Object adapter;
            Object first;
            IStructuredSelection selection = this.getStructuredSelection();
            if (selection.size() == 1 && (first = selection.getFirstElement()) instanceof IAdaptable && (adapter = ((IAdaptable)first).getAdapter(ChangeSet.class)) instanceof ActiveChangeSet) {
                return (ActiveChangeSet)adapter;
            }
            return null;
        }
    }

    private class CreateChangeSetAction
    extends SynchronizeModelAction {
        public CreateChangeSetAction(ISynchronizePageConfiguration configuration) {
            super(TeamUIMessages.ChangeLogModelProvider_0, configuration);
        }

        @Override
        protected boolean needsToSaveDirtyEditors() {
            return false;
        }

        @Override
        protected FastSyncInfoFilter getSyncInfoFilter() {
            return OUTGOING_RESOURCE_FILTER;
        }

        @Override
        protected SynchronizeModelOperation getSubscriberOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
            return new SynchronizeModelOperation(configuration, elements){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    ChangeSetActionGroup.this.syncExec(() -> {
                        ActiveChangeSet set = ChangeSetActionGroup.this.createChangeSet(ChangeSetActionGroup.this.getDiffs(this.getSyncInfoSet().getResources()));
                        if (set != null) {
                            ChangeSetActionGroup.this.getActiveChangeSetManager().add((ChangeSet)set);
                        }
                    });
                }
            };
        }
    }

    private class EditChangeSetAction
    extends ChangeSetAction {
        public EditChangeSetAction(ISynchronizePageConfiguration configuration) {
            super(TeamUIMessages.ChangeLogModelProvider_6, configuration);
        }

        public void run() {
            ActiveChangeSet set = this.getSelectedSet();
            if (set == null) {
                return;
            }
            ChangeSetActionGroup.this.editChangeSet(set);
        }
    }

    private class MakeDefaultChangeSetAction
    extends ChangeSetAction {
        public MakeDefaultChangeSetAction(ISynchronizePageConfiguration configuration) {
            super(TeamUIMessages.ChangeLogModelProvider_9, configuration);
        }

        @Override
        protected boolean updateSelection(IStructuredSelection selection) {
            if (this.getSelectedSet() != null) {
                this.setText(TeamUIMessages.ChangeLogModelProvider_9);
                this.setChecked(this.getSelectedSet().equals(ChangeSetActionGroup.this.getActiveChangeSetManager().getDefaultSet()));
            } else {
                this.setText(TeamUIMessages.ChangeLogModelProvider_10);
                this.setChecked(false);
            }
            return true;
        }

        public void run() {
            ChangeSetActionGroup.this.getActiveChangeSetManager().makeDefault(this.isChecked() ? this.getSelectedSet() : null);
            if (this.getSelectedSet() == null) {
                this.setChecked(false);
            }
        }
    }

    private class RemoveChangeSetAction
    extends ChangeSetAction {
        public RemoveChangeSetAction(ISynchronizePageConfiguration configuration) {
            super(TeamUIMessages.ChangeLogModelProvider_7, configuration);
        }

        public void run() {
            ActiveChangeSet set = this.getSelectedSet();
            if (set == null) {
                return;
            }
            if (MessageDialog.openConfirm((Shell)ChangeSetActionGroup.this.getConfiguration().getSite().getShell(), (String)TeamUIMessages.ChangeSetActionGroup_0, (String)NLS.bind((String)TeamUIMessages.ChangeSetActionGroup_1, (Object[])new String[]{LegacyActionTools.escapeMnemonics((String)set.getTitle())}))) {
                ChangeSetActionGroup.this.getActiveChangeSetManager().remove((ChangeSet)set);
            }
        }
    }

    private class ToggleSortOrderAction
    extends Action {
        private int criteria;

        protected ToggleSortOrderAction(String name, int criteria) {
            super(name, 8);
            this.criteria = criteria;
            this.update();
        }

        public void run() {
            if (this.isChecked() && ChangeSetActionGroup.this.sortCriteria != this.criteria) {
                ChangeSetActionGroup.this.sortCriteria = this.criteria;
                String key = this.getSettingsKey();
                IDialogSettings pageSettings = ChangeSetActionGroup.this.getConfiguration().getSite().getPageSettings();
                if (pageSettings != null) {
                    pageSettings.put(key, this.criteria);
                }
                this.update();
                ChangeSetActionGroup.this.provider.setViewerSorter(ChangeSetActionGroup.this.getViewerSorter());
            }
        }

        public void update() {
            this.setChecked(this.criteria == ChangeSetActionGroup.this.sortCriteria);
        }

        protected String getSettingsKey() {
            return ChangeSetActionGroup.P_LAST_COMMENTSORT;
        }
    }
}

