/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.pde.api.tools.internal.model.ApiElement;
import org.eclipse.pde.api.tools.internal.model.ApiModelCache;
import org.eclipse.pde.api.tools.internal.provisional.model.ApiTypeContainerVisitor;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiElement;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeContainer;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeRoot;

public abstract class AbstractApiTypeContainer
extends ApiElement
implements IApiTypeContainer {
    private List<IApiTypeContainer> fApiTypeContainers = null;

    protected AbstractApiTypeContainer(IApiElement parent, int type, String name) {
        super(parent, type, name);
    }

    @Override
    public void accept(ApiTypeContainerVisitor visitor) throws CoreException {
        IApiTypeContainer[] containers = this.getApiTypeContainers();
        int i = 0;
        while (i < containers.length) {
            containers[i].accept(visitor);
            ++i;
        }
    }

    @Override
    public synchronized void close() throws CoreException {
        if (this.fApiTypeContainers == null) {
            return;
        }
        ApiModelCache.getCache().removeElementInfo(this);
        MultiStatus multi = null;
        IStatus single = null;
        IApiTypeContainer[] containers = this.getApiTypeContainers();
        int i = 0;
        while (i < containers.length) {
            try {
                containers[i].close();
            }
            catch (CoreException e) {
                if (single == null) {
                    single = e.getStatus();
                }
                if (multi == null) {
                    multi = new MultiStatus("org.eclipse.pde.api.tools", single.getCode(), single.getMessage(), single.getException());
                }
                multi.add(e.getStatus());
            }
            ++i;
        }
        if (multi != null) {
            throw new CoreException(multi);
        }
        if (single != null) {
            throw new CoreException(single);
        }
    }

    @Override
    public IApiTypeRoot findTypeRoot(String qualifiedName) throws CoreException {
        IApiTypeContainer[] containers = this.getApiTypeContainers();
        int i = 0;
        while (i < containers.length) {
            IApiTypeRoot file = containers[i].findTypeRoot(qualifiedName);
            if (file != null) {
                return file;
            }
            ++i;
        }
        return null;
    }

    @Override
    public IApiTypeRoot findTypeRoot(String qualifiedName, String id) throws CoreException {
        IApiTypeContainer[] containers = this.getApiTypeContainers();
        String origin = null;
        IApiComponent comp = null;
        int i = 0;
        while (i < containers.length) {
            IApiTypeRoot file;
            comp = (IApiComponent)containers[i].getAncestor(1);
            if (comp != null) {
                origin = comp.getSymbolicName();
            }
            if (origin == null ? (file = containers[i].findTypeRoot(qualifiedName)) != null : origin.equals(id) && (file = containers[i].findTypeRoot(qualifiedName, id)) != null) {
                return file;
            }
            ++i;
        }
        return null;
    }

    @Override
    public String[] getPackageNames() throws CoreException {
        ArrayList<String> names = new ArrayList<String>();
        IApiTypeContainer[] containers = this.getApiTypeContainers();
        int i = 0;
        int max = containers.length;
        while (i < max) {
            String[] packageNames = containers[i].getPackageNames();
            int j = 0;
            int max2 = packageNames.length;
            while (j < max2) {
                names.add(packageNames[j]);
                ++j;
            }
            ++i;
        }
        Object[] result = new String[names.size()];
        names.toArray(result);
        Arrays.sort(result);
        return result;
    }

    protected synchronized IApiTypeContainer[] getApiTypeContainers() throws CoreException {
        if (this.fApiTypeContainers == null) {
            this.fApiTypeContainers = this.createApiTypeContainers();
        }
        return this.fApiTypeContainers.toArray(new IApiTypeContainer[this.fApiTypeContainers.size()]);
    }

    protected synchronized IApiTypeContainer[] getApiTypeContainers(String id) throws CoreException {
        if (this.fApiTypeContainers == null) {
            this.fApiTypeContainers = this.createApiTypeContainers();
        }
        ArrayList<IApiTypeContainer> containers = new ArrayList<IApiTypeContainer>();
        String origin = null;
        IApiTypeContainer container2 = null;
        for (IApiTypeContainer container2 : this.fApiTypeContainers) {
            origin = ((IApiComponent)container2.getAncestor(1)).getSymbolicName();
            if (origin == null || !origin.equals(id)) continue;
            containers.add(container2);
        }
        return containers.toArray(new IApiTypeContainer[containers.size()]);
    }

    protected abstract List<IApiTypeContainer> createApiTypeContainers() throws CoreException;

    protected synchronized void setApiTypeContainers(IApiTypeContainer[] containers) {
        if (this.fApiTypeContainers != null) {
            try {
                this.close();
            }
            catch (CoreException coreException) {}
            this.fApiTypeContainers.clear();
        } else {
            this.fApiTypeContainers = new ArrayList<IApiTypeContainer>(containers.length);
        }
        int i = 0;
        while (i < containers.length) {
            this.fApiTypeContainers.add(containers[i]);
            ++i;
        }
    }

    @Override
    public int getContainerType() {
        return 0;
    }
}

