/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.model.provisional;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.debug.internal.ui.viewers.model.provisional.VirtualTree;

public class VirtualItem {
    public static String LABEL_KEY = "LABEL_KEY";
    public static String IMAGE_KEY = "IMAGE_KEY";
    public static String FONT_KEY = "FONT_KEY";
    public static String FOREGROUND_KEY = "FOREGROUND_KEY";
    public static String BACKGROUND_KEY = "BACKGROUND_KEY";
    public static String ELEMENT_DATA_KEY = "element";
    private final VirtualItem fParent;
    private final Index fIndex;
    private Map<Index, VirtualItem> fItems = new TreeMap<Index, VirtualItem>();
    private boolean fHasItems = false;
    private boolean fExpanded = false;
    private int fItemCount = -1;
    private Map<String, Object> fData = new HashMap<String, Object>(1);
    private boolean fNeedsLabelUpdate = true;
    private boolean fNeedsCountUpdate = true;
    private boolean fNeedsDataUpdate = true;
    private boolean fDisposed = false;

    public VirtualItem(VirtualItem parent, Index index) {
        this.fParent = parent;
        this.fIndex = index;
    }

    public void clear(Index index) {
        VirtualItem item = this.fItems.remove(index);
        if (item != null) {
            item.dispose();
        }
    }

    public void clearAll() {
        this.fData.clear();
        for (VirtualItem item : this.fItems.values()) {
            item.dispose();
        }
        this.fItems.clear();
    }

    public VirtualItem getParent() {
        return this.fParent;
    }

    public Index getIndex() {
        return this.fIndex;
    }

    public VirtualItem findItem(Object element) {
        for (VirtualItem item : this.fItems.values()) {
            Object nextData = item.getData();
            if ((element == null || !element.equals(nextData)) && (element != null || nextData != null)) continue;
            return item;
        }
        return null;
    }

    public boolean needsDataUpdate() {
        return this.fNeedsDataUpdate;
    }

    public void setNeedsDataUpdate() {
        this.fNeedsDataUpdate = true;
    }

    public void clearNeedsDataUpdate() {
        this.fNeedsDataUpdate = false;
    }

    public boolean needsCountUpdate() {
        return this.fNeedsCountUpdate;
    }

    public void setNeedsCountUpdate() {
        this.fNeedsCountUpdate = true;
        this.fItemCount = -1;
    }

    public void clearNeedsCountUpdate() {
        this.fNeedsCountUpdate = false;
    }

    public boolean needsLabelUpdate() {
        return this.fNeedsLabelUpdate;
    }

    public void setNeedsLabelUpdate() {
        this.fNeedsLabelUpdate = true;
    }

    public void clearNeedsLabelUpdate() {
        this.fNeedsLabelUpdate = false;
    }

    public boolean isDisposed() {
        return this.fDisposed;
    }

    public void dispose() {
        this.clearAll();
        this.fDisposed = true;
        this.findTree().fireItemDisposed(this);
    }

    public Object getData(String key) {
        return this.fData.get(key);
    }

    public void setData(String key, Object data) {
        this.fData.put(key, data);
    }

    public void setData(Object data) {
        this.fData.put(ELEMENT_DATA_KEY, data);
    }

    public Object getData() {
        return this.fData.get(ELEMENT_DATA_KEY);
    }

    public void setExpanded(boolean expanded) {
        if (this.fExpanded == expanded) {
            return;
        }
        this.fExpanded = expanded;
        if (this.fExpanded && this.getItemCount() == -1) {
            this.setNeedsCountUpdate();
        }
        Assert.isTrue((!this.fExpanded || this.hasItems() ? 1 : 0) != 0);
        if (!this.fExpanded) {
            for (VirtualItem item : this.fItems.values()) {
                item.setExpanded(expanded);
            }
        }
    }

    public boolean getExpanded() {
        return this.fExpanded;
    }

    public void setHasItems(boolean hasChildren) {
        this.fHasItems = hasChildren;
        if (!this.fHasItems) {
            if (this.getItemCount() != 0) {
                this.setItemCount(0);
            }
        } else if (this.getItemCount() == 0) {
            this.setItemCount(-1);
        }
    }

    public boolean hasItems() {
        return this.fHasItems;
    }

    public void setItemCount(int count) {
        this.fItemCount = count;
        Iterator<Map.Entry<Index, VirtualItem>> itr = this.fItems.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<Index, VirtualItem> entry = itr.next();
            int index = entry.getKey().intValue();
            if (index < count) continue;
            VirtualItem item = entry.getValue();
            item.dispose();
            itr.remove();
        }
        if (this.fItemCount == 0) {
            if (this.hasItems()) {
                this.setHasItems(false);
            }
            if (this.getExpanded()) {
                this.setExpanded(false);
            }
        } else if (!this.hasItems()) {
            this.setHasItems(true);
        }
    }

    public int getItemCount() {
        return this.fItemCount;
    }

    public VirtualItem getItem(Index index) {
        this.ensureItems();
        VirtualItem item = this.fItems.get(index);
        if (item == null) {
            item = new VirtualItem(this, index);
            this.fItems.put(index, item);
        }
        return item;
    }

    public boolean childrenNeedDataUpdate() {
        if (this.getItemCount() == 0) {
            return false;
        }
        if (this.fItems == null || this.fItems.size() != this.fItemCount) {
            return true;
        }
        for (VirtualItem child : this.fItems.values()) {
            if (!child.needsDataUpdate()) continue;
            return true;
        }
        return false;
    }

    public VirtualItem[] getItems() {
        return this.fItems.values().toArray(new VirtualItem[this.fItems.size()]);
    }

    public VirtualItem addItem(int position) {
        Index childIndex2;
        if (!this.fHasItems) {
            this.fHasItems = true;
        }
        if (this.fItemCount < 0) {
            this.fItemCount = 0;
        }
        ++this.fItemCount;
        this.ensureItems();
        for (Index childIndex2 : this.fItems.keySet()) {
            if (childIndex2.intValue() < position) continue;
            childIndex2.increment();
        }
        childIndex2 = new Index(position);
        VirtualItem newChild = new VirtualItem(this, childIndex2);
        this.fItems.put(childIndex2, newChild);
        return newChild;
    }

    public void remove(Index position) {
        --this.fItemCount;
        if (this.fItemCount < 0) {
            this.fHasItems = false;
        }
        this.ensureItems();
        VirtualItem removedItem = null;
        Iterator<Map.Entry<Index, VirtualItem>> itr = this.fItems.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<Index, VirtualItem> entry = itr.next();
            Index childIndex = entry.getKey();
            if (childIndex.intValue() > position.intValue()) {
                childIndex.decrement();
                continue;
            }
            if (childIndex.intValue() != position.intValue()) continue;
            removedItem = entry.getValue();
            removedItem.dispose();
            itr.remove();
        }
    }

    private void ensureItems() {
        if (this.fItems == null) {
            this.fItems = new HashMap<Index, VirtualItem>(Math.max(1, Math.min(this.fItemCount, 16)));
        }
    }

    private VirtualTree findTree() {
        VirtualItem item = this;
        while (!(item instanceof VirtualTree)) {
            item = item.fParent;
        }
        return (VirtualTree)item;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        this.toStringItem(buffer, "");
        return buffer.toString();
    }

    void toStringItem(StringBuffer buffer, String indent) {
        buffer.append(indent);
        buffer.append(this.toStringElement());
        buffer.append("\n");
        indent = String.valueOf(indent) + "  ";
        int i = 0;
        while (i < this.fItemCount) {
            VirtualItem item = this.fItems.get(new Index(i));
            if (item != null) {
                item.toStringItem(buffer, indent);
            } else {
                buffer.append("<no item>\n");
            }
            ++i;
        }
    }

    private String toStringElement() {
        String[] label = (String[])this.fData.get(LABEL_KEY);
        if (label != null && label.length != 0) {
            return label[0];
        }
        Object data = this.fData.get(ELEMENT_DATA_KEY);
        if (data != null) {
            return data.toString();
        }
        return "<no data>";
    }

    public static class Index
    implements Comparable<Object> {
        private Integer fIndexValue;

        public Index(int index) {
            this.fIndexValue = new Integer(index);
        }

        public boolean equals(Object obj) {
            return obj instanceof Index && ((Index)obj).fIndexValue.equals(this.fIndexValue);
        }

        public int hashCode() {
            return this.fIndexValue.hashCode();
        }

        public void increment() {
            this.fIndexValue = new Integer(this.fIndexValue + 1);
        }

        public void decrement() {
            this.fIndexValue = new Integer(this.fIndexValue - 1);
        }

        public int intValue() {
            return this.fIndexValue;
        }

        @Override
        public int compareTo(Object obj) {
            return obj instanceof Index ? this.fIndexValue.compareTo(((Index)obj).fIndexValue) : 0;
        }

        public String toString() {
            return this.fIndexValue.toString();
        }
    }
}

