/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers;

import java.net.URL;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.util.BundleUtility;
import org.eclipse.ui.internal.views.markers.MarkerSupportInternalUtilities;
import org.eclipse.ui.views.markers.MarkerItem;

public abstract class MarkerField {
    private IConfigurationElement configurationElement;
    private ResourceManager imageManager;
    private ImageRegistry imageRegistry;

    public Image annotateImage(MarkerItem item, Image image) {
        IMarker marker;
        ImageDescriptor[] descriptors = new ImageDescriptor[5];
        if (item.getMarker() != null && (marker = item.getMarker()) != null) {
            String contextId = IDE.getMarkerHelpRegistry().getHelp(marker);
            if (contextId != null) {
                if (image == null) {
                    image = JFaceResources.getImage((String)"dialog_help_image");
                } else {
                    descriptors[1] = this.getIDEImageDescriptor("markers/help_small.png");
                }
            }
            if (IDE.getMarkerHelpRegistry().hasResolutions(marker)) {
                if (image == MarkerSupportInternalUtilities.getSeverityImage(1)) {
                    image = WorkbenchPlugin.getDefault().getSharedImages().getImage("IMG_OBJS_FIXABLE_WARNING");
                } else if (image == MarkerSupportInternalUtilities.getSeverityImage(2)) {
                    image = WorkbenchPlugin.getDefault().getSharedImages().getImage("IMG_OBJS_FIXABLE_ERROR");
                } else if (image != null) {
                    descriptors[3] = this.getIDEImageDescriptor("markers/contassist_ovr.png");
                }
                if (image == null) {
                    image = WorkbenchPlugin.getDefault().getSharedImages().getImage("IMG_ELCL_QUICK_FIX_ENABLED");
                }
            }
            if (descriptors[1] != null || descriptors[3] != null) {
                image = this.getImageManager().createImage((ImageDescriptor)new DecorationOverlayIcon(image, descriptors));
            }
        }
        return image;
    }

    ImageDescriptor getIDEImageDescriptor(String relativePath) {
        ImageDescriptor descriptor;
        if (this.imageRegistry == null) {
            this.imageRegistry = IDEWorkbenchPlugin.getDefault().getImageRegistry();
        }
        if ((descriptor = this.imageRegistry.getDescriptor(relativePath)) == null) {
            descriptor = IDEWorkbenchPlugin.getIDEImageDescriptor(relativePath);
            this.imageRegistry.put(relativePath, descriptor);
        }
        return descriptor;
    }

    public int compare(MarkerItem item1, MarkerItem item2) {
        return this.getValue(item1).compareTo(this.getValue(item2));
    }

    public Image getColumnHeaderImage() {
        String path = this.configurationElement.getAttribute("icon");
        if (path == null) {
            return null;
        }
        URL url = BundleUtility.find((String)this.configurationElement.getContributor().getName(), (String)path);
        if (url == null) {
            return null;
        }
        return this.getImageManager().createImageWithDefault(ImageDescriptor.createFromURL((URL)url));
    }

    public String getColumnHeaderText() {
        return this.getName();
    }

    public String getName() {
        return this.configurationElement.getAttribute("name");
    }

    public String getColumnTooltipText() {
        return this.getColumnHeaderText();
    }

    public final IConfigurationElement getConfigurationElement() {
        return this.configurationElement;
    }

    public int getDefaultColumnWidth(Control control) {
        return 15 * MarkerSupportInternalUtilities.getFontWidth(control);
    }

    public EditingSupport getEditingSupport(ColumnViewer viewer) {
        return null;
    }

    protected ResourceManager getImageManager() {
        if (this.imageManager == null) {
            return IDEWorkbenchPlugin.getDefault().getResourceManager();
        }
        return this.imageManager;
    }

    public abstract String getValue(MarkerItem var1);

    public final void setConfigurationElement(IConfigurationElement element) {
        this.configurationElement = element;
    }

    public final void setImageManager(ResourceManager manager) {
        this.imageManager = manager;
    }

    public void update(ViewerCell cell) {
        cell.setText(this.getValue((MarkerItem)cell.getElement()));
        cell.setImage(null);
    }
}

