/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.nls.search;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.corext.refactoring.nls.PropertyFileDocumentModel;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaUIStatus;
import org.eclipse.jdt.internal.ui.refactoring.nls.search.FileEntry;
import org.eclipse.jdt.internal.ui.refactoring.nls.search.LineReader;
import org.eclipse.jdt.internal.ui.refactoring.nls.search.NLSSearchMessages;
import org.eclipse.jdt.internal.ui.refactoring.nls.search.NLSSearchResult;
import org.eclipse.jdt.internal.ui.refactoring.nls.search.Properties;
import org.eclipse.jdt.internal.ui.util.StringMatcher;
import org.eclipse.jface.text.Position;
import org.eclipse.search.ui.text.Match;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NLSSearchResultRequestor
extends SearchRequestor {
    private static final StringMatcher fgGetClassNameMatcher = new StringMatcher("*.class.getName()*", false, false);
    private static final String NO_KEY = new String();
    private NLSSearchResult fResult;
    private IFile fPropertiesFile;
    private Properties fProperties;
    private HashSet<String> fUsedPropertyNames;

    public NLSSearchResultRequestor(IFile propertiesFile, NLSSearchResult result) {
        this.fPropertiesFile = propertiesFile;
        this.fResult = result;
    }

    public void beginReporting() {
        this.loadProperties();
        this.fUsedPropertyNames = new HashSet(this.fProperties.size());
    }

    public void acceptSearchMatch(SearchMatch match) throws CoreException {
        String source;
        IField field;
        String source2;
        if (match.getAccuracy() == 1) {
            return;
        }
        int offset = match.getOffset();
        int length = match.getLength();
        if (offset == -1 || length == -1) {
            return;
        }
        if (!(match.getElement() instanceof IJavaElement)) {
            return;
        }
        IJavaElement javaElement = (IJavaElement)match.getElement();
        if (javaElement.getElementType() == 13) {
            return;
        }
        if (javaElement.getElementType() == 6) {
            return;
        }
        if (javaElement.getElementType() == 7) {
            return;
        }
        if (javaElement.getElementType() == 8 && (source2 = (field = (IField)javaElement).getSource()) != null && fgGetClassNameMatcher.match(source2)) {
            return;
        }
        if (javaElement instanceof ISourceReference && (source = ((ISourceReference)javaElement).getSource()) != null && source.indexOf("NLS.initializeMessages") != -1) {
            return;
        }
        Position mutableKeyPosition = new Position(offset, length);
        String key = this.findKey(mutableKeyPosition, javaElement);
        if (key == null || this.isKeyDefined(key)) {
            return;
        }
        ICompilationUnit[] allCompilationUnits = JavaModelUtil.getAllCompilationUnits(new IJavaElement[]{javaElement});
        IJavaElement element = javaElement;
        if (allCompilationUnits != null && allCompilationUnits.length == 1) {
            element = allCompilationUnits[0];
        }
        this.fResult.addMatch(new Match((Object)element, mutableKeyPosition.getOffset(), mutableKeyPosition.getLength()));
    }

    public void reportUnusedPropertyNames(IProgressMonitor pm) {
        pm.beginTask("", this.fProperties.size());
        boolean hasUnused = false;
        pm.setTaskName(NLSSearchMessages.NLSSearchResultRequestor_searching);
        FileEntry groupElement = new FileEntry(this.fPropertiesFile, NLSSearchMessages.NLSSearchResultCollector_unusedKeys);
        Enumeration<?> enumeration = this.fProperties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String propertyName = (String)enumeration.nextElement();
            if (!this.fUsedPropertyNames.contains(propertyName)) {
                this.addMatch(groupElement, propertyName);
                hasUnused = true;
            }
            pm.worked(1);
        }
        if (hasUnused) {
            this.fResult.addFileEntryGroup(groupElement);
        }
        pm.done();
    }

    private void addMatch(FileEntry groupElement, String propertyName) {
        int length;
        String escapedPropertyName = PropertyFileDocumentModel.escape(propertyName, false);
        int start = this.findPropertyNameStartPosition(escapedPropertyName);
        if (start == -1) {
            start = 0;
            length = 0;
        } else {
            length = escapedPropertyName.length();
        }
        this.fResult.addMatch(new Match((Object)groupElement, start, length));
    }

    private boolean isKeyDefined(String key) {
        if (key == NO_KEY) {
            return false;
        }
        this.fUsedPropertyNames.add(key);
        return this.fProperties.getProperty(key) != null;
    }

    public boolean hasPropertyKey(String key) {
        return this.fProperties.containsKey(key);
    }

    public boolean isUsedPropertyKey(String key) {
        return this.fUsedPropertyNames.contains(key);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String findKey(Position keyPositionResult, IJavaElement enclosingElement) throws CoreException {
        ICompilationUnit unit = (ICompilationUnit)enclosingElement.getAncestor(5);
        if (unit == null) {
            return null;
        }
        String source = unit.getSource();
        if (source == null) {
            return null;
        }
        IJavaProject javaProject = unit.getJavaProject();
        IScanner scanner = null;
        if (javaProject != null) {
            String complianceLevel = javaProject.getOption("org.eclipse.jdt.core.compiler.compliance", true);
            String sourceLevel = javaProject.getOption("org.eclipse.jdt.core.compiler.source", true);
            scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (String)sourceLevel, (String)complianceLevel);
        } else {
            scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        }
        scanner.setSource(source.toCharArray());
        scanner.resetTo(keyPositionResult.getOffset() + keyPositionResult.getLength(), source.length());
        try {
            if (scanner.getNextToken() != 6) {
                return null;
            }
            if (scanner.getNextToken() != 5) {
                return null;
            }
            String src = new String(scanner.getCurrentTokenSource());
            int tokenStart = scanner.getCurrentTokenStartPosition();
            int tokenEnd = scanner.getCurrentTokenEndPosition();
            if (scanner.getNextToken() == 7) {
                int token;
                int nextToken = scanner.getNextToken();
                if (nextToken != 45 && nextToken != 5) {
                    return null;
                }
                tokenStart = scanner.getCurrentTokenStartPosition();
                tokenEnd = scanner.getCurrentTokenEndPosition();
                while ((token = scanner.getNextToken()) == 6) {
                    nextToken = scanner.getNextToken();
                    if (nextToken != 5) {
                        return null;
                    }
                    tokenStart = scanner.getCurrentTokenStartPosition();
                    tokenEnd = scanner.getCurrentTokenEndPosition();
                }
                if (token != 86) {
                    return null;
                }
                if (nextToken == 45) {
                    keyPositionResult.setOffset(tokenStart + 1);
                    keyPositionResult.setLength(tokenEnd - tokenStart - 1);
                    return source.substring(tokenStart + 1, tokenEnd);
                }
                if (nextToken == 5) {
                    keyPositionResult.setOffset(tokenStart);
                    keyPositionResult.setLength(tokenEnd - tokenStart + 1);
                    IType parentClass = (IType)enclosingElement.getAncestor(7);
                    IField[] fields = parentClass.getFields();
                    String identifier = source.substring(tokenStart, tokenEnd + 1);
                    int i = 0;
                    while (i < fields.length) {
                        if (fields[i].getElementName().equals(identifier)) {
                            if (!Signature.getSignatureSimpleName((String)fields[i].getTypeSignature()).equals("String")) {
                                return null;
                            }
                            Object obj = fields[i].getConstant();
                            return obj instanceof String ? ((String)obj).substring(1, ((String)obj).length() - 1) : NO_KEY;
                        }
                        ++i;
                    }
                }
                return NO_KEY;
            }
            IJavaElement[] keys = unit.codeSelect(tokenStart, tokenEnd - tokenStart + 1);
            if (keys.length == 1 && keys[0].getElementType() == 7 && ((IType)keys[0]).isInterface()) {
                return null;
            }
            keyPositionResult.setOffset(tokenStart);
            keyPositionResult.setLength(tokenEnd - tokenStart + 1);
            return src;
        }
        catch (InvalidInputException e) {
            throw new CoreException(JavaUIStatus.createError(4, e));
        }
    }

    private int findPropertyNameStartPosition(String propertyName) {
        String encoding;
        InputStream stream = null;
        LineReader lineReader = null;
        try {
            encoding = this.fPropertiesFile.getCharset();
        }
        catch (CoreException coreException) {
            encoding = "ISO-8859-1";
        }
        try {
            stream = this.createInputStream(this.fPropertiesFile);
            lineReader = new LineReader(stream, encoding);
        }
        catch (CoreException cex) {
            JavaPlugin.log(cex);
            return -1;
        }
        catch (IOException iOException) {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException ce) {
                    JavaPlugin.log(ce);
                }
            }
            return -1;
        }
        int start = 0;
        try {
            try {
                StringBuffer buf = new StringBuffer(80);
                int eols = lineReader.readLine(buf);
                int keyLength = propertyName.length();
                while (eols > 0) {
                    boolean hasNoValue;
                    String line = buf.toString();
                    int i = line.indexOf(propertyName);
                    int charPos = i + keyLength;
                    char terminatorChar = '\u0000';
                    boolean bl = hasNoValue = charPos >= line.length();
                    if (i > -1 && !hasNoValue) {
                        terminatorChar = line.charAt(charPos);
                    }
                    if (line.trim().startsWith(propertyName) && (hasNoValue || Character.isWhitespace(terminatorChar) || terminatorChar == '=')) {
                        start += line.indexOf(propertyName);
                        eols = -17;
                        continue;
                    }
                    start += line.length() + eols;
                    buf.setLength(0);
                    eols = lineReader.readLine(buf);
                }
                if (eols != -17) {
                    start = -1;
                }
            }
            catch (IOException ex) {
                JavaPlugin.log(ex);
                try {
                    lineReader.close();
                }
                catch (IOException ex2) {
                    JavaPlugin.log(ex2);
                }
                return -1;
            }
        }
        finally {
            try {
                lineReader.close();
            }
            catch (IOException ex) {
                JavaPlugin.log(ex);
            }
        }
        return start;
    }

    private void loadProperties() {
        BufferedInputStream stream;
        HashSet<Object> duplicateKeys = new HashSet<Object>();
        this.fProperties = new Properties(duplicateKeys);
        try {
            stream = new BufferedInputStream(this.createInputStream(this.fPropertiesFile));
        }
        catch (CoreException coreException) {
            this.fProperties = new Properties();
            return;
        }
        try {
            try {
                this.fProperties.load(stream);
            }
            catch (IOException iOException) {
                this.fProperties = new Properties();
                try {
                    ((InputStream)stream).close();
                }
                catch (IOException iOException2) {}
                this.reportDuplicateKeys(duplicateKeys);
                return;
            }
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)stream).close();
            }
            catch (IOException iOException) {}
            this.reportDuplicateKeys(duplicateKeys);
            throw throwable;
        }
        try {
            ((InputStream)stream).close();
        }
        catch (IOException iOException) {}
        this.reportDuplicateKeys(duplicateKeys);
    }

    private InputStream createInputStream(IFile propertiesFile) throws CoreException {
        ITextFileBuffer buffer;
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        if (manager != null && (buffer = manager.getTextFileBuffer(propertiesFile.getFullPath(), LocationKind.IFILE)) != null) {
            return new ByteArrayInputStream(buffer.getDocument().get().getBytes());
        }
        return propertiesFile.getContents();
    }

    private void reportDuplicateKeys(Set<Object> duplicateKeys) {
        if (duplicateKeys.size() == 0) {
            return;
        }
        FileEntry groupElement = new FileEntry(this.fPropertiesFile, NLSSearchMessages.NLSSearchResultCollector_duplicateKeys);
        for (String string : duplicateKeys) {
            this.addMatch(groupElement, string);
        }
        this.fResult.addFileEntryGroup(groupElement);
    }
}

