/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.model;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.api.tools.internal.model.AbstractApiTypeRoot;
import org.eclipse.pde.api.tools.internal.model.ApiElement;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.model.ApiTypeContainerVisitor;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiElement;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeContainer;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeRoot;
import org.eclipse.pde.api.tools.internal.util.Util;

public class ArchiveApiTypeContainer
extends ApiElement
implements IApiTypeContainer {
    String fLocation;
    private Map<String, Set<String>> fPackages;
    private String[] fPackageNames;

    public ArchiveApiTypeContainer(IApiElement parent, String path) {
        super(parent, 3, path);
        this.fLocation = path;
    }

    @Override
    public void accept(ApiTypeContainerVisitor visitor) throws CoreException {
        if (visitor.visit(this)) {
            this.init();
            ArrayList<String> packages = new ArrayList<String>(this.fPackages.keySet());
            Collections.sort(packages);
            for (String pkg : packages) {
                if (visitor.visitPackage(pkg)) {
                    ArrayList types = new ArrayList(this.fPackages.get(pkg));
                    ArrayList<ArchiveApiTypeRoot> classFiles = new ArrayList<ArchiveApiTypeRoot>(types.size());
                    for (String entryName : types) {
                        classFiles.add(new ArchiveApiTypeRoot(this, entryName));
                    }
                    Collections.sort(classFiles);
                    for (ArchiveApiTypeRoot classfile : classFiles) {
                        visitor.visit(pkg, classfile);
                        visitor.end(pkg, classfile);
                    }
                }
                visitor.endVisitPackage(pkg);
            }
        }
        visitor.end(this);
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("Archive Class File Container: " + this.getName());
        return buff.toString();
    }

    @Override
    public synchronized void close() throws CoreException {
    }

    @Override
    public IApiTypeRoot findTypeRoot(String qualifiedName) throws CoreException {
        String fileName;
        Set<String> classFileNames;
        this.init();
        int index = qualifiedName.lastIndexOf(46);
        String packageName = "";
        if (index >= 0) {
            packageName = qualifiedName.substring(0, index);
        }
        if ((classFileNames = this.fPackages.get(packageName)) != null && classFileNames.contains(fileName = String.valueOf(qualifiedName.replace('.', '/')) + ".class")) {
            return new ArchiveApiTypeRoot(this, fileName);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getPackageNames() throws CoreException {
        this.init();
        ArchiveApiTypeContainer archiveApiTypeContainer = this;
        synchronized (archiveApiTypeContainer) {
            if (this.fPackageNames == null) {
                Set<String> names = this.fPackages.keySet();
                Object[] result = new String[names.size()];
                names.toArray(result);
                Arrays.sort(result);
                this.fPackageNames = result;
            }
            return this.fPackageNames;
        }
    }

    private synchronized void init() throws CoreException {
        if (this.fPackages == null) {
            ZipFile zipFile;
            this.fPackages = new HashMap<String, Set<String>>();
            try {
                zipFile = new ZipFile(this.fLocation);
            }
            catch (IOException e) {
                this.abort("Failed to open archive: " + this.fLocation, e);
                return;
            }
            try {
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    Set<String> fileNames;
                    ZipEntry entry = entries.nextElement();
                    String name = entry.getName();
                    if (!name.endsWith(".class")) continue;
                    String pkg = "";
                    int index = name.lastIndexOf(47);
                    if (index >= 0) {
                        pkg = name.substring(0, index).replace('/', '.');
                    }
                    if ((fileNames = this.fPackages.get(pkg)) == null) {
                        fileNames = new HashSet<String>();
                        this.fPackages.put(pkg, fileNames);
                    }
                    fileNames.add(name);
                }
            }
            finally {
                try {
                    zipFile.close();
                }
                catch (IOException e) {
                    this.abort("Failed to close class file archive", e);
                }
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof ArchiveApiTypeContainer) {
            return this.fLocation.equals(((ArchiveApiTypeContainer)obj).fLocation);
        }
        return false;
    }

    public int hashCode() {
        return this.fLocation.hashCode();
    }

    @Override
    public IApiTypeRoot findTypeRoot(String qualifiedName, String id) throws CoreException {
        return this.findTypeRoot(qualifiedName);
    }

    @Override
    public int getContainerType() {
        return 1;
    }

    static class ArchiveApiTypeRoot
    extends AbstractApiTypeRoot
    implements Comparable<Object> {
        private String fTypeName;

        public ArchiveApiTypeRoot(ArchiveApiTypeContainer container, String entryName) {
            super(container, entryName);
        }

        @Override
        public String getTypeName() {
            if (this.fTypeName == null) {
                this.fTypeName = this.getName().replace('/', '.').substring(0, this.getName().length() - ".class".length());
            }
            return this.fTypeName;
        }

        @Override
        public int compareTo(Object o) {
            return this.getTypeName().compareTo(((ArchiveApiTypeRoot)o).getTypeName());
        }

        public boolean equals(Object obj) {
            if (obj instanceof ArchiveApiTypeRoot) {
                ArchiveApiTypeRoot classFile = (ArchiveApiTypeRoot)obj;
                return this.getName().equals(classFile.getName());
            }
            return false;
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        /*
         * Loose catch block
         */
        @Override
        public byte[] getContents() throws CoreException {
            ArchiveApiTypeContainer archive;
            block30: {
                ZipFile zipFile;
                archive = (ArchiveApiTypeContainer)this.getParent();
                try {
                    zipFile = new ZipFile(archive.fLocation);
                }
                catch (IOException e) {
                    this.abort("Failed to open archive: " + archive.fLocation, e);
                    return null;
                }
                try {
                    ZipEntry entry = zipFile.getEntry(this.getName());
                    InputStream stream = null;
                    if (entry == null) break block30;
                    try {
                        stream = zipFile.getInputStream(entry);
                    }
                    catch (IOException e) {
                        this.abort("Failed to open class file: " + this.getTypeName() + " in archive: " + archive.fLocation, e);
                        try {
                            zipFile.close();
                        }
                        catch (IOException e2) {
                            this.abort("Failed to close class file archive", e2);
                        }
                        return null;
                    }
                    byte[] byArray = Util.getInputStreamAsByteArray(stream, -1);
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        ApiPlugin.log(e);
                    }
                    return byArray;
                    catch (IOException ioe) {
                        this.abort("Unable to read class file: " + this.getTypeName(), ioe);
                        try {
                            stream.close();
                        }
                        catch (IOException e) {
                            ApiPlugin.log(e);
                        }
                        try {
                            zipFile.close();
                        }
                        catch (IOException e) {
                            this.abort("Failed to close class file archive", e);
                        }
                        return null;
                        {
                            catch (Throwable throwable) {
                                try {
                                    stream.close();
                                }
                                catch (IOException e) {
                                    ApiPlugin.log(e);
                                }
                                throw throwable;
                            }
                        }
                    }
                }
                finally {
                    try {
                        zipFile.close();
                    }
                    catch (IOException e) {
                        this.abort("Failed to close class file archive", e);
                    }
                }
            }
            this.abort("Class file not found: " + this.getTypeName() + " in archive: " + archive.fLocation, null);
            return null;
        }

        public String toString() {
            return this.getTypeName();
        }
    }
}

