/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import java.io.File;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.util.Geometry;
import org.eclipse.osgi.util.NLS;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.ide.ChooseWorkspaceData;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class ChooseWorkspaceDialog
extends TitleAreaDialog {
    private static final String DIALOG_SETTINGS_SECTION = "ChooseWorkspaceDialogSettings";
    private ChooseWorkspaceData launchData;
    private Combo text;
    private boolean suppressAskAgain = false;
    private boolean centerOnMonitor = false;

    public ChooseWorkspaceDialog(Shell parentShell, ChooseWorkspaceData launchData, boolean suppressAskAgain, boolean centerOnMonitor) {
        super(parentShell);
        this.launchData = launchData;
        this.suppressAskAgain = suppressAskAgain;
        this.centerOnMonitor = centerOnMonitor;
    }

    public void prompt(boolean force) {
        if (force || this.launchData.getShowDialog()) {
            this.open();
            if (this.getReturnCode() == 1) {
                this.launchData.workspaceSelected(null);
            }
            return;
        }
        String[] recent = this.launchData.getRecentWorkspaces();
        String workspace = null;
        if (recent != null && recent.length > 0) {
            workspace = recent[0];
        }
        if (workspace == null || workspace.length() == 0) {
            workspace = this.launchData.getInitialDefault();
        }
        this.launchData.workspaceSelected(TextProcessor.deprocess((String)workspace));
    }

    protected Control createDialogArea(Composite parent) {
        String productName = ChooseWorkspaceDialog.getWindowTitle();
        Composite composite = (Composite)super.createDialogArea(parent);
        this.setTitle(IDEWorkbenchMessages.ChooseWorkspaceDialog_dialogTitle);
        this.setMessage(NLS.bind((String)IDEWorkbenchMessages.ChooseWorkspaceDialog_dialogMessage, (Object)productName));
        if (this.getTitleImageLabel() != null) {
            this.getTitleImageLabel().setVisible(false);
        }
        this.createWorkspaceBrowseRow(composite);
        if (!this.suppressAskAgain) {
            this.createShowDialogButton(composite);
        }
        boolean gcj = Boolean.getBoolean("eclipse.gcj");
        String vmName = System.getProperty("java.vm.name");
        if (!gcj && vmName != null && vmName.indexOf("libgcj") != -1) {
            composite.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ChooseWorkspaceDialog.this.setMessage(IDEWorkbenchMessages.UnsupportedVM_message, 2);
                }
            });
        }
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    public static String getWindowTitle() {
        String productName = null;
        IProduct product = Platform.getProduct();
        if (product != null) {
            productName = product.getName();
        }
        if (productName == null) {
            productName = IDEWorkbenchMessages.ChooseWorkspaceDialog_defaultProductName;
        }
        return productName;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(IDEWorkbenchMessages.ChooseWorkspaceDialog_dialogName);
        shell.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2) {
                    e.detail = 0;
                    ChooseWorkspaceDialog.this.cancelPressed();
                }
            }
        });
    }

    protected void okPressed() {
        this.launchData.workspaceSelected(TextProcessor.deprocess((String)this.getWorkspaceLocation()));
        super.okPressed();
    }

    protected String getWorkspaceLocation() {
        return this.text.getText();
    }

    protected void cancelPressed() {
        this.launchData.workspaceSelected(null);
        super.cancelPressed();
    }

    private void createWorkspaceBrowseRow(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)new GridData(768));
        panel.setFont(parent.getFont());
        Label label = new Label(panel, 0);
        label.setText(IDEWorkbenchMessages.ChooseWorkspaceDialog_workspaceEntryLabel);
        this.text = new Combo(panel, 18436);
        this.text.setFocus();
        this.text.setLayoutData((Object)new GridData(400, -1));
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Button okButton = ChooseWorkspaceDialog.this.getButton(0);
                if (okButton != null && !okButton.isDisposed()) {
                    boolean nonWhitespaceFound = false;
                    String characters = ChooseWorkspaceDialog.this.getWorkspaceLocation();
                    int i = 0;
                    while (!nonWhitespaceFound && i < characters.length()) {
                        if (!Character.isWhitespace(characters.charAt(i))) {
                            nonWhitespaceFound = true;
                        }
                        ++i;
                    }
                    okButton.setEnabled(nonWhitespaceFound);
                }
            }
        });
        this.setInitialTextValues(this.text);
        Button browseButton = new Button(panel, 8);
        browseButton.setText(IDEWorkbenchMessages.ChooseWorkspaceDialog_browseLabel);
        this.setButtonLayoutData(browseButton);
        GridData data = (GridData)browseButton.getLayoutData();
        data.horizontalAlignment = 128;
        browseButton.setLayoutData((Object)data);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(ChooseWorkspaceDialog.this.getShell(), 0x10000000);
                dialog.setText(IDEWorkbenchMessages.ChooseWorkspaceDialog_directoryBrowserTitle);
                dialog.setMessage(IDEWorkbenchMessages.ChooseWorkspaceDialog_directoryBrowserMessage);
                dialog.setFilterPath(ChooseWorkspaceDialog.this.getInitialBrowsePath());
                String dir = dialog.open();
                if (dir != null) {
                    ChooseWorkspaceDialog.this.text.setText(TextProcessor.process((String)dir));
                }
            }
        });
    }

    private String getInitialBrowsePath() {
        File dir = new File(this.getWorkspaceLocation());
        while (dir != null && !dir.exists()) {
            dir = dir.getParentFile();
        }
        return dir != null ? dir.getAbsolutePath() : System.getProperty("user.dir");
    }

    protected Point getInitialLocation(Point initialSize) {
        Composite parent = this.getShell().getParent();
        if (!this.centerOnMonitor || parent == null) {
            return super.getInitialLocation(initialSize);
        }
        Monitor monitor = parent.getMonitor();
        Rectangle monitorBounds = monitor.getClientArea();
        Point centerPoint = Geometry.centerPoint((Rectangle)monitorBounds);
        return new Point(centerPoint.x - initialSize.x / 2, Math.max(monitorBounds.y, Math.min(centerPoint.y - initialSize.y * 2 / 3, monitorBounds.y + monitorBounds.height - initialSize.y)));
    }

    private void createShowDialogButton(Composite parent) {
        Composite panel = new Composite(parent, 0);
        panel.setFont(parent.getFont());
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        panel.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.verticalAlignment = 3;
        panel.setLayoutData((Object)data);
        Button button = new Button(panel, 32);
        button.setText(IDEWorkbenchMessages.ChooseWorkspaceDialog_useDefaultMessage);
        button.setSelection(!this.launchData.getShowDialog());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChooseWorkspaceDialog.this.launchData.toggleShowDialog();
            }
        });
    }

    private void setInitialTextValues(Combo text) {
        String[] recentWorkspaces = this.launchData.getRecentWorkspaces();
        int i = 0;
        while (i < recentWorkspaces.length) {
            if (recentWorkspaces[i] != null) {
                text.add(recentWorkspaces[i]);
            }
            ++i;
        }
        text.setText(TextProcessor.process((String)(text.getItemCount() > 0 ? text.getItem(0) : this.launchData.getInitialDefault())));
    }

    protected IDialogSettings getDialogBoundsSettings() {
        if (this.centerOnMonitor) {
            return null;
        }
        IDialogSettings settings = IDEWorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(DIALOG_SETTINGS_SECTION);
        if (section == null) {
            section = settings.addNewSection(DIALOG_SETTINGS_SECTION);
        }
        return section;
    }
}

