/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.verifications.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.rcptt.verifications.tree.Row;
import org.eclipse.rcptt.verifications.tree.Tree;
import org.eclipse.rcptt.verifications.tree.TreeNode;

public class ModelTreeNodeAdapter
implements TreeNode<Row> {
    private final Tree model;

    public ModelTreeNodeAdapter(Tree model) {
        this.model = model;
    }

    private static List<RowNodeAdapter> convert(List<Row> children) {
        ArrayList<RowNodeAdapter> rv = new ArrayList<RowNodeAdapter>(children.size());
        for (Row item : children) {
            rv.add(new RowNodeAdapter(item));
        }
        return rv;
    }

    @Override
    public Row payload() {
        return null;
    }

    @Override
    public Collection<? extends TreeNode<Row>> getChildren() {
        return ModelTreeNodeAdapter.convert(this.model.getRows());
    }

    private static class RowNodeAdapter
    implements TreeNode<Row> {
        private final Row model;

        public RowNodeAdapter(Row item) {
            if (item == null) {
                throw new NullPointerException();
            }
            this.model = item;
        }

        @Override
        public Collection<? extends TreeNode<Row>> getChildren() {
            return ModelTreeNodeAdapter.convert(this.model.getChildren());
        }

        @Override
        public Row payload() {
            return this.model;
        }
    }
}

