/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.monitoring.preferences;

import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.monitoring.preferences.Messages;

public class FilterInputDialog
extends TitleAreaDialog {
    private static final Pattern methodNamePattern = Pattern.compile("([\\p{L}_$][\\p{L}\\p{N}_$]*\\.)+[\\p{L}_$][\\p{L}\\p{N}_$]*|([\\p{L}_$][\\p{L}\\p{N}_$]*\\.?)*([\\?\\*][\\p{L}\\p{N}_$\\.]*)+");
    private Text textFilter;
    private String filter;

    public FilterInputDialog(Shell parentShell, String message) {
        super(parentShell);
        this.create();
        this.setMessage(message, 1);
    }

    public void create() {
        super.create();
        this.setTitle(Messages.FilterInputDialog_header);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.FilterInputDialog_title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setLayout((Layout)new GridLayout(2, false));
        Label filterLabel = new Label(container, 0);
        filterLabel.setText(Messages.FilterInputDialog_filter_input_label);
        this.textFilter = new Text(container, 2048);
        this.textFilter.setLayoutData((Object)new GridData(4, 1, true, false));
        this.textFilter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FilterInputDialog.this.checkInput();
            }
        });
        new Label(container, 0);
        Label noteLabel = new Label(container, 0);
        noteLabel.setText(Messages.FilterInputDialog_note_label);
        return area;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.checkInput();
        return contents;
    }

    private void checkInput() {
        this.filter = this.textFilter.getText().trim();
        Button okButton = this.getButton(0);
        String errorMessage = null;
        if (!methodNamePattern.matcher(this.filter).matches()) {
            if (!this.filter.isEmpty()) {
                errorMessage = Messages.FilterInputDialog_invalid_method_name;
            }
            okButton.setEnabled(false);
        } else {
            okButton.setEnabled(true);
        }
        this.setErrorMessage(errorMessage);
    }

    protected boolean isResizable() {
        return true;
    }

    public String getFilter() {
        return this.filter;
    }
}

