/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.search;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogSettings;

public class CommitSearchSettings {
    private static final String SEARCH_SECTION = "searchSection";
    private static final String TEXT_PATTERN = "textPattern";
    private static final String REGEX_SEARCH = "regexSearch";
    private static final String IGNORE_CASE = "ignoreCase";
    private static final String MATCH_AUTHOR = "matchAuthor";
    private static final String MATCH_COMMITTER = "matchCommitter";
    private static final String MATCH_MESSAGE = "matchMessage";
    private static final String MATCH_COMMIT = "matchCommit";
    private static final String MATCH_PARENTS = "matchParents";
    private static final String MATCH_TREE = "matchTree";
    private static final String ALL_BRANCHES = "allBranches";
    private static final String REPOSITORY_COUNT = "repositoryCount";
    private static final String REPOSITORY = "repository";
    private boolean isMatchCommit = true;
    private boolean isMatchCommitter = true;
    private boolean isMatchAuthor = true;
    private boolean isMatchTree = true;
    private boolean isMatchMessage = true;
    private boolean isMatchParents = true;
    private boolean isCaseSensitive = false;
    private boolean isRegExSearch = false;
    private boolean isAllBranches = false;
    private String textPattern = null;
    private List<String> repositories = new LinkedList<String>();

    public static CommitSearchSettings create(IDialogSettings settings) {
        IDialogSettings section = settings.getSection(SEARCH_SECTION);
        CommitSearchSettings searchSettings = new CommitSearchSettings();
        if (section != null) {
            searchSettings.setTextPattern(section.get(TEXT_PATTERN));
            searchSettings.setRegExSearch(section.getBoolean(REGEX_SEARCH));
            searchSettings.setCaseSensitive(!section.getBoolean(IGNORE_CASE));
            searchSettings.setMatchAuthor(section.getBoolean(MATCH_AUTHOR));
            searchSettings.setMatchCommitter(section.getBoolean(MATCH_COMMITTER));
            searchSettings.setMatchMessage(section.getBoolean(MATCH_MESSAGE));
            searchSettings.setMatchCommit(section.getBoolean(MATCH_COMMIT));
            searchSettings.setMatchParents(section.getBoolean(MATCH_PARENTS));
            searchSettings.setMatchTree(section.getBoolean(MATCH_TREE));
            searchSettings.setAllBranches(section.getBoolean(ALL_BRANCHES));
            try {
                int count = section.getInt(REPOSITORY_COUNT);
                int i = 0;
                while (i < count) {
                    searchSettings.addRepository(section.get(REPOSITORY + i));
                    ++i;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return searchSettings;
    }

    public void store(IDialogSettings settings) {
        IDialogSettings section = settings.getSection(SEARCH_SECTION);
        if (section == null) {
            section = settings.addNewSection(SEARCH_SECTION);
        }
        section.put(IGNORE_CASE, !this.isCaseSensitive);
        section.put(REGEX_SEARCH, this.isRegExSearch);
        section.put(TEXT_PATTERN, this.textPattern);
        section.put(MATCH_AUTHOR, this.isMatchAuthor);
        section.put(MATCH_COMMIT, this.isMatchCommit);
        section.put(MATCH_COMMITTER, this.isMatchCommitter);
        section.put(MATCH_MESSAGE, this.isMatchMessage);
        section.put(MATCH_PARENTS, this.isMatchParents);
        section.put(MATCH_TREE, this.isMatchTree);
        section.put(ALL_BRANCHES, this.isAllBranches);
        int count = 0;
        for (String repo : this.repositories) {
            section.put(REPOSITORY + count, repo);
            ++count;
        }
        section.put(REPOSITORY_COUNT, this.repositories.size());
    }

    public void addRepository(String path) {
        this.repositories.add(path);
    }

    public List<String> getRepositories() {
        return this.repositories;
    }

    public boolean isMatchCommit() {
        return this.isMatchCommit;
    }

    public void setMatchCommit(boolean isMatchCommit) {
        this.isMatchCommit = isMatchCommit;
    }

    public boolean isMatchCommitter() {
        return this.isMatchCommitter;
    }

    public void setMatchCommitter(boolean isMatchCommitter) {
        this.isMatchCommitter = isMatchCommitter;
    }

    public boolean isMatchAuthor() {
        return this.isMatchAuthor;
    }

    public void setMatchAuthor(boolean isMatchAuthor) {
        this.isMatchAuthor = isMatchAuthor;
    }

    public boolean isMatchTree() {
        return this.isMatchTree;
    }

    public void setMatchTree(boolean isMatchTree) {
        this.isMatchTree = isMatchTree;
    }

    public boolean isMatchMessage() {
        return this.isMatchMessage;
    }

    public void setMatchMessage(boolean isMatchMessage) {
        this.isMatchMessage = isMatchMessage;
    }

    public boolean isMatchParents() {
        return this.isMatchParents;
    }

    public void setMatchParents(boolean isMatchParents) {
        this.isMatchParents = isMatchParents;
    }

    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    public void setCaseSensitive(boolean isCaseSensitive) {
        this.isCaseSensitive = isCaseSensitive;
    }

    public boolean isRegExSearch() {
        return this.isRegExSearch;
    }

    public void setRegExSearch(boolean isRegExSearch) {
        this.isRegExSearch = isRegExSearch;
    }

    public String getTextPattern() {
        return this.textPattern;
    }

    public void setTextPattern(String textPattern) {
        this.textPattern = textPattern;
    }

    public boolean isAllBranches() {
        return this.isAllBranches;
    }

    public void setAllBranches(boolean isAllBranches) {
        this.isAllBranches = isAllBranches;
    }
}

