/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.ui.editor.cheatsheet.comp;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IEditable;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.internal.core.AbstractModel;
import org.eclipse.pde.internal.ua.core.cheatsheet.comp.CompCSModel;
import org.eclipse.pde.internal.ua.core.cheatsheet.comp.CompCSWorkspaceModel;
import org.eclipse.pde.internal.ua.ui.PDEUserAssistanceUIPlugin;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.context.UTF8InputContext;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;

public class CompCSInputContext
extends UTF8InputContext {
    public static final String CONTEXT_ID = "compcs-context";

    public CompCSInputContext(PDEFormEditor editor, IEditorInput input, boolean primary) {
        super(editor, input, primary);
        this.create();
    }

    protected void addTextEditOperation(ArrayList ops, IModelChangedEvent event) {
    }

    protected IBaseModel createModel(IEditorInput input) throws CoreException {
        CompCSWorkspaceModel model = null;
        if (input instanceof IStorageEditorInput) {
            try {
                if (input instanceof IFileEditorInput) {
                    IFile file = ((IFileEditorInput)input).getFile();
                    model = new CompCSWorkspaceModel(file, true);
                    model.load();
                } else if (input instanceof IStorageEditorInput) {
                    BufferedInputStream is = new BufferedInputStream(((IStorageEditorInput)input).getStorage().getContents());
                    model = new CompCSModel();
                    model.load((InputStream)is, false);
                }
            }
            catch (CoreException e) {
                PDEUserAssistanceUIPlugin.logException(e);
                return null;
            }
        }
        return model;
    }

    public String getId() {
        return CONTEXT_ID;
    }

    protected String getPartitionName() {
        return "___compcs_partition";
    }

    protected void flushModel(IDocument doc) {
        if (!(this.getModel() instanceof IEditable)) {
            return;
        }
        IEditable editableModel = (IEditable)this.getModel();
        if (!editableModel.isDirty()) {
            return;
        }
        try {
            StringWriter swriter = new StringWriter();
            PrintWriter writer = new PrintWriter(swriter);
            editableModel.save(writer);
            writer.flush();
            swriter.close();
            String content = swriter.toString();
            content = AbstractModel.fixLineDelimiter((String)content, (IFile)((IFile)((IModel)this.getModel()).getUnderlyingResource()));
            doc.set(content);
        }
        catch (IOException e) {
            PDEUserAssistanceUIPlugin.logException(e);
        }
    }
}

