/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class JavaWorkbenchAdapter
implements IWorkbenchAdapter {
    protected static final Object[] NO_CHILDREN = new Object[0];
    private JavaElementImageProvider fImageProvider = new JavaElementImageProvider();

    public Object[] getChildren(Object element) {
        IJavaElement je = this.getJavaElement(element);
        if (je instanceof IParent) {
            try {
                return ((IParent)je).getChildren();
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
        }
        return NO_CHILDREN;
    }

    public ImageDescriptor getImageDescriptor(Object element) {
        IJavaElement je = this.getJavaElement(element);
        if (je != null) {
            return this.fImageProvider.getJavaImageDescriptor(je, 3);
        }
        return null;
    }

    public String getLabel(Object element) {
        return JavaElementLabels.getTextLabel(this.getJavaElement(element), JavaElementLabels.ALL_DEFAULT);
    }

    public Object getParent(Object element) {
        IJavaElement je = this.getJavaElement(element);
        return je != null ? je.getParent() : null;
    }

    private IJavaElement getJavaElement(Object element) {
        if (element instanceof IJavaElement) {
            return (IJavaElement)element;
        }
        if (element instanceof IClassFileEditorInput) {
            return ((IClassFileEditorInput)element).getClassFile().getPrimaryElement();
        }
        return null;
    }
}

