/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.product;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.core.iproduct.IPreferencesInfo;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.pde.internal.core.util.PDETextHelper;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.wizards.ResizableWizardDialog;
import org.eclipse.pde.internal.ui.wizards.tools.ConvertPreferencesWizard;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;

public class PreferencesSection
extends PDESection {
    private static final String PREFS_CUSTOMIZATION_FILE = "plugin_customization.ini";
    private static final String EXTENSION_PREFS_CUSTOMIZATION = "preferenceCustomization";
    public static final String EXTENSION_PRODUCT = "org.eclipse.core.runtime.products";
    public static final String ELEMENT_PRODUCT = "product";
    FormText configText;

    public PreferencesSection(PDEFormPage page, Composite parent) {
        super(page, parent, 128);
        this.createClient(this.getSection(), page.getEditor().getToolkit());
    }

    @Override
    protected void createClient(Section section, FormToolkit toolkit) {
        section.setLayout((Layout)FormLayoutFactory.createClearTableWrapLayout(false, 1));
        TableWrapData data = new TableWrapData(256);
        section.setLayoutData((Object)data);
        section.setText(PDEUIMessages.PreferencesSection_title);
        section.setDescription(PDEUIMessages.PreferencesSection_description);
        Composite client = toolkit.createComposite((Composite)section);
        client.setLayout((Layout)FormLayoutFactory.createSectionClientTableWrapLayout(false, 1));
        client.setLayoutData((Object)new TableWrapData(256));
        this.configText = toolkit.createFormText(client, true);
        String config = this.getWizardConfigText();
        this.configText.setText(config, true, true);
        data = new TableWrapData(256);
        this.configText.setLayoutData((Object)data);
        this.configText.addHyperlinkListener(new IHyperlinkListener(){

            public void linkEntered(HyperlinkEvent e) {
                IStatusLineManager mng = PreferencesSection.this.getPage().getEditor().getEditorSite().getActionBars().getStatusLineManager();
                mng.setMessage(e.getLabel());
            }

            public void linkExited(HyperlinkEvent e) {
                IStatusLineManager mng = PreferencesSection.this.getPage().getEditor().getEditorSite().getActionBars().getStatusLineManager();
                mng.setMessage(null);
            }

            public void linkActivated(HyperlinkEvent e) {
                String href = (String)e.getHref();
                if (href.equals("command.generate")) {
                    PreferencesSection.this.handleGenerate();
                } else if (href.equals("navigate.overview")) {
                    PreferencesSection.this.getPage().getEditor().setActivePage("overview");
                }
            }
        });
        toolkit.paintBordersFor(client);
        section.setClient((Control)client);
        this.getModel().addModelChangedListener((IModelChangedListener)this);
    }

    private String getWizardConfigText() {
        IPreferencesInfo info = this.getPreferencesInfo();
        Object[] bindings = new String[]{info.getSourceFilePath() == null ? PDEUIMessages.PreferencesSection_epf : "<br></br><b>" + TextProcessor.process((String)info.getSourceFilePath()) + "</b><br></br><br></br>", info.getPreferenceCustomizationPath() == null ? PDEUIMessages.PreferencesSection_customize : "<br></br><b>" + TextProcessor.process((String)info.getPreferenceCustomizationPath()) + "</b><br></br>", this.getOverwrite() ? PDEUIMessages.PreferencesSection_overwrite : PDEUIMessages.PreferencesSection_merge};
        String configText = NLS.bind((String)PDEUIMessages.PreferencesSection_generate, (Object[])bindings);
        return configText;
    }

    void handleGenerate() {
        IPluginElement propertyElement;
        IPluginElement productElement;
        IPluginExtension productExtension;
        String preferenceCustomizationPath = null;
        String id = this.getProduct().getDefiningPluginId();
        IPluginModelBase model = PluginRegistry.findModel((String)id);
        if (model == null || model.getUnderlyingResource() == null) {
            MessageDialog.openError((Shell)this.getSection().getShell(), (String)NLS.bind((String)PDEUIMessages.PreferencesSection_errorNoDefiningPluginTitle, (Object)(id == null ? "" : id)), (String)PDEUIMessages.PreferencesSection_errorNoDefiningPlugin);
            return;
        }
        IProject project = model.getUnderlyingResource().getProject();
        IPreferencesInfo info = this.getPreferencesInfo();
        if (info != null) {
            preferenceCustomizationPath = info.getPreferenceCustomizationPath();
        }
        if ((preferenceCustomizationPath == null || preferenceCustomizationPath.length() == 0) && (productExtension = this.findProductExtension(model)) != null && (productElement = this.findProductElement(productExtension)) != null && (propertyElement = this.findPrefCustPropertyElement(productElement)) != null) {
            IPluginAttribute valueAttribute = propertyElement.getAttribute("value");
            preferenceCustomizationPath = valueAttribute.getValue();
        }
        try {
            IFile buildProps;
            IFile customizationFile;
            if (preferenceCustomizationPath == null || preferenceCustomizationPath.length() == 0) {
                boolean existing;
                IResource resource = project.findMember(PREFS_CUSTOMIZATION_FILE);
                boolean bl = existing = resource != null && resource instanceof IFile;
                if (existing) {
                    preferenceCustomizationPath = ((IFile)resource).getFullPath().toString();
                } else {
                    IFile customFile = project.getFile(PREFS_CUSTOMIZATION_FILE);
                    preferenceCustomizationPath = customFile.getFullPath().toString();
                    byte[] bytes = "".getBytes();
                    ByteArrayInputStream source = new ByteArrayInputStream(bytes);
                    customFile.create((InputStream)source, 0, null);
                }
            }
            if (!(customizationFile = project.getWorkspace().getRoot().getFile((IPath)new Path(preferenceCustomizationPath))).exists()) {
                byte[] bytes = "".getBytes();
                ByteArrayInputStream source = new ByteArrayInputStream(bytes);
                customizationFile.create((InputStream)source, 0, null);
            }
            if ((buildProps = PDEProject.getBuildProperties((IProject)project)).exists()) {
                WorkspaceBuildModel wkspc = new WorkspaceBuildModel(buildProps);
                wkspc.load();
                if (wkspc.isLoaded()) {
                    IBuildEntry entry = wkspc.getBuild().getEntry("bin.includes");
                    if (entry == null) {
                        entry = wkspc.getFactory().createEntry("bin.includes");
                        wkspc.getBuild().add(entry);
                    }
                    if (!entry.contains(preferenceCustomizationPath)) {
                        entry.addToken(preferenceCustomizationPath);
                    }
                    wkspc.save();
                }
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e, null, NLS.bind((String)PDEUIMessages.PreferencesSection_errorReading, (Object)preferenceCustomizationPath));
            return;
        }
        ConvertPreferencesWizard wizard = new ConvertPreferencesWizard(preferenceCustomizationPath, this.getPreferencesInfo().getSourceFilePath(), this.getOverwrite());
        ResizableWizardDialog wd = new ResizableWizardDialog(PDEPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
        wd.create();
        if (wd.open() == 0) {
            info = this.getPreferencesInfo();
            preferenceCustomizationPath = info.getPreferenceCustomizationPath();
            info.setPreferenceCustomizationPath(wizard.getPluginCustomizationFilePath());
            info.setSourceFilePath(wizard.getPreferencesFilePath());
            info.setOverwrite(Boolean.toString(wizard.getOverwrite()));
            this.configText.setText(this.getWizardConfigText(), true, true);
            this.getSection().getParent().layout();
        }
    }

    private boolean getOverwrite() {
        boolean overwrite = false;
        if (this.getPreferencesInfo().getOverwrite() != null) {
            overwrite = Boolean.parseBoolean(this.getPreferencesInfo().getOverwrite());
        }
        return overwrite;
    }

    private IPluginElement findPrefCustPropertyElement(IPluginElement productElement) {
        if (productElement.getChildCount() == 0) {
            return null;
        }
        IPluginObject[] objects = productElement.getChildren();
        int i = 0;
        while (i < objects.length) {
            IPluginElement element;
            IPluginAttribute nameAttribute;
            if (objects[i] instanceof IPluginElement && objects[i].getName().equals("property") && (nameAttribute = (element = (IPluginElement)objects[i]).getAttribute("name")) != null && PDETextHelper.isDefined((String)nameAttribute.getValue()) && nameAttribute.getValue().equals(EXTENSION_PREFS_CUSTOMIZATION)) {
                return element;
            }
            ++i;
        }
        return null;
    }

    private IPluginElement findProductElement(IPluginExtension extension) {
        if (extension.getChildCount() != 1) {
            return null;
        }
        IPluginObject pluginObject = extension.getChildren()[0];
        if (!(pluginObject instanceof IPluginElement)) {
            return null;
        }
        if (!pluginObject.getName().equals(ELEMENT_PRODUCT)) {
            return null;
        }
        return (IPluginElement)pluginObject;
    }

    private IPluginExtension findProductExtension(IPluginModelBase model) {
        IPluginExtension[] extensions = model.getPluginBase().getExtensions();
        int i = 0;
        while (i < extensions.length) {
            String id;
            String point = extensions[i].getPoint();
            if (point.equals(EXTENSION_PRODUCT) && (id = String.valueOf(model.getPluginBase().getId()) + '.' + extensions[i].getId()).equals(this.getProduct().getId())) {
                return extensions[i];
            }
            ++i;
        }
        return null;
    }

    private IPreferencesInfo getPreferencesInfo() {
        IPreferencesInfo info = this.getProduct().getPreferencesInfo();
        if (info == null) {
            info = this.getModel().getFactory().createPreferencesInfo();
            this.getProduct().setPreferencesInfo(info);
        }
        return info;
    }

    private IProduct getProduct() {
        return this.getModel().getProduct();
    }

    private IProductModel getModel() {
        return (IProductModel)this.getPage().getPDEEditor().getAggregateModel();
    }

    @Override
    public boolean canPaste(Clipboard clipboard) {
        Display d = this.getSection().getDisplay();
        Control c = d.getFocusControl();
        return c instanceof Text;
    }

    @Override
    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.handleModelEventWorldChanged(e);
        }
    }

    private void handleModelEventWorldChanged(IModelChangedEvent event) {
        this.refresh();
    }

    public void dispose() {
        IProductModel model = this.getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }
}

