/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.job.RuleUtil;
import org.eclipse.egit.core.internal.util.ProjectUtil;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.TeamException;

public class ResetOperation
implements IEGitOperation {
    private final Repository repository;
    private final String refName;
    private final ResetCommand.ResetType type;

    public ResetOperation(Repository repository, String refName, ResetCommand.ResetType type) {
        this.repository = repository;
        this.refName = refName;
        this.type = type;
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        if (this.type == ResetCommand.ResetType.HARD) {
            return RuleUtil.getRule(this.repository);
        }
        return null;
    }

    @Override
    public void execute(IProgressMonitor m) throws CoreException {
        Object monitor = m == null ? new NullProgressMonitor() : m;
        if (this.type == ResetCommand.ResetType.HARD) {
            IWorkspaceRunnable action = new IWorkspaceRunnable(){

                public void run(IProgressMonitor actMonitor) throws CoreException {
                    ResetOperation.this.reset(actMonitor);
                }
            };
            ResourcesPlugin.getWorkspace().run(action, this.getSchedulingRule(), 1, monitor);
        } else {
            this.reset((IProgressMonitor)monitor);
        }
    }

    private void reset(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(NLS.bind((String)CoreText.ResetOperation_performingReset, (Object)this.type.toString().toLowerCase(), (Object)this.refName), 2);
        IProject[] validProjects = null;
        if (this.type == ResetCommand.ResetType.HARD) {
            validProjects = ProjectUtil.getValidOpenProjects(this.repository);
            ResourceUtil.saveLocalHistory(this.repository);
        }
        ResetCommand reset = Git.wrap((Repository)this.repository).reset();
        reset.setMode(this.type);
        reset.setRef(this.refName);
        try {
            reset.call();
        }
        catch (GitAPIException e) {
            throw new TeamException(e.getLocalizedMessage(), e.getCause());
        }
        monitor.worked(1);
        if (this.type == ResetCommand.ResetType.HARD) {
            ProjectUtil.refreshValidProjects(validProjects, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        monitor.done();
    }
}

