/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.refactoring;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationMessages;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationPlugin;
import org.eclipse.jdt.internal.core.manipulation.Messages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ContentStamp;
import org.eclipse.ltk.core.refactoring.UndoTextFileChange;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.text.edits.UndoEdit;

class UndoCompilationUnitChange
extends UndoTextFileChange {
    private ICompilationUnit fCUnit;

    public UndoCompilationUnitChange(String name, ICompilationUnit unit, UndoEdit undo, ContentStamp stampToRestore, int saveMode) throws CoreException {
        super(name, UndoCompilationUnitChange.getFile(unit), undo, stampToRestore, saveMode);
        this.fCUnit = unit;
    }

    private static IFile getFile(ICompilationUnit cunit) throws CoreException {
        IFile file = (IFile)cunit.getResource();
        if (file == null) {
            String message = Messages.format(JavaManipulationMessages.UndoCompilationUnitChange_no_file, TextProcessor.process((String)cunit.getElementName()));
            throw new CoreException((IStatus)new Status(4, JavaManipulationPlugin.getPluginId(), message));
        }
        return file;
    }

    public Object getModifiedElement() {
        return this.fCUnit;
    }

    protected Change createUndoChange(UndoEdit edit, ContentStamp stampToRestore) throws CoreException {
        return new UndoCompilationUnitChange(this.getName(), this.fCUnit, edit, stampToRestore, this.getSaveMode());
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 2);
        this.fCUnit.becomeWorkingCopy((IProgressMonitor)new SubProgressMonitor(pm, 1));
        try {
            Change change = super.perform((IProgressMonitor)new SubProgressMonitor(pm, 1));
            return change;
        }
        finally {
            this.fCUnit.discardWorkingCopy();
        }
    }
}

