/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.infoviews;

import org.eclipse.jdt.internal.ui.infoviews.InfoViewMessages;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IAbstractTextEditorHelpContextIds;

class CopyToClipboardAction
extends SelectionDispatchAction {
    private static final int MAX_REPEAT_COUNT = 10;
    private Clipboard fClipboard;

    public CopyToClipboardAction(IWorkbenchSite site) {
        super(site);
        this.setText(InfoViewMessages.CopyAction_label);
        this.setToolTipText(InfoViewMessages.CopyAction_tooltip);
        this.setDescription(InfoViewMessages.CopyAction_description);
        ISharedImages workbenchImages = PlatformUI.getWorkbench().getSharedImages();
        this.setDisabledImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        this.setImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.setHoverImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_COPY"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, IAbstractTextEditorHelpContextIds.COPY_ACTION);
        this.update(this.getSelection());
    }

    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(selection != null && selection.getLength() > 0);
    }

    public void run(ITextSelection selection) {
        this.fClipboard = new Clipboard(this.getShell().getDisplay());
        try {
            this.copyToClipboard(selection, 0);
        }
        finally {
            this.fClipboard.dispose();
        }
    }

    private void copyToClipboard(ITextSelection selection, int repeatCount) {
        block3: {
            try {
                this.fClipboard.setContents((Object[])new String[]{selection.getText()}, new Transfer[]{TextTransfer.getInstance()});
            }
            catch (SWTError e) {
                if (e.code != 2002 || repeatCount >= 10) {
                    throw e;
                }
                if (!MessageDialog.openQuestion((Shell)this.getShell(), (String)InfoViewMessages.CopyToClipboard_error_title, (String)InfoViewMessages.CopyToClipboard_error_message)) break block3;
                this.copyToClipboard(selection, repeatCount + 1);
            }
        }
    }
}

