/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.plugin.ImportObject;
import org.eclipse.pde.internal.ui.editor.actions.OpenSchemaAction;
import org.eclipse.pde.internal.ui.search.FindDeclarationsAction;
import org.eclipse.pde.internal.ui.search.FindReferencesAction;
import org.eclipse.pde.internal.ui.search.ShowDescriptionAction;
import org.eclipse.pde.internal.ui.search.dependencies.DependencyExtentAction;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;

public class PluginSearchActionGroup
extends ActionGroup {
    private IBaseModel fModel;

    public void setBaseModel(IBaseModel model) {
        this.fModel = model;
    }

    public void fillContextMenu(IMenuManager menu) {
        IStructuredSelection sSelection;
        ActionContext context = this.getContext();
        ISelection selection = context.getSelection();
        if (selection instanceof IStructuredSelection && (sSelection = (IStructuredSelection)selection).size() == 1) {
            Object object = sSelection.getFirstElement();
            this.addShowDescriptionAction(object, menu);
            this.addOpenSchemaAction(object, menu);
            this.addFindDeclarationsAction(object, menu);
            this.addFindReferencesAction(object, menu);
            this.addDependencyExtentAction(object, menu);
        }
    }

    private void addOpenSchemaAction(Object object, IMenuManager menu) {
        if (object instanceof IPluginExtension) {
            OpenSchemaAction action = new OpenSchemaAction();
            action.setInput((IPluginExtension)object);
            action.setEnabled(true);
            menu.add((IAction)action);
        } else if (object instanceof IPluginExtensionPoint) {
            OpenSchemaAction action = new OpenSchemaAction();
            IPluginExtensionPoint point = (IPluginExtensionPoint)object;
            String pointID = point.getFullId();
            if (pointID.indexOf(46) == -1) {
                action.setInput(this.fullyQualifyPointID(pointID));
            } else {
                action.setInput(pointID);
            }
            action.setEnabled(true);
            menu.add((IAction)action);
        }
    }

    private void addFindDeclarationsAction(Object object, IMenuManager menu) {
        if (object instanceof ImportObject) {
            object = ((ImportObject)object).getImport();
        }
        if (object instanceof IPluginBase || object instanceof IPluginExtension || object instanceof IPluginImport) {
            menu.add((IAction)new FindDeclarationsAction(object));
        }
    }

    private void addShowDescriptionAction(Object object, IMenuManager menu) {
        if (object instanceof IPluginExtensionPoint) {
            IPluginExtensionPoint extPoint = (IPluginExtensionPoint)object;
            String pointID = extPoint.getFullId();
            if (pointID.indexOf(46) == -1) {
                pointID = this.fullyQualifyPointID(pointID);
            }
            menu.add((IAction)new ShowDescriptionAction(extPoint, pointID));
        } else if (object instanceof IPluginExtension) {
            String point = ((IPluginExtension)object).getPoint();
            IPluginExtensionPoint extPoint = PDECore.getDefault().getExtensionsRegistry().findExtensionPoint(point);
            if (extPoint != null) {
                menu.add((IAction)new ShowDescriptionAction(extPoint));
            }
        }
    }

    private String fullyQualifyPointID(String pointID) {
        if (this.fModel instanceof IPluginModelBase) {
            String basePointID = ((IPluginModelBase)this.fModel).getPluginBase().getId();
            pointID = String.valueOf(basePointID) + '.' + pointID;
        }
        return pointID;
    }

    private void addFindReferencesAction(Object object, IMenuManager menu) {
        if (object instanceof IPluginModelBase) {
            object = ((IPluginModelBase)object).getPluginBase();
        } else if (object instanceof ImportObject) {
            object = ((ImportObject)object).getImport();
        }
        if (object instanceof IPluginExtensionPoint || object instanceof IPluginImport || object instanceof IPlugin || object instanceof IPluginExtension) {
            String basePointID = this.fModel instanceof IPluginModelBase ? ((IPluginModelBase)this.fModel).getPluginBase().getId() : null;
            menu.add((IAction)new FindReferencesAction(object, basePointID));
        }
    }

    private void addDependencyExtentAction(Object object, IMenuManager menu) {
        if (object instanceof ImportObject) {
            object = ((ImportObject)object).getImport();
        }
        if (object instanceof IPluginImport) {
            String id = ((IPluginImport)object).getId();
            IResource resource = ((IPluginImport)object).getModel().getUnderlyingResource();
            if (resource != null) {
                menu.add((IAction)new DependencyExtentAction(resource.getProject(), id));
            }
        }
    }
}

