/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.report.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.search.Q7SearchCore;
import org.eclipse.rcptt.ecl.core.ProcessStatus;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.rcptt.reporting.Q7Info;
import org.eclipse.rcptt.reporting.core.SimpleSeverity;
import org.eclipse.rcptt.reporting.core.TimeFormatHelper;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Node;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Report;
import org.eclipse.rcptt.ui.controls.AbstractEmbeddedComposite;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class TestCaseComposite
extends AbstractEmbeddedComposite {
    private Composite control;
    private Report report;

    protected void fillActions(IToolBarManager manager) {
    }

    public TestCaseComposite(Report report) {
        this.report = report;
    }

    public String getName() {
        return this.report.getRoot().getName();
    }

    public Image getImage() {
        return Images.getImage((String)"icons/file.gif");
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.control = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.control);
        GridLayoutFactory.swtDefaults().numColumns(2).equalWidth(false).applyTo(this.control);
        TreeViewer viewer = new TreeViewer(this.control, 68354);
        Tree tree = viewer.getTree();
        tree.setHeaderVisible(true);
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, 100).applyTo(viewer.getControl());
        TreeColumn testcaseColumn = new TreeColumn(tree, 0);
        testcaseColumn.setText("Test case");
        testcaseColumn.setWidth(200);
        TreeColumn statusColumn = new TreeColumn(tree, 0);
        statusColumn.setText("Status");
        statusColumn.setWidth(80);
        TreeColumn timeColumn = new TreeColumn(tree, 0);
        timeColumn.setText("Time");
        timeColumn.setWidth(80);
        viewer.setLabelProvider((IBaseLabelProvider)new ReportEntryLabelProvider());
        viewer.setContentProvider((IContentProvider)new ReportEntryContentProvider());
        viewer.setInput((Object)this.report);
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                ArrayList<Node> nodes = new ArrayList<Node>();
                Iterator i = selection.iterator();
                while (i.hasNext()) {
                    this.addNodes(nodes, (Node)i.next());
                }
                TestCaseComposite.this.doNodesSelection(nodes);
            }

            private void addNodes(List<Node> nodes, Node next) {
                if (!nodes.contains(next)) {
                    nodes.add(next);
                }
            }
        });
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection thisSelection = (IStructuredSelection)event.getSelection();
                Object selectedNode = thisSelection.getFirstElement();
                if (selectedNode == null || !(selectedNode instanceof Node)) {
                    return;
                }
                Node node = (Node)selectedNode;
                Q7Info info = (Q7Info)node.getProperties().get((Object)"q7");
                if (info == null) {
                    return;
                }
                String id = info.getId();
                IQ7NamedElement element = Q7SearchCore.findById((String)id);
                if (element == null) {
                    return;
                }
                try {
                    IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)((IFile)element.getResource()));
                }
                catch (PartInitException partInitException) {}
            }
        });
    }

    protected void doNodesSelection(List<Node> nodes) {
    }

    public Control getControl() {
        return this.control;
    }

    private class ReportEntryContentProvider
    implements ITreeContentProvider {
        private ReportEntryContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return new Object[]{TestCaseComposite.this.report.getRoot()};
        }

        public Object[] getChildren(Object parentElement) {
            Node nde = (Node)parentElement;
            return nde.getChildren().toArray();
        }

        public Object getParent(Object element) {
            Node nde = (Node)element;
            return nde.getParent();
        }

        public boolean hasChildren(Object element) {
            Node nde = (Node)element;
            return !nde.getChildren().isEmpty();
        }
    }

    private class ReportEntryLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ReportEntryLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            Node entry = (Node)element;
            Q7Info object = (Q7Info)entry.getProperties().get((Object)"q7");
            if (object != null) {
                SimpleSeverity severity = SimpleSeverity.create((Q7Info)object);
                switch (object.getType()) {
                    case TESTCASE: 
                    case SCRIPT: {
                        if (severity == SimpleSeverity.OK) {
                            return Images.getImage((String)"icons/launching/testok.gif");
                        }
                        if (severity == SimpleSeverity.CANCEL) {
                            return Images.getImage((String)"icons/scenario.gif");
                        }
                        return Images.getImage((String)"icons/launching/testerr.gif");
                    }
                    case CONTEXT: {
                        if (severity == SimpleSeverity.OK) {
                            return Images.getImage((String)"icons/launching/contextok.gif");
                        }
                        if (severity == SimpleSeverity.CANCEL) {
                            return Images.getImage((String)"icons/context.gif");
                        }
                        return Images.getImage((String)"icons/launching/contexterr.gif");
                    }
                    case VERIFICATION: {
                        if (severity == SimpleSeverity.OK) {
                            return Images.getImage((String)"icons/launching/verification-pass.png");
                        }
                        if (severity == SimpleSeverity.CANCEL) {
                            return Images.getImage((String)"icons/verification.gif");
                        }
                        return Images.getImage((String)"icons/launching/verification-fail.png");
                    }
                    case ECL_COMMAND: {
                        if (severity == SimpleSeverity.OK) {
                            return Images.getImage((String)"icons/ecl/cmd.gif");
                        }
                        if (severity == SimpleSeverity.CANCEL) {
                            return Images.getOverlayImageBottomLeft((String)"icons/ecl/cmd.gif", (String)"icons/overlay/warning_co.gif");
                        }
                        return Images.getOverlayImageBottomLeft((String)"icons/ecl/cmd.gif", (String)"icons/overlay/error_co.gif");
                    }
                    case TEST_SUITE: {
                        if (severity == SimpleSeverity.OK) {
                            return Images.getImage((String)"icons/launching/tsuiteok.gif");
                        }
                        if (severity == SimpleSeverity.CANCEL) {
                            return Images.getImage((String)"icons/launching/tsuitestop.gif");
                        }
                        return Images.getImage((String)"icons/launching/tsuiteerror.gif");
                    }
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            Node entry = (Node)element;
            Q7Info object = (Q7Info)entry.getProperties().get((Object)"q7");
            switch (columnIndex) {
                case 0: {
                    return entry.getName();
                }
                case 1: {
                    if (object != null) {
                        return SimpleSeverity.create((ProcessStatus)object.getResult()).name();
                    }
                    return "";
                }
                case 2: {
                    return TimeFormatHelper.format((long)(entry.getEndTime() - entry.getStartTime()));
                }
            }
            return null;
        }
    }
}

