/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.revision;

import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.revision.EditableRevision;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.team.core.history.IFileRevision;

public class LocationEditableRevision
extends EditableRevision {
    private final IPath location;
    private final IRunnableContext runnableContext;

    public LocationEditableRevision(IFileRevision fileRevision, IPath location, IRunnableContext runnableContext) {
        super(fileRevision, null);
        this.location = location;
        Assert.isNotNull((Object)runnableContext);
        this.runnableContext = runnableContext;
    }

    @Override
    public void setContent(final byte[] newContent) {
        try {
            IFile ourFile;
            ISchedulingRule rule = Job.getJobManager().currentRule();
            boolean fork = true;
            if (rule instanceof IResource && (ourFile = ResourcesPlugin.getWorkspace().getRoot().getFile(this.location)).exists() && ((IResource)rule).isConflicting((ISchedulingRule)ourFile)) {
                fork = false;
            }
            this.runnableContext.run(fork, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    IFileStore store = EFS.getLocalFileSystem().getStore(LocationEditableRevision.this.location);
                    FilterOutputStream out = null;
                    try {
                        try {
                            out = new BufferedOutputStream(store.openOutputStream(0, monitor));
                            out.write(newContent);
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                        catch (IOException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    catch (Throwable throwable) {
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            Activator.handleError(e.getTargetException().getMessage(), e.getTargetException(), true);
        }
        catch (InterruptedException interruptedException) {}
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        result = 31 * result + (this.runnableContext == null ? 0 : this.runnableContext.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LocationEditableRevision other = (LocationEditableRevision)obj;
        if (this.location == null ? other.location != null : !this.location.equals((Object)other.location)) {
            return false;
        }
        return !(this.runnableContext == null ? other.runnableContext != null : !this.runnableContext.equals(other.runnableContext));
    }
}

