/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.e4.ui.addons;

import java.util.Optional;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.passage.lic.internal.api.ServiceInvocationResult;
import org.eclipse.passage.lic.internal.api.restrictions.ExaminationCertificate;
import org.eclipse.passage.lic.internal.base.restrictions.CertificateIsRestrictive;
import org.eclipse.passage.lic.internal.e4.ui.restrictions.WorkbenchShutdown;
import org.eclipse.passage.lic.internal.equinox.EquinoxPassage;
import org.eclipse.passage.lic.internal.equinox.LicensedProductFromContext;
import org.eclipse.passage.lic.internal.jface.EquinoxPassageUI;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;

public final class E4LicensingAddon {
    private final IApplicationContext application;
    private final IEclipseContext context;
    private Optional<ExaminationCertificate> certificate = Optional.empty();

    @Inject
    public E4LicensingAddon(IApplicationContext application, IEclipseContext context) {
        this.application = application;
        this.context = context;
    }

    @Inject
    @org.eclipse.e4.core.di.annotations.Optional
    public void applicationStarted(@UIEventTopic(value="org/eclipse/e4/ui/LifeCycle/appStartupComplete") Event event) {
        ServiceInvocationResult response = new EquinoxPassageUI(this::shell).acquireLicense(new LicensedProductFromContext(this.application).get().identifier());
        this.certificate = response.data();
        if (new CertificateIsRestrictive().test(this.certificate)) {
            new WorkbenchShutdown().run();
        }
    }

    @Inject
    @org.eclipse.e4.core.di.annotations.Optional
    public void applicationFainted(@UIEventTopic(value="org/eclipse/e4/ui/LifeCycle/appShutdownStarted") Event event) {
        this.certificate.ifPresent(arg_0 -> ((EquinoxPassage)new EquinoxPassage()).releaseLicense(arg_0));
    }

    private Shell shell() {
        return (Shell)this.context.get(Shell.class);
    }
}

