/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.jface.dialogs;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.passage.lic.api.LicensingResult;
import org.eclipse.swt.widgets.Shell;

public final class LicensingResultDialogs {
    public static void openMessageDialog(Shell parent, String title, LicensingResult result) {
        int severity = result.getSeverity();
        String message = LicensingResultDialogs.prepareMessage(result);
        switch (severity) {
            case 0: 
            case 1: {
                MessageDialog.openInformation((Shell)parent, (String)title, (String)message);
                return;
            }
            case 2: {
                MessageDialog.openWarning((Shell)parent, (String)title, (String)message);
                return;
            }
            case 4: 
            case 8: {
                MessageDialog.openError((Shell)parent, (String)title, (String)message);
                return;
            }
        }
        MessageDialog.openError((Shell)parent, (String)title, (String)message);
    }

    public static void updateTitleDialog(TitleAreaDialog dialog, LicensingResult result) {
        int severity = result.getSeverity();
        String message = LicensingResultDialogs.prepareMessage(result);
        switch (severity) {
            case 0: {
                dialog.setErrorMessage(null);
                dialog.setMessage(message);
                return;
            }
            case 1: {
                dialog.setErrorMessage(null);
                dialog.setMessage(message, 1);
                return;
            }
            case 2: {
                dialog.setErrorMessage(null);
                dialog.setMessage(message, 2);
                return;
            }
            case 4: 
            case 8: {
                dialog.setErrorMessage(message);
                return;
            }
        }
        dialog.setErrorMessage(message);
    }

    private static String prepareMessage(LicensingResult result) {
        StringBuilder builder = new StringBuilder();
        builder.append(result.getMessage());
        LicensingResultDialogs.collectMessages(result.getChildren(), builder, String.valueOf('\t'), 1);
        return builder.toString();
    }

    private static void collectMessages(Iterable<LicensingResult> children, StringBuilder builder, String indent, int level) {
        for (LicensingResult result : children) {
            builder.append('\n');
            int i = 0;
            while (i < level) {
                builder.append(indent);
                ++i;
            }
            builder.append(result.getMessage());
            LicensingResultDialogs.collectMessages(result.getChildren(), builder, indent, level + 1);
        }
    }
}

