/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.widgets;

import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.jface.widgets.AbstractCompositeFactory;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;

public final class ShellFactory
extends AbstractCompositeFactory<ShellFactory, Shell> {
    private ShellFactory(int style) {
        super(ShellFactory.class, (Composite parent) -> new Shell((Shell)parent, style));
    }

    @Override
    public final Shell create(Display display) {
        Shell shell = new Shell(display);
        this.applyProperties(shell);
        return shell;
    }

    public static ShellFactory newShell(int style) {
        return new ShellFactory(style);
    }

    public ShellFactory text(String text) {
        this.addProperty(shell -> shell.setText(text));
        return this;
    }

    public ShellFactory minimized(boolean minimized) {
        this.addProperty(shell -> shell.setMinimized(minimized));
        return this;
    }

    public ShellFactory maximized(boolean maximized) {
        this.addProperty(shell -> shell.setMaximized(maximized));
        return this;
    }

    public ShellFactory fullScreen(boolean fullScreen) {
        this.addProperty(shell -> shell.setFullScreen(fullScreen));
        return this;
    }

    public ShellFactory menuBar(Function<Decorations, Menu> menuFunction) {
        this.addProperty(shell -> shell.setMenuBar((Menu)menuFunction.apply((Decorations)shell)));
        return this;
    }

    public ShellFactory onActivate(Consumer<ShellEvent> consumer) {
        this.addProperty(shell -> shell.addShellListener(ShellListener.shellActivatedAdapter((Consumer)consumer)));
        return this;
    }

    public ShellFactory onDeactivate(Consumer<ShellEvent> consumer) {
        this.addProperty(shell -> shell.addShellListener(ShellListener.shellDeactivatedAdapter((Consumer)consumer)));
        return this;
    }

    public ShellFactory onIconify(Consumer<ShellEvent> consumer) {
        this.addProperty(shell -> shell.addShellListener(ShellListener.shellIconifiedAdapter((Consumer)consumer)));
        return this;
    }

    public ShellFactory onDeiconify(Consumer<ShellEvent> consumer) {
        this.addProperty(shell -> shell.addShellListener(ShellListener.shellDeiconifiedAdapter((Consumer)consumer)));
        return this;
    }

    public ShellFactory onClose(Consumer<ShellEvent> consumer) {
        this.addProperty(shell -> shell.addShellListener(ShellListener.shellClosedAdapter((Consumer)consumer)));
        return this;
    }
}

