/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints;

import java.math.BigInteger;
import org.sat4j.pb.constraints.AbstractPBClauseCardConstrDataStructure;
import org.sat4j.pb.constraints.AbstractPBDataStructureFactory;
import org.sat4j.pb.constraints.pb.IDataStructurePB;
import org.sat4j.pb.constraints.pb.MapPb;
import org.sat4j.pb.constraints.pb.MinWatchPb;
import org.sat4j.pb.constraints.pb.PBConstr;
import org.sat4j.pb.constraints.pb.Pseudos;
import org.sat4j.specs.Constr;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

public class PBMinDataStructure
extends AbstractPBDataStructureFactory {
    private static final long serialVersionUID = 1L;

    @Override
    protected PBConstr constraintFactory(int[] literals, BigInteger[] coefs, BigInteger degree) throws ContradictionException {
        return MinWatchPb.normalizedMinWatchPbNew(this.solver, this.getVocabulary(), literals, coefs, degree, AbstractPBClauseCardConstrDataStructure.sumOfCoefficients(coefs));
    }

    @Override
    protected Constr learntConstraintFactory(IDataStructurePB dspb) {
        return MinWatchPb.normalizedWatchPbNew(this.getVocabulary(), dspb);
    }

    private Constr learntConstraintFactory(IVecInt literals, IVec<BigInteger> coefs, BigInteger degree, boolean moreThan) {
        int[] lits = new int[literals.size()];
        literals.copyTo(lits);
        Object[] bc = new BigInteger[coefs.size()];
        coefs.copyTo(bc);
        degree = Pseudos.niceCheckedParametersForCompetition(lits, (BigInteger[])bc, moreThan, degree);
        return MinWatchPb.normalizedWatchPbNew(this.getVocabulary(), new MapPb(literals, coefs, degree));
    }

    @Override
    protected Constr learntAtLeastConstraintFactory(IVecInt literals, IVec<BigInteger> coefs, BigInteger degree) {
        return this.learntConstraintFactory(literals, coefs, degree, true);
    }

    @Override
    protected Constr learntAtMostConstraintFactory(IVecInt literals, IVec<BigInteger> coefs, BigInteger degree) {
        return this.learntConstraintFactory(literals, coefs, degree, false);
    }
}

