/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.resources.backend;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.emf.common.util.URI;
import org.eclipse.oomph.internal.resources.ResourcesPlugin;
import org.eclipse.oomph.resources.ResourcesUtil;
import org.eclipse.oomph.resources.backend.BackendContainer;
import org.eclipse.oomph.resources.backend.BackendException;
import org.eclipse.oomph.resources.backend.BackendFile;
import org.eclipse.oomph.resources.backend.BackendFolder;
import org.eclipse.oomph.resources.backend.BackendResource;
import org.eclipse.oomph.resources.backend.LocalBackendSystem;
import org.eclipse.oomph.resources.backend.Messages;
import org.eclipse.oomph.util.ObjectUtil;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.oomph.util.SynchronizedCounter;
import org.eclipse.osgi.util.NLS;

public abstract class BackendSystem
extends BackendContainer {
    private static final BackendResource[] NO_MEMBERS = new BackendResource[0];
    private static final String[] EMPTY_SEGMENTS = new String[0];
    private static final URI EMPTY_URI = URI.createHierarchicalURI((String[])EMPTY_SEGMENTS, null, null);
    private final String systemURI;
    private final AtomicInteger visitorCounter = new AtomicInteger();
    private VisitorThreadPool visitorThreadPool;

    protected BackendSystem(URI systemURI) throws BackendException {
        super(null, EMPTY_URI);
        this.systemURI = systemURI.toString();
    }

    public final URI getSystemURI() {
        return URI.createURI((String)this.systemURI);
    }

    @Override
    public final BackendResource.Type getType() {
        return BackendResource.Type.SYSTEM;
    }

    protected void beginVisitor() {
        this.visitorThreadPool = new VisitorThreadPool(this);
    }

    protected void endVisitor() {
        this.visitorThreadPool.dispose();
        this.visitorThreadPool = null;
    }

    protected Object beginConnected() {
        return null;
    }

    protected void endConnected() {
    }

    protected int getMaxThreads() {
        return Integer.MAX_VALUE;
    }

    protected abstract Object getDelegate(BackendResource var1) throws Exception;

    protected abstract Object[] getDelegateMembers(Object var1, IProgressMonitor var2) throws Exception;

    protected abstract Object getDelegateMember(Object var1, String var2, IProgressMonitor var3) throws Exception;

    protected abstract String getDelegateName(Object var1) throws Exception;

    protected abstract BackendResource.Type getDelegateType(Object var1, boolean var2) throws Exception;

    protected abstract IPath getLocation(BackendResource var1) throws Exception;

    protected abstract boolean exists(BackendResource var1, IProgressMonitor var2) throws Exception;

    protected abstract long getLastModified(BackendResource var1, IProgressMonitor var2) throws Exception;

    protected abstract InputStream getContents(BackendFile var1, IProgressMonitor var2) throws Exception;

    protected abstract ResourcesUtil.ImportResult importIntoWorkspace(BackendContainer var1, IProject var2, IProgressMonitor var3) throws Exception;

    protected final BackendFolder createBackendFolder(URI systemRelativeURI) {
        return new BackendFolder(this, systemRelativeURI);
    }

    protected final BackendFile createBackendFile(URI systemRelativeURI) {
        return new BackendFile(this, systemRelativeURI);
    }

    protected BackendResource[] getMembers(BackendContainer backendContainer, IProgressMonitor monitor) throws Exception {
        Object delegate = this.getDelegate(backendContainer);
        Object[] delegateMembers = this.getDelegateMembers(delegate, monitor);
        if (delegateMembers == null) {
            return NO_MEMBERS;
        }
        ArrayList<BackendResource> result = new ArrayList<BackendResource>(delegateMembers.length);
        int i = 0;
        while (i < delegateMembers.length) {
            ResourcesPlugin.checkCancelation((IProgressMonitor)monitor);
            Object delegateMember = delegateMembers[i];
            String name = this.getDelegateName(delegateMember);
            URI systemRelativeURI = backendContainer.getSystemRelativeURI().appendSegment(URI.encodeSegment((String)name, (boolean)false));
            BackendResource member = this.createMember(delegateMember, systemRelativeURI, false);
            if (member != null) {
                result.add(member);
            }
            ++i;
        }
        Collections.sort(result, new Comparator<BackendResource>(){

            @Override
            public int compare(BackendResource r1, BackendResource r2) {
                int t1;
                int t2 = r2 instanceof BackendContainer ? 0 : 1;
                int result = t2 - (t1 = r1 instanceof BackendContainer ? 0 : 1);
                if (result == 0) {
                    String n1 = StringUtil.safe((String)r1.getName());
                    String n2 = StringUtil.safe((String)r2.getName());
                    result = n1.compareTo(n2);
                }
                return result;
            }
        });
        return result.toArray(new BackendResource[result.size()]);
    }

    protected BackendResource findMember(BackendContainer backendContainer, URI relativeURI, IProgressMonitor monitor) throws Exception {
        Object delegate = this.getDelegate(backendContainer);
        Object delegateMember = this.getDelegateMember(delegate, relativeURI.toString(), monitor);
        URI systemRelativeURI = backendContainer.getSystemRelativeURI().appendSegments(relativeURI.segments());
        return this.createMember(delegateMember, systemRelativeURI, true);
    }

    private BackendResource createMember(Object delegateMember, URI systemRelativeURI, boolean checkExists) throws Exception {
        BackendSystem system = this.getSystem();
        BackendResource.Type type = system.getDelegateType(delegateMember, checkExists);
        if (type == null) {
            return null;
        }
        switch (type) {
            case FOLDER: {
                return system.createBackendFolder(systemRelativeURI);
            }
            case FILE: {
                return system.createBackendFile(systemRelativeURI);
            }
        }
        throw new BackendException(NLS.bind((String)Messages.BackendSystem_InvalidMember_exception, (Object)type.toString().toLowerCase(), (Object)delegateMember));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void accept(BackendResource backendResource, BackendResource.Visitor visitor, IProgressMonitor monitor) throws Exception {
        AtomicInteger atomicInteger = this.visitorCounter;
        synchronized (atomicInteger) {
            if (this.visitorCounter.incrementAndGet() == 1) {
                this.beginVisitor();
            }
        }
        this.doAccept(backendResource, visitor, monitor);
        atomicInteger = this.visitorCounter;
        synchronized (atomicInteger) {
            if (this.visitorCounter.decrementAndGet() == 0) {
                this.endVisitor();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAccept(BackendResource backendResource, BackendResource.Visitor visitor, IProgressMonitor monitor) throws Exception {
        SynchronizedCounter counter = new SynchronizedCounter();
        ConcurrentLinkedQueue<BackendResource> queue = new ConcurrentLinkedQueue<BackendResource>();
        queue.offer(backendResource);
        while (true) {
            BackendResource polledResource;
            if ((polledResource = (BackendResource)queue.poll()) != null) {
                VisitorThread thread = this.visitorThreadPool.checkout();
                if (thread != null) {
                    thread.scheduleVisit(polledResource, queue, counter, visitor, monitor);
                    continue;
                }
                polledResource.visit(queue, visitor, monitor);
                continue;
            }
            SynchronizedCounter synchronizedCounter = counter;
            synchronized (synchronizedCounter) {
                if (counter.isZero()) {
                    break;
                }
                counter.awaitChange();
            }
        }
    }

    @Override
    protected boolean doVisit(BackendContainer backendContainer, BackendResource.Visitor visitor, IProgressMonitor monitor) throws BackendException, OperationCanceledException {
        return visitor.visit(this, monitor);
    }

    public static interface IFactory {
        public BackendSystem createBackendSystem(URI var1) throws BackendException;

        public static final class Registry {
            public static final Registry INSTANCE = new Registry();
            private final Map<String, IFactory> factories = new HashMap<String, IFactory>();

            private Registry() {
                this.addFactory("file", new LocalBackendSystem.Factory());
            }

            private IFactory loadFactory(String scheme) throws BackendException {
                if (ResourcesPlugin.INSTANCE.isOSGiRunning()) {
                    try {
                        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
                        IConfigurationElement[] iConfigurationElementArray = extensionRegistry.getConfigurationElementsFor("org.eclipse.oomph.resources.backendSystemFactories");
                        int n = iConfigurationElementArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
                            String factoryScheme = configurationElement.getAttribute("scheme");
                            if (ObjectUtil.equals((Object)factoryScheme, (Object)scheme)) {
                                try {
                                    return (IFactory)configurationElement.createExecutableExtension("class");
                                }
                                catch (Exception ex) {
                                    ResourcesPlugin.INSTANCE.log(ex);
                                }
                            }
                            ++n2;
                        }
                    }
                    catch (Exception ex) {
                        ResourcesPlugin.INSTANCE.log(ex);
                    }
                }
                throw new BackendException(NLS.bind((String)Messages.BackendSystem_SchemeNotFound_exception, (Object)scheme));
            }

            public synchronized IFactory getFactory(String scheme) throws BackendException {
                IFactory factory = this.factories.get(scheme);
                if (factory == null) {
                    factory = this.loadFactory(scheme);
                    this.factories.put(scheme, factory);
                }
                return factory;
            }

            public synchronized IFactory addFactory(String scheme, IFactory factory) throws BackendException {
                return this.factories.put(scheme, factory);
            }

            public synchronized IFactory removeFactory(String scheme) throws BackendException {
                return this.factories.remove(scheme);
            }

            public synchronized Set<String> removeFactory(IFactory factory) throws BackendException {
                HashSet<String> schemes = new HashSet<String>();
                Iterator<Map.Entry<String, IFactory>> it = this.factories.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, IFactory> entry = it.next();
                    if (entry.getValue() != factory) continue;
                    schemes.add(entry.getKey());
                    it.remove();
                }
                return schemes;
            }
        }
    }

    public static final class Registry {
        public static final Registry INSTANCE = new Registry();
        private final Map<URI, BackendSystem> backendSystems = new WeakHashMap<URI, BackendSystem>();

        private Registry() {
        }

        public synchronized BackendSystem getBackendSystem(URI systemURI) throws BackendException {
            BackendSystem backendSystem;
            if (systemURI.hasTrailingPathSeparator()) {
                systemURI = systemURI.trimSegments(1);
            }
            if ((backendSystem = this.backendSystems.get(systemURI)) == null) {
                IFactory factory = IFactory.Registry.INSTANCE.getFactory(systemURI.scheme());
                backendSystem = factory.createBackendSystem(systemURI);
                this.backendSystems.put(systemURI, backendSystem);
            }
            return backendSystem;
        }
    }

    private static final class VisitorThread
    extends Thread {
        private static int lastID;
        private final Object mutex = new Object();
        private final VisitorThreadPool pool;
        private BackendResource backendResource;
        private Queue<BackendResource> queue;
        private SynchronizedCounter counter;
        private BackendResource.Visitor visitor;
        private IProgressMonitor monitor;

        public VisitorThread(VisitorThreadPool pool) {
            super(NLS.bind((String)Messages.BackendSystem_Visitor_thread, (Object)(++lastID)));
            this.pool = pool;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scheduleVisit(BackendResource backendResource, Queue<BackendResource> queue, SynchronizedCounter counter, BackendResource.Visitor visitor, IProgressMonitor monitor) {
            counter.countUp();
            Object object = this.mutex;
            synchronized (object) {
                this.backendResource = backendResource;
                this.queue = queue;
                this.counter = counter;
                this.visitor = visitor;
                this.monitor = new ThreadProgressMonitor(monitor);
                this.mutex.notifyAll();
            }
        }

        @Override
        public void run() {
            BackendSystem backendSystem = this.pool.getBackendSystem();
            backendSystem.beginConnected();
            try {
                while (!this.isInterrupted()) {
                    try {
                        this.doVisit();
                    }
                    catch (OperationCanceledException ex) {
                        backendSystem.endConnected();
                        return;
                    }
                    catch (InterruptedException ex) {
                        backendSystem.endConnected();
                        return;
                    }
                }
            }
            finally {
                backendSystem.endConnected();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doVisit() throws InterruptedException {
            block21: {
                Object object = this.mutex;
                synchronized (object) {
                    while (this.backendResource == null) {
                        this.mutex.wait();
                    }
                }
                if (this.isInterrupted()) {
                    throw new InterruptedException();
                }
                try {
                    try {
                        this.backendResource.visit(this.queue, this.visitor, this.monitor);
                    }
                    catch (OperationCanceledException ex) {
                        throw ex;
                    }
                    catch (Exception ex) {
                        if (ex instanceof InterruptedException) {
                            throw (InterruptedException)ex;
                        }
                        ResourcesPlugin.INSTANCE.log(ex);
                        Object object2 = this.mutex;
                        synchronized (object2) {
                            this.pool.checkin(this);
                            this.counter.countDown();
                            this.backendResource = null;
                            this.queue = null;
                            this.counter = null;
                            this.visitor = null;
                            this.monitor = null;
                            break block21;
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object object3 = this.mutex;
                    synchronized (object3) {
                        this.pool.checkin(this);
                        this.counter.countDown();
                        this.backendResource = null;
                        this.queue = null;
                        this.counter = null;
                        this.visitor = null;
                        this.monitor = null;
                    }
                    throw throwable;
                }
                Object object4 = this.mutex;
                synchronized (object4) {
                    this.pool.checkin(this);
                    this.counter.countDown();
                    this.backendResource = null;
                    this.queue = null;
                    this.counter = null;
                    this.visitor = null;
                    this.monitor = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void interrupt() {
            if (this.monitor != null) {
                this.monitor.setCanceled(true);
            }
            Object object = this.mutex;
            synchronized (object) {
                this.mutex.notifyAll();
            }
            super.interrupt();
        }

        @Override
        public String toString() {
            return super.toString();
        }

        private static final class ThreadProgressMonitor
        extends ProgressMonitorWrapper {
            private boolean canceled;

            protected ThreadProgressMonitor(IProgressMonitor monitor) {
                super((IProgressMonitor)(monitor != null ? monitor : new NullProgressMonitor()));
            }

            public boolean isCanceled() {
                return this.canceled || super.isCanceled();
            }

            public void setCanceled(boolean value) {
                this.canceled = value;
            }

            public void beginTask(String name, int totalWork) {
                this.setTaskName(name);
            }

            public void clearBlocked() {
            }

            public void setBlocked(IStatus reason) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void setTaskName(String name) {
                IProgressMonitor iProgressMonitor = this.getWrappedProgressMonitor();
                synchronized (iProgressMonitor) {
                    super.setTaskName(name);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void subTask(String name) {
                IProgressMonitor iProgressMonitor = this.getWrappedProgressMonitor();
                synchronized (iProgressMonitor) {
                    super.subTask(name);
                }
            }

            public void internalWorked(double work) {
            }

            public void worked(int work) {
            }

            public void done() {
            }
        }
    }

    private static final class VisitorThreadPool {
        private static final String PROP_MAX_THREADS = "oomph.resources.VisitorThreadPool.MAX_THREADS";
        private static final int DEFAULT_MAX_THREADS = 10;
        private static final int MAX_THREADS = PropertiesUtil.getProperty((String)"oomph.resources.VisitorThreadPool.MAX_THREADS", (int)10);
        private static final String PROP_SKIP_THRESHOLD = "oomph.resources.VisitorThreadPool.SKIP_THRESHOLD";
        private static final int DEFAULT_SKIP_THRESHOLD = MAX_THREADS / 2;
        private static final int SKIP_THRESHOLD = PropertiesUtil.getProperty((String)"oomph.resources.VisitorThreadPool.SKIP_THRESHOLD", (int)DEFAULT_SKIP_THRESHOLD);
        private final LinkedList<VisitorThread> threads = new LinkedList();
        private final Set<VisitorThread> checkouts = new HashSet<VisitorThread>();
        private final BackendSystem backendSystem;
        private final int maxThreads;
        private int skippedThreadCreations;
        private boolean disposed;

        public VisitorThreadPool(BackendSystem backendSystem) {
            this.backendSystem = backendSystem;
            this.maxThreads = Math.min(MAX_THREADS, backendSystem.getMaxThreads());
        }

        public BackendSystem getBackendSystem() {
            return this.backendSystem;
        }

        public synchronized VisitorThread checkout() {
            if (!this.disposed && this.maxThreads > 0) {
                int threadCreationsToSkip;
                if (!this.threads.isEmpty()) {
                    VisitorThread thread = this.threads.removeFirst();
                    this.checkouts.add(thread);
                    return thread;
                }
                int currentNumberOfThreads = this.checkouts.size();
                if (currentNumberOfThreads < this.maxThreads && ++this.skippedThreadCreations >= (threadCreationsToSkip = currentNumberOfThreads / SKIP_THRESHOLD)) {
                    this.skippedThreadCreations = 0;
                    VisitorThread thread = new VisitorThread(this);
                    thread.start();
                    this.checkouts.add(thread);
                    return thread;
                }
            }
            return null;
        }

        public synchronized void checkin(VisitorThread thread) {
            if (!this.disposed) {
                this.checkouts.remove(thread);
                this.threads.addLast(thread);
            }
        }

        public synchronized void dispose() {
            for (VisitorThread thread : this.threads) {
                thread.interrupt();
            }
            for (VisitorThread thread : this.checkouts) {
                thread.interrupt();
            }
            this.threads.clear();
            this.checkouts.clear();
            this.disposed = true;
        }
    }
}

