/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.sync;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SyncDeltaType implements Enumerator
{
    UNCHANGED(0, "Unchanged", "Unchanged"),
    CHANGED(1, "Changed", "Changed"),
    REMOVED(2, "Removed", "Removed");

    public static final int UNCHANGED_VALUE = 0;
    public static final int CHANGED_VALUE = 1;
    public static final int REMOVED_VALUE = 2;
    private static final SyncDeltaType[] VALUES_ARRAY;
    public static final List<SyncDeltaType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new SyncDeltaType[]{UNCHANGED, CHANGED, REMOVED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static SyncDeltaType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SyncDeltaType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SyncDeltaType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SyncDeltaType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SyncDeltaType get(int value) {
        switch (value) {
            case 0: {
                return UNCHANGED;
            }
            case 1: {
                return CHANGED;
            }
            case 2: {
                return REMOVED;
            }
        }
        return null;
    }

    private SyncDeltaType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

