/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.installer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.oomph.setup.CatalogSelection;
import org.eclipse.oomph.setup.Scope;
import org.eclipse.oomph.setup.SetupPackage;
import org.eclipse.oomph.setup.internal.core.util.CatalogManager;
import org.eclipse.oomph.setup.internal.core.util.IndexManager;
import org.eclipse.oomph.setup.internal.core.util.SetupCoreUtil;
import org.eclipse.oomph.setup.internal.installer.Installer;
import org.eclipse.oomph.setup.internal.installer.Messages;
import org.eclipse.oomph.setup.internal.installer.SetupInstallerPlugin;
import org.eclipse.oomph.setup.ui.AbstractSetupDialog;
import org.eclipse.oomph.setup.ui.IndexManagerDialog;
import org.eclipse.oomph.ui.OomphUIPlugin;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductCatalogsDialog
extends AbstractSetupDialog {
    public static final String TITLE = Messages.ProductCatalogsDialog_title;
    public static final String DESCRIPTION = Messages.ProductCatalogsDialog_description;
    private static final int APPLY_ID = 1025;
    private final CatalogManager catalogManager;
    private CheckboxTableViewer catalogViewer;
    private final IndexManager indexManager;
    private Installer installer;
    private Button applyButton;
    private URI originalIndex;
    private URI indexSelection;
    private List<Scope> originalSelectedCatalogs;
    private Map<URI, String> indexChoices;

    public ProductCatalogsDialog(Shell parentShell, Installer installer, CatalogManager catalogManager) {
        super(parentShell, TITLE, 700, 300, (OomphUIPlugin)SetupInstallerPlugin.INSTANCE, false);
        this.installer = installer;
        this.catalogManager = catalogManager;
        this.indexManager = new IndexManager();
        Resource resource = catalogManager.getIndex().eResource();
        this.originalIndex = resource.getResourceSet().getURIConverter().normalize(resource.getURI());
        this.indexChoices = this.indexManager.getIndexLabels(true);
    }

    protected String getShellText() {
        return TITLE;
    }

    protected String getDefaultMessage() {
        return String.valueOf(DESCRIPTION) + ".";
    }

    protected void createUI(Composite parent) {
        this.catalogViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)0);
        this.catalogViewer.getTable().setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.catalogViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (!(inputElement instanceof CatalogManager)) {
                    throw new IllegalArgumentException(Messages.ProductCatalogsDialog_BadInput_exception);
                }
                ArrayList<Scope> scopes = new ArrayList<Scope>();
                for (Scope scope : ProductCatalogsDialog.this.catalogManager.getCatalogs(true)) {
                    if (scope.eIsProxy() || "redirectable".equals(scope.getName())) continue;
                    scopes.add(scope);
                }
                return scopes.toArray();
            }
        });
        this.catalogViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return element instanceof Scope && !"self".equals(((Scope)element).getName());
            }
        });
        this.catalogViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return SetupCoreUtil.getLabel((Scope)((Scope)element));
            }
        });
        this.catalogViewer.setInput((Object)this.catalogManager);
        this.originalSelectedCatalogs = new ArrayList<Scope>(this.catalogManager.getSelectedCatalogs(true));
        this.catalogViewer.setCheckedElements(this.originalSelectedCatalogs.toArray());
        this.catalogViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ProductCatalogsDialog.this.updateEnablement();
            }
        });
        final AdapterImpl selectionAdapter = new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                if (notification.getFeature() == SetupPackage.Literals.CATALOG_SELECTION__PRODUCT_CATALOGS) {
                    ProductCatalogsDialog.this.catalogViewer.refresh();
                    ProductCatalogsDialog.this.originalSelectedCatalogs = new ArrayList(ProductCatalogsDialog.this.catalogManager.getSelectedCatalogs(true));
                    ProductCatalogsDialog.this.catalogViewer.setCheckedElements(ProductCatalogsDialog.this.originalSelectedCatalogs.toArray());
                    ProductCatalogsDialog.this.updateEnablement();
                }
            }
        };
        final CatalogSelection selection = this.catalogManager.getSelection();
        selection.eAdapters().add((Object)selectionAdapter);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                selection.eAdapters().remove((Object)selectionAdapter);
            }
        });
    }

    protected Control createButtonBar(Composite parent) {
        int size = this.indexChoices.size();
        if (size > 1 || !this.indexChoices.containsKey(this.originalIndex)) {
            return this.createButtonBarWithControls(parent);
        }
        return super.createButtonBar(parent);
    }

    protected void createControlsForButtonBar(Composite parent) {
        this.createLabel(parent, Messages.ProductCatalogsDialog_CatalogIndex_label);
        boolean indexUnmanaged = !this.indexChoices.containsKey(this.originalIndex);
        this.setMessage(String.valueOf(DESCRIPTION) + Messages.ProductCatalogsDialog_SwitchIndex_suffix_message);
        final Combo indexCombo = this.createCombo(parent);
        final ArrayList<String> values = new ArrayList<String>(this.indexChoices.values());
        this.addManagementValues(values);
        String[] items = values.toArray(new String[values.size()]);
        indexCombo.setItems(items);
        indexCombo.select(0);
        final ArrayList<URI> uris = new ArrayList<URI>(this.indexChoices.keySet());
        if (indexUnmanaged && uris.size() > 0) {
            this.indexSelection = (URI)uris.get(0);
        }
        indexCombo.setToolTipText(IndexManager.getUnderlyingLocation((URI)(this.indexSelection == null ? this.originalIndex : this.indexSelection)).toString());
        indexCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = indexCombo.getSelectionIndex();
                if (selectionIndex >= uris.size()) {
                    URI currentSelection = ProductCatalogsDialog.this.indexSelection == null ? (uris.isEmpty() ? null : (URI)uris.get(0)) : ProductCatalogsDialog.this.indexSelection;
                    indexCombo.select(ProductCatalogsDialog.this.indexSelection == null || currentSelection == null ? 0 : uris.indexOf(ProductCatalogsDialog.this.indexSelection));
                    IndexManagerDialog indexManagerDialog = new IndexManagerDialog(ProductCatalogsDialog.this.getShell());
                    indexManagerDialog.open();
                    Map newIndexChoices = ProductCatalogsDialog.this.indexManager.getIndexLabels(true);
                    values.clear();
                    values.addAll(newIndexChoices.values());
                    ProductCatalogsDialog.this.addManagementValues(values);
                    uris.clear();
                    uris.addAll(newIndexChoices.keySet());
                    String[] items = values.toArray(new String[newIndexChoices.size()]);
                    indexCombo.setItems(items);
                    int index = uris.indexOf(currentSelection);
                    if (index != -1) {
                        indexCombo.select(index);
                        ProductCatalogsDialog.this.indexSelection = currentSelection.equals(ProductCatalogsDialog.this.originalIndex) ? null : currentSelection;
                        ProductCatalogsDialog.this.updateEnablement();
                    } else {
                        if (uris.size() == 0) {
                            ProductCatalogsDialog.this.close();
                            return;
                        }
                        indexCombo.select(0);
                        currentSelection = (URI)uris.get(0);
                        ProductCatalogsDialog.this.indexSelection = currentSelection.equals(ProductCatalogsDialog.this.originalIndex) ? null : currentSelection;
                        ProductCatalogsDialog.this.updateEnablement();
                    }
                } else {
                    URI indexLocationURI = (URI)uris.get(selectionIndex);
                    ProductCatalogsDialog.this.indexSelection = indexLocationURI.equals(ProductCatalogsDialog.this.originalIndex) ? null : indexLocationURI;
                    ProductCatalogsDialog.this.updateEnablement();
                }
                indexCombo.setToolTipText(IndexManager.getUnderlyingLocation((URI)(ProductCatalogsDialog.this.indexSelection == null ? ProductCatalogsDialog.this.originalIndex : ProductCatalogsDialog.this.indexSelection)).toString());
            }
        });
    }

    private void addManagementValues(Collection<String> values) {
        values.add("\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014");
        values.add(Messages.ProductCatalogsDialog_ManageIndices_label);
    }

    protected void updateEnablement() {
        List<Object> checkedElements = Arrays.asList(this.catalogViewer.getCheckedElements());
        boolean catalogSelectionChanged = !checkedElements.equals(this.originalSelectedCatalogs);
        boolean applyEnabled = catalogSelectionChanged || this.indexSelection != null;
        this.applyButton.setEnabled(applyEnabled);
        this.applyButton.setText(Messages.ProductCatalogsDialog_Apply_label);
        if (this.originalIndex == null) {
            if (catalogSelectionChanged) {
                this.setMessage(String.valueOf(DESCRIPTION) + Messages.ProductCatalogsDialog_ApplySelection_suffix_message);
            } else {
                this.setMessage(String.valueOf(DESCRIPTION) + ".");
            }
        } else if (this.indexSelection != null) {
            this.setMessage(Messages.ProductCatalogsDialog_ApplyNewIndex_message, 2);
            this.catalogViewer.getControl().setEnabled(false);
        } else {
            this.catalogViewer.getControl().setEnabled(true);
            if (catalogSelectionChanged) {
                this.setMessage(String.valueOf(DESCRIPTION) + Messages.ProductCatalogsDialog_ApplySelection_suffix_message);
            } else if (this.indexChoices.size() > 1 || !this.indexChoices.containsKey(this.originalIndex)) {
                this.setMessage(String.valueOf(DESCRIPTION) + Messages.ProductCatalogsDialog_SwitchCatalogIndex_suffix_message);
            } else {
                this.setMessage(String.valueOf(DESCRIPTION) + ".");
            }
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.applyButton = this.createButton(parent, 1025, Messages.ProductCatalogsDialog_Apply_label, false);
        this.applyButton.setEnabled(false);
        super.createButtonsForButtonBar(parent);
        this.updateEnablement();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1025 || buttonId == 0) {
            if (this.indexSelection != null) {
                this.installer.reloadIndex(this.indexSelection);
                this.originalIndex = this.indexSelection;
                this.indexSelection = null;
                this.applyButton.setEnabled(false);
                Runnable buttonAnimator = new Runnable(){
                    private String[] label = new String[]{Messages.ProductCatalogsDialog_Apply1_label, Messages.ProductCatalogsDialog_Apply2_label, Messages.ProductCatalogsDialog_Apply3_label};
                    private int counter;

                    public void run() {
                        if (this.counter == 0 || !ProductCatalogsDialog.this.applyButton.isDisposed() && !Messages.ProductCatalogsDialog_Apply_label.equals(ProductCatalogsDialog.this.applyButton.getText())) {
                            ProductCatalogsDialog.this.applyButton.setText(this.label[this.counter++ % 3]);
                            UIUtil.timerExec((int)500, (Runnable)this);
                        }
                    }
                };
                buttonAnimator.run();
            } else {
                List<Object> checkedElements = Arrays.asList(this.catalogViewer.getCheckedElements());
                for (Scope scope : this.catalogManager.getCatalogs(true)) {
                    this.catalogManager.selectCatalog(true, scope, checkedElements.contains(scope));
                }
            }
        }
        super.buttonPressed(buttonId);
    }
}

