/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.tests.data;

import java.io.File;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.p2.metadata.OSGiVersion;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.query.CompoundQueryable;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.ICompositeRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.oomph.base.util.BaseResourceFactoryImpl;
import org.eclipse.oomph.p2.P2Factory;
import org.eclipse.oomph.p2.Repository;
import org.eclipse.oomph.p2.Requirement;
import org.eclipse.oomph.p2.VersionSegment;
import org.eclipse.oomph.p2.core.P2Util;
import org.eclipse.oomph.p2.internal.core.AgentImpl;
import org.eclipse.oomph.setup.InstallationTask;
import org.eclipse.oomph.setup.Product;
import org.eclipse.oomph.setup.ProductCatalog;
import org.eclipse.oomph.setup.ProductVersion;
import org.eclipse.oomph.setup.SetupFactory;
import org.eclipse.oomph.setup.p2.P2Task;
import org.eclipse.oomph.setup.p2.SetupP2Factory;
import org.eclipse.oomph.util.CollectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductCatalogGenerator
implements IApplication {
    private static final String PACKAGES = "http://download.eclipse.org/technology/epp/packages";
    private static final String RELEASES = "http://download.eclipse.org/releases";

    public Object start(IApplicationContext context) throws Exception {
        String[] arguments = (String[])context.getArguments().get("application.args");
        URI uri = null;
        if (arguments != null && arguments.length == 2 && "-generatorOutput".equals(arguments[0])) {
            uri = URI.createURI((String)arguments[1]);
        }
        this.generate(uri);
        return null;
    }

    public void stop() {
    }

    private String[] getTrains() {
        return new String[]{"juno", "kepler", "luna", "mars"};
    }

    private String[] getRootIUs() {
        return new String[]{"org.eclipse.platform.feature.group", "org.eclipse.rcp.feature.group", "org.eclipse.jdt.feature.group", "org.eclipse.pde.feature.group"};
    }

    private boolean isLatestReleased() {
        return false;
    }

    private boolean testNewUnreleasedProduct() {
        return false;
    }

    public void generate(URI uri) {
        final String[] TRAINS = this.getTrains();
        String LATEST_TRAIN = TRAINS[TRAINS.length - 1];
        boolean LATEST_RELEASED = !this.testNewUnreleasedProduct() && this.isLatestReleased();
        try {
            ProductCatalog productCatalog = SetupFactory.eINSTANCE.createProductCatalog();
            productCatalog.setName("org.eclipse.products");
            productCatalog.setLabel("Eclipse.org");
            InstallationTask installationTask = SetupFactory.eINSTANCE.createInstallationTask();
            installationTask.setID("installation");
            productCatalog.getSetupTasks().add((Object)installationTask);
            File agentLocation = File.createTempFile("test-", "-agent");
            agentLocation.delete();
            agentLocation.mkdirs();
            AgentImpl agent = new AgentImpl(null, agentLocation);
            IMetadataRepositoryManager manager = agent.getMetadataRepositoryManager();
            Requirement oomphRequirement = P2Factory.eINSTANCE.createRequirement("org.eclipse.oomph.setup.feature.group");
            Repository oomphRepository = P2Factory.eINSTANCE.createRepository("${oomph.update.url}");
            Repository emfRepository = P2Factory.eINSTANCE.createRepository(this.trimEmptyTrailingSegment(this.loadLatestRepository(manager, null, new java.net.URI("http://download.eclipse.org/modeling/emf/emf/updates/2.10.x/core")).getLocation()).toString());
            P2Task p2Task = SetupP2Factory.eINSTANCE.createP2Task();
            p2Task.getRequirements().add((Object)oomphRequirement);
            p2Task.getRepositories().add((Object)oomphRepository);
            p2Task.getRepositories().add((Object)emfRepository);
            productCatalog.getSetupTasks().add((Object)p2Task);
            final HashMap trainsAndVersions = new HashMap();
            final HashMap<Object, String> labels = new HashMap<Object, String>();
            String[] stringArray = TRAINS;
            int n = TRAINS.length;
            int n2 = 0;
            while (n2 < n) {
                Object id;
                String train = stringArray[n2];
                java.net.URI eppURI = new java.net.URI("http://download.eclipse.org/technology/epp/packages/" + train);
                System.out.println(eppURI);
                IMetadataRepository eppMetaDataRepository = manager.loadRepository(eppURI, null);
                HashMap<Object, IInstallableUnit> ius = new HashMap<Object, IInstallableUnit>();
                java.net.URI releaseURI = new java.net.URI("http://download.eclipse.org/releases/" + train);
                System.out.print(releaseURI);
                IMetadataRepository releaseMetaDataRepository = this.loadLatestRepository(manager, eppURI, releaseURI);
                releaseURI = this.trimEmptyTrailingSegment(releaseMetaDataRepository.getLocation());
                System.out.println(" -> " + releaseURI);
                for (IInstallableUnit iu : P2Util.asIterable((IQueryResult)eppMetaDataRepository.query(QueryUtil.createIUAnyQuery(), null))) {
                    IInstallableUnit existingIU;
                    String label;
                    String fragment = iu.getProperty("org.eclipse.equinox.p2.type.fragment");
                    if ("true".equals(fragment) || (label = iu.getProperty("org.eclipse.equinox.p2.name")) == null || label.startsWith("%") || label.equals("Uncategorized") || (existingIU = (IInstallableUnit)ius.get(id = iu.getId())) != null && existingIU.getVersion().compareTo((Object)iu.getVersion()) >= 0) continue;
                    ius.put(id, iu);
                    labels.put(id, label);
                }
                HashSet<String> requirements = new HashSet<String>();
                for (IInstallableUnit iInstallableUnit : ius.values()) {
                    id = iInstallableUnit.getRequirements().iterator();
                    while (id.hasNext()) {
                        IRequiredCapability capability;
                        IRequirement requirement = (IRequirement)id.next();
                        if (!(requirement instanceof IRequiredCapability) || !"org.eclipse.equinox.p2.iu".equals((capability = (IRequiredCapability)requirement).getNamespace())) continue;
                        requirements.add(capability.getName());
                    }
                }
                for (String string : requirements) {
                    ius.remove(string);
                }
                for (Map.Entry entry : ius.entrySet()) {
                    String id2 = (String)entry.getKey();
                    String label = (String)labels.get(id2);
                    IInstallableUnit iu = (IInstallableUnit)entry.getValue();
                    Version version = iu.getVersion();
                    System.out.println("  " + label + "  --  " + id2 + " " + version);
                    ArrayList<TrainAndVersion> list = (ArrayList<TrainAndVersion>)trainsAndVersions.get(id2);
                    if (list == null) {
                        list = new ArrayList<TrainAndVersion>();
                        trainsAndVersions.put(id2, list);
                    }
                    HashMap<String, Set<IInstallableUnit>> versionIUs = new HashMap<String, Set<IInstallableUnit>>();
                    this.gatherReleaseIUs(versionIUs, iu, releaseMetaDataRepository, eppMetaDataRepository);
                    this.filterRoots(versionIUs);
                    list.add(new TrainAndVersion(train, version, releaseURI, versionIUs));
                }
                System.out.println();
                ++n2;
            }
            if (this.testNewUnreleasedProduct()) {
                ArrayList<TrainAndVersion> list = new ArrayList<TrainAndVersion>();
                list.add(new TrainAndVersion("mars", null, null, null));
                trainsAndVersions.put("test.product", list);
                labels.put("test.product", "Eclipse Test Product");
            }
            System.out.println("#################################################################################################################");
            System.out.println();
            ArrayList ids = new ArrayList(trainsAndVersions.keySet());
            Collections.sort(ids, new Comparator<String>(){

                @Override
                public int compare(String id1, String id2) {
                    int result = this.getLatestTrain(id2) - this.getLatestTrain(id1);
                    if (result == 0) {
                        String label1 = (String)labels.get(id1);
                        String label2 = (String)labels.get(id2);
                        result = label1.compareTo(label2);
                    }
                    return result;
                }

                private int getLatestTrain(String id) {
                    List list = (List)trainsAndVersions.get(id);
                    TrainAndVersion lastEntry = (TrainAndVersion)list.get(list.size() - 1);
                    String lastTrain = lastEntry.getTrain();
                    int i = 0;
                    while (i < TRAINS.length) {
                        String train = TRAINS[i];
                        if (train == lastTrain) {
                            return i;
                        }
                        ++i;
                    }
                    throw new IllegalStateException();
                }
            });
            for (String id : ids) {
                boolean latestUnreleased;
                String label = (String)labels.get(id);
                List list = (List)trainsAndVersions.get(id);
                int size = list.size();
                TrainAndVersion latestTrainAndVersion = (TrainAndVersion)list.get(size - 1);
                String latestTrain = latestTrainAndVersion.getTrain();
                String latestTrainLabel = this.getTrainLabel(latestTrain);
                Version latestVersion = latestTrainAndVersion.getVersion();
                Map<String, Set<IInstallableUnit>> map = latestTrainAndVersion.getIUs();
                if (latestTrain != LATEST_TRAIN) {
                    label = String.valueOf(label) + " (discontinued after " + latestTrainLabel + ")";
                }
                boolean bl = latestUnreleased = latestTrain == LATEST_TRAIN && !LATEST_RELEASED;
                if (latestUnreleased && size == 1) {
                    label = String.valueOf(label) + " (unreleased before " + latestTrainLabel + ")";
                }
                System.out.println(label);
                Product product = SetupFactory.eINSTANCE.createProduct();
                product.setName(id);
                product.setLabel(label);
                productCatalog.getProducts().add((Object)product);
                this.addProductVersion(product, latestVersion, VersionSegment.MAJOR, latestTrainAndVersion.getTrainURI(), latestTrain, "latest", "Latest (" + latestTrainLabel + ")", map);
                if (!latestUnreleased || size != 1) {
                    int offset = 1;
                    if (latestUnreleased && size > 1) {
                        ++offset;
                    }
                    TrainAndVersion releasedTrainAndVersion = (TrainAndVersion)list.get(size - offset);
                    String releasedTrain = releasedTrainAndVersion.getTrain();
                    String releasedTrainLabel = this.getTrainLabel(releasedTrain);
                    Version releasedVersion = releasedTrainAndVersion.getVersion();
                    this.addProductVersion(product, releasedVersion, VersionSegment.MINOR, releasedTrainAndVersion.getTrainURI(), releasedTrain, "latest.released", "Latest Release (" + releasedTrainLabel + ")", releasedTrainAndVersion.getIUs());
                }
                int i = 0;
                while (i < size) {
                    TrainAndVersion entry = (TrainAndVersion)list.get(size - i - 1);
                    String train = entry.getTrain();
                    String trainLabel = this.getTrainLabel(train);
                    Version version = entry.getVersion();
                    this.addProductVersion(product, version, VersionSegment.MINOR, entry.getTrainURI(), train, train, trainLabel, entry.getIUs());
                    ++i;
                }
                System.out.println();
            }
            System.out.println("#################################################################################################################");
            System.out.println();
            this.checkVersionRanges(productCatalog);
            this.postProcess(productCatalog);
            Resource resource = new BaseResourceFactoryImpl().createResource(uri == null ? URI.createURI((String)"org.eclipse.products.setup") : uri);
            resource.getContents().add((Object)productCatalog);
            resource.save((OutputStream)System.out, null);
            if (uri != null) {
                resource.save(null);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private java.net.URI trimEmptyTrailingSegment(java.net.URI uri) throws URISyntaxException {
        String value = uri.toString();
        if (value.endsWith("/")) {
            return new java.net.URI(value.substring(0, value.length() - 1));
        }
        return uri;
    }

    private IMetadataRepository loadLatestRepository(IMetadataRepositoryManager manager, java.net.URI eppURI, java.net.URI releaseURI) throws URISyntaxException, ProvisionException {
        IMetadataRepository releaseMetaDataRepository;
        IMetadataRepository result = releaseMetaDataRepository = manager.loadRepository(releaseURI, null);
        if (releaseMetaDataRepository instanceof ICompositeRepository) {
            ICompositeRepository compositeRepository = (ICompositeRepository)releaseMetaDataRepository;
            long latest = Integer.MIN_VALUE;
            for (java.net.URI childURI : compositeRepository.getChildren()) {
                IMetadataRepository childRepository;
                String value;
                long timestamp;
                if ((childURI = this.trimEmptyTrailingSegment(childURI)).equals(eppURI) || (timestamp = Long.parseLong(value = (String)(childRepository = manager.loadRepository(childURI, null)).getProperties().get("p2.timestamp"))) <= latest) continue;
                result = childRepository;
                latest = timestamp;
            }
        }
        return result;
    }

    private void checkVersionRanges(ProductCatalog productCatalog) {
        if (!this.isLatestReleased()) {
            for (Product product : productCatalog.getProducts()) {
                EList versions = product.getVersions();
                if (versions.size() <= 3) continue;
                ProductVersion latestReleaseVersion = (ProductVersion)versions.get(1);
                ProductVersion latestDevelopmentVersion = (ProductVersion)versions.get(2);
                P2Task latestReleaseP2Task = (P2Task)latestReleaseVersion.getSetupTasks().get(0);
                P2Task latestDevelopmentP2Task = (P2Task)latestDevelopmentVersion.getSetupTasks().get(0);
                block1: for (Requirement developmentRequirement : latestDevelopmentP2Task.getRequirements()) {
                    String name = developmentRequirement.getName();
                    for (Requirement releaseRequirement : latestReleaseP2Task.getRequirements()) {
                        VersionRange releaseVersionRange;
                        if (!name.equals(releaseRequirement.getName())) continue;
                        VersionRange developmentVersionRange = developmentRequirement.getVersionRange();
                        if (!developmentVersionRange.equals((Object)(releaseVersionRange = releaseRequirement.getVersionRange()))) continue block1;
                        OSGiVersion minimum = (OSGiVersion)developmentVersionRange.getMinimum();
                        OSGiVersion maximum = (OSGiVersion)developmentVersionRange.getMaximum();
                        int major = minimum.getMajor();
                        if (major != maximum.getMajor()) continue block1;
                        developmentRequirement.setVersionRange(new VersionRange((Version)minimum, true, Version.createOSGi((int)major, (int)(maximum.getMinor() + 1), (int)0), false));
                        continue block1;
                    }
                }
            }
        }
    }

    private void postProcess(ProductCatalog productCatalog) {
        for (Product product : productCatalog.getProducts()) {
            if (!"epp.package.standard".equals(product.getName())) continue;
            for (ProductVersion version : product.getVersions()) {
                if (!version.getLabel().contains("Mars")) continue;
                P2Task task = (P2Task)version.getSetupTasks().get(0);
                Requirement requirement = (Requirement)task.getRequirements().get(0);
                requirement.setName("epp.package.committers");
            }
            return;
        }
    }

    private void gatherReleaseIUs(Map<String, Set<IInstallableUnit>> releaseIUs, IInstallableUnit iu, IMetadataRepository releaseMetaDataRepository, IMetadataRepository eppMetaDataRepository) {
        for (IRequirement requirement : iu.getRequirements()) {
            IRequiredCapability capability;
            String capabilityName;
            if (!(requirement instanceof IRequiredCapability) || !(capabilityName = (capability = (IRequiredCapability)requirement).getName()).endsWith(".feature.group")) continue;
            CompoundQueryable queriable = new CompoundQueryable(new IQueryable[]{releaseMetaDataRepository, eppMetaDataRepository});
            IQuery query = QueryUtil.createIUQuery((String)capabilityName, (VersionRange)capability.getRange());
            for (IInstallableUnit requiredIU : P2Util.asIterable((IQueryResult)queriable.query(query, null))) {
                if (!CollectionUtil.add(releaseIUs, (Object)capabilityName, (Object)requiredIU)) continue;
                this.gatherReleaseIUs(releaseIUs, requiredIU, releaseMetaDataRepository, eppMetaDataRepository);
            }
        }
    }

    private void filterRoots(Map<String, Set<IInstallableUnit>> releaseIUs) {
        Iterator<Map.Entry<String, Set<IInstallableUnit>>> it = releaseIUs.entrySet().iterator();
        while (it.hasNext()) {
            String id = it.next().getKey();
            if (id.endsWith("feature.group") && !id.startsWith("org.eclipse.epp") && !id.endsWith("epp.feature.group")) continue;
            it.remove();
        }
    }

    private void addProductVersion(Product product, Version version, VersionSegment versionSegment, java.net.URI trainURI, String train, String name, String label, Map<String, Set<IInstallableUnit>> ius) {
        System.out.println("  " + label);
        ProductVersion productVersion = SetupFactory.eINSTANCE.createProductVersion();
        productVersion.setName(name);
        productVersion.setLabel(label);
        product.getVersions().add((Object)productVersion);
        VersionRange versionRange = this.createVersionRange(version, versionSegment);
        Requirement requirement = P2Factory.eINSTANCE.createRequirement();
        requirement.setName(product.getName());
        requirement.setVersionRange(versionRange);
        Repository packageRepository = P2Factory.eINSTANCE.createRepository();
        packageRepository.setURL("http://download.eclipse.org/technology/epp/packages/" + train);
        Repository releaseRepository = P2Factory.eINSTANCE.createRepository();
        releaseRepository.setURL(trainURI.toString());
        P2Task p2Task = SetupP2Factory.eINSTANCE.createP2Task();
        p2Task.getRequirements().add((Object)requirement);
        this.addRootIURequirements((EList<Requirement>)p2Task.getRequirements(), versionSegment, ius);
        p2Task.getRepositories().add((Object)packageRepository);
        p2Task.getRepositories().add((Object)releaseRepository);
        productVersion.getSetupTasks().add((Object)p2Task);
    }

    private VersionRange createVersionRange(Version version, VersionSegment versionSegment) {
        VersionRange versionRange = P2Factory.eINSTANCE.createVersionRange(version, versionSegment);
        if (versionSegment == VersionSegment.MAJOR) {
            VersionRange minorVersionRange = P2Factory.eINSTANCE.createVersionRange(version, VersionSegment.MINOR);
            versionRange = new VersionRange(minorVersionRange.getMinimum(), true, versionRange.getMaximum(), false);
        }
        return versionRange;
    }

    private void addRootIURequirements(EList<Requirement> requirements, VersionSegment versionSegment, Map<String, Set<IInstallableUnit>> ius) {
        String[] stringArray = this.getRootIUs();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String iu = stringArray[n2];
            Set<IInstallableUnit> rootIUs = ius.get(iu);
            if (rootIUs != null) {
                VersionRange range = null;
                for (IInstallableUnit rootIU : rootIUs) {
                    Version version = rootIU.getVersion();
                    VersionRange versionRange = this.createVersionRange(version, versionSegment);
                    if (range != null) continue;
                    range = versionRange;
                }
                if (range != null) {
                    Requirement requirement = P2Factory.eINSTANCE.createRequirement();
                    requirement.setName(iu);
                    requirement.setVersionRange(range);
                    requirements.add((Object)requirement);
                }
            }
            ++n2;
        }
    }

    private String getTrainLabel(String train) {
        return String.valueOf(Character.toString((char)(train.charAt(0) + 65 - 97))) + train.substring(1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TrainAndVersion {
        private final String train;
        private final Version version;
        private final Map<String, Set<IInstallableUnit>> ius;
        private final java.net.URI trainURI;

        public TrainAndVersion(String train, Version version, java.net.URI trainURI, Map<String, Set<IInstallableUnit>> ius) {
            this.train = train;
            this.version = version;
            this.trainURI = trainURI;
            this.ius = ius;
        }

        public String getTrain() {
            return this.train;
        }

        public Version getVersion() {
            return this.version;
        }

        public java.net.URI getTrainURI() {
            return this.trainURI;
        }

        public Map<String, Set<IInstallableUnit>> getIUs() {
            return this.ius;
        }
    }
}

