/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.tests;

import java.io.File;
import java.net.URI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.oomph.p2.core.Agent;
import org.eclipse.oomph.p2.core.AgentManager;
import org.eclipse.oomph.p2.core.P2Util;
import org.eclipse.oomph.p2.core.ProfileTransaction;
import org.eclipse.oomph.p2.internal.core.AgentManagerImpl;
import org.eclipse.oomph.tests.AbstractTest;
import org.eclipse.oomph.util.PropertiesUtil;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.BeforeClass;

public abstract class AbstractP2Test
extends AbstractTest {
    private static final String TMP = PropertiesUtil.getProperty((String)"java.io.tmpdir");
    private static final String CDO = "p2-test-mirror-001-cdo";
    private static final String PLATFORM = "p2-test-mirror-001-platform";
    private static final P2Util.VersionedIdFilter CDO_FILTER = new P2Util.VersionedIdFilter(){

        public boolean matches(IVersionedId versionedId) {
            String id = versionedId.getId();
            return id.startsWith("org.eclipse.net4j.util") || id.startsWith("org.apache");
        }
    };
    private static final P2Util.VersionedIdFilter PLATFORM_FILTER = new P2Util.VersionedIdFilter(){

        public boolean matches(IVersionedId versionedId) {
            String id = versionedId.getId();
            return id.startsWith("com.jcraft.jsch") || id.startsWith("org.apache") || id.startsWith("a.jre");
        }
    };
    public static final File CDO_OLD = new File(TMP, "p2-test-mirror-001-cdo-old");
    public static final File CDO_NEW = new File(TMP, "p2-test-mirror-001-cdo-new");
    public static final File PLATFORM_OLD = new File(TMP, "p2-test-mirror-001-platform-old");
    public static final File PLATFORM_NEW = new File(TMP, "p2-test-mirror-001-platform-new");

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        AbstractP2Test.mirror("http://download.eclipse.org/modeling/emf/cdo/drops/R20130918-0029", CDO_OLD, CDO_FILTER);
        AbstractP2Test.mirror("http://download.eclipse.org/modeling/emf/cdo/drops/R20140218-1655", CDO_NEW, CDO_FILTER);
        AbstractP2Test.mirror("http://download.eclipse.org/eclipse/updates/4.3/R-4.3.1-201309111000", PLATFORM_OLD, PLATFORM_FILTER);
        AbstractP2Test.mirror("http://download.eclipse.org/eclipse/updates/4.3/R-4.3.2-201402211700", PLATFORM_NEW, PLATFORM_FILTER);
    }

    private static void mirror(String repo, File local, P2Util.VersionedIdFilter filter) throws Exception {
        if (!local.isDirectory()) {
            LOGGER.setTaskName("Creating test mirror of " + repo + " under " + local);
            P2Util.mirrorRepository((URI)new URI(repo), (URI)local.toURI(), (P2Util.VersionedIdFilter)filter, (IProgressMonitor)LOGGER);
            LOGGER.setTaskName(null);
        }
    }

    public void setUp() throws Exception {
        super.setUp();
        AgentManagerImpl.instance = new AgentManagerImpl(this.getUserHome());
    }

    public void tearDown() throws Exception {
        AgentManagerImpl.instance = null;
        super.tearDown();
    }

    protected Agent getAgent() {
        AgentManager agentManager = P2Util.getAgentManager();
        return (Agent)agentManager.getAgents().iterator().next();
    }

    protected Agent getFreshAgent() {
        AgentManagerImpl.instance = new AgentManagerImpl(this.getUserHome());
        return this.getAgent();
    }

    protected void commitProfileTransaction(ProfileTransaction transaction, boolean expectedChange) throws CoreException {
        boolean actualChange = transaction.commit(LOGGER);
        MatcherAssert.assertThat((Object)actualChange, (Matcher)CoreMatchers.is((Object)expectedChange));
    }
}

