/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.dal.driver.sample.fan.function;

import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.dal.driver.custom.functions.BaseFunction;
import org.eclipse.om2m.dal.driver.custom.functions.OperationMetadataImpl;
import org.eclipse.om2m.dal.driver.sample.Activator;
import org.osgi.service.dal.DeviceException;
import org.osgi.service.dal.FunctionData;
import org.osgi.service.dal.FunctionEvent;
import org.osgi.service.dal.PropertyMetadata;
import org.osgi.service.dal.functions.BooleanControl;
import org.osgi.service.dal.functions.data.BooleanData;
import org.osgi.service.event.Event;

public class Switch
extends BaseFunction
implements BooleanControl {
    private static Log LOGGER = LogFactory.getLog(Switch.class);
    private boolean data = false;
    private PowerStateMetadata metaData;

    public Switch(String devUid, String funcId) {
        super(devUid, "power", funcId);
    }

    @Override
    protected void setupFuncProperties() {
        this.props.put("dal.function.version", "1.0");
        this.props.put("dal.function.description", "Power switch function");
        this.props.put("dal.function.operation.names", new String[]{"inverse", "setTrue", "setFalse"});
        this.props.put("dal.function.property.names", new String[]{"data"});
    }

    @Override
    protected void setupPropertyMetadata() {
        this.metaData = new PowerStateMetadata();
        this.propMetadatas.put("data", this.metaData);
    }

    @Override
    protected void setupOperationMetadata() {
        this.oprMetadatas.put("inverse", new OperationMetadataImpl("Inverse the power state", null, null));
        this.oprMetadatas.put("setTrue", new OperationMetadataImpl("Set the power state to ON", null, null));
        this.oprMetadatas.put("setFalse", new OperationMetadataImpl("Set the power state to OFF", null, null));
    }

    public BooleanData getData() throws DeviceException {
        return new BooleanData(System.currentTimeMillis(), this.metaData.getMetadata(null), this.data);
    }

    public void setData(boolean data) throws DeviceException {
        this.data = data;
        Activator.getEventAdmin().postEvent((Event)new FunctionEvent("org/osgi/service/dal/FunctionEvent/PROPERTY_CHANGED", this.uid, "data", (FunctionData)new BooleanData(System.currentTimeMillis(), this.metaData.getMetadata(null), data)));
        LOGGER.info((Object)("Function event (" + this.uid + "-" + this.data + ") is sent."));
    }

    public void inverse() throws DeviceException {
        this.setData(!this.data);
    }

    public void setTrue() throws DeviceException {
        this.setData(true);
    }

    public void setFalse() throws DeviceException {
        this.setData(false);
    }

    private class PowerStateMetadata
    implements PropertyMetadata {
        private Map<String, Object> metadatas = new Hashtable<String, Object>();

        public PowerStateMetadata() {
            this.metadatas.put("access", new Integer(7));
            this.metadatas.put("description", "The current status of the power switch.");
        }

        public Map getMetadata(String unit) {
            return this.metadatas;
        }

        public FunctionData getStep(String unit) {
            return null;
        }

        public FunctionData[] getEnumValues(String unit) {
            FunctionData[] funcDatas = new FunctionData[]{new BooleanData(0L, this.metadatas, true), new BooleanData(0L, this.metadatas, false)};
            return funcDatas;
        }

        public FunctionData getMinValue(String unit) {
            return null;
        }

        public FunctionData getMaxValue(String unit) {
            return null;
        }
    }
}

