/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.controller;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.entities.AeEntity;
import org.eclipse.om2m.commons.entities.AnnounceableSubordinateEntity;
import org.eclipse.om2m.commons.entities.CSEBaseEntity;
import org.eclipse.om2m.commons.entities.ContainerEntity;
import org.eclipse.om2m.commons.entities.DynamicAuthorizationConsultationEntity;
import org.eclipse.om2m.commons.entities.FlexContainerEntity;
import org.eclipse.om2m.commons.entities.RemoteCSEEntity;
import org.eclipse.om2m.commons.entities.ResourceEntity;
import org.eclipse.om2m.commons.exceptions.BadRequestException;
import org.eclipse.om2m.commons.exceptions.ConflictException;
import org.eclipse.om2m.commons.exceptions.NotPermittedAttrException;
import org.eclipse.om2m.commons.exceptions.ResourceNotFoundException;
import org.eclipse.om2m.commons.resource.AbstractFlexContainer;
import org.eclipse.om2m.commons.resource.AnnounceableResource;
import org.eclipse.om2m.commons.resource.CustomAttribute;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.Resource;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.commons.resource.flexcontainerspec.FlexContainerFactory;
import org.eclipse.om2m.commons.utils.Util;
import org.eclipse.om2m.core.announcer.Announcer;
import org.eclipse.om2m.core.controller.Controller;
import org.eclipse.om2m.core.datamapper.DataMapperSelector;
import org.eclipse.om2m.core.entitymapper.EntityMapperFactory;
import org.eclipse.om2m.core.flexcontainer.FlexContainerSelector;
import org.eclipse.om2m.core.flexcontainer.FlexContainerXMLValidator;
import org.eclipse.om2m.core.notifier.Notifier;
import org.eclipse.om2m.core.router.Patterns;
import org.eclipse.om2m.core.urimapper.UriMapper;
import org.eclipse.om2m.core.util.ControllerUtil;
import org.eclipse.om2m.flexcontainer.service.FlexContainerService;
import org.eclipse.om2m.persistence.service.DAO;

public class FlexContainerController
extends Controller {
    private static Log LOGGER = LogFactory.getLog(FlexContainerController.class);

    @Override
    public ResponsePrimitive doCreate(RequestPrimitive request) {
        String contentFormat = System.getProperty("org.eclipse.om2m.registration.contentFormat", "application/xml");
        Patterns patterns = new Patterns();
        ResponsePrimitive response = new ResponsePrimitive(request);
        DAO<?> dao = patterns.getDAO(request.getTo(), this.dbs);
        if (dao == null) {
            throw new ResourceNotFoundException("Cannot find parent resource");
        }
        ResourceEntity parentEntity = (ResourceEntity)dao.find(this.transaction, (Object)request.getTo());
        if (parentEntity == null) {
            throw new ResourceNotFoundException("Cannot find parent resource");
        }
        this.transaction.lock((Object)parentEntity);
        List acpsToCheck = null;
        List childFlexContainers = null;
        List subscriptions = null;
        if (parentEntity.getResourceType().intValue() == 5) {
            CSEBaseEntity cseB = (CSEBaseEntity)parentEntity;
            acpsToCheck = cseB.getAccessControlPolicies();
            childFlexContainers = cseB.getChildFlexContainers();
            subscriptions = cseB.getSubscriptions();
        }
        if (parentEntity.getResourceType().intValue() == 2) {
            AeEntity ae = (AeEntity)parentEntity;
            acpsToCheck = ae.getAccessControlPolicies();
            childFlexContainers = ae.getChildFlexContainers();
            subscriptions = ae.getSubscriptions();
        }
        if (parentEntity.getResourceType().intValue() == 28) {
            FlexContainerEntity parentFlexContainer = (FlexContainerEntity)parentEntity;
            acpsToCheck = parentFlexContainer.getAccessControlPolicies();
            childFlexContainers = parentFlexContainer.getChildFlexContainers();
            subscriptions = parentFlexContainer.getSubscriptions();
        }
        if (parentEntity.getResourceType().intValue() == 3) {
            ContainerEntity parentContainer = (ContainerEntity)parentEntity;
            acpsToCheck = parentContainer.getAccessControlPolicies();
            childFlexContainers = parentContainer.getChildFlexContainers();
            subscriptions = parentContainer.getSubscriptions();
        }
        if (parentEntity.getResourceType().intValue() == 16) {
            RemoteCSEEntity csr = (RemoteCSEEntity)parentEntity;
            acpsToCheck = csr.getAccessControlPolicies();
            childFlexContainers = csr.getChildFcnt();
            subscriptions = csr.getSubscriptions();
        }
        this.checkPermissions(request, parentEntity, acpsToCheck);
        if (request.getContent() == null) {
            throw new BadRequestException("A content is requiered for FlexContainer creation");
        }
        AbstractFlexContainer flexContainer = null;
        try {
            String payload = null;
            if (request.getRequestContentType().equals("application/obj")) {
                flexContainer = (AbstractFlexContainer)request.getContent();
                payload = DataMapperSelector.getDataMapperList().get(contentFormat).objToString((Object)flexContainer);
            } else {
                flexContainer = (AbstractFlexContainer)DataMapperSelector.getDataMapperList().get(request.getRequestContentType()).stringToObj((String)request.getContent());
                payload = request.getRequestContentType().equals(contentFormat) ? (String)request.getContent() : DataMapperSelector.getDataMapperList().get(contentFormat).objToString((Object)flexContainer);
            }
            if (contentFormat.equals("application/xml")) {
                FlexContainerXMLValidator.validateXMLPayload(payload, flexContainer.getContainerDefinition());
            }
        }
        catch (ClassCastException e) {
            e.printStackTrace();
            LOGGER.debug((Object)"ClassCastException: Incorrect resource type in object conversion.", (Throwable)e);
            throw new BadRequestException("Incorrect resource representation in content", (Throwable)e);
        }
        if (flexContainer == null) {
            throw new BadRequestException("Error in provided content");
        }
        FlexContainerEntity flexContainerEntity = new FlexContainerEntity();
        ControllerUtil.CreateUtil.fillEntityFromAnnounceableResource((AnnounceableResource)flexContainer, (AnnounceableSubordinateEntity)flexContainerEntity);
        flexContainerEntity.setLongName(flexContainer.getLongName());
        flexContainerEntity.setShortName(flexContainer.getShortName());
        if (flexContainer.getCreator() != null) {
            flexContainerEntity.setCreator(flexContainer.getCreator());
        }
        if (flexContainer.getContainerDefinition() == null || flexContainer.getContainerDefinition().isEmpty()) {
            throw new NotPermittedAttrException("containerDefinition attribute must be provided.");
        }
        flexContainerEntity.setContainerDefinition(flexContainer.getContainerDefinition());
        String generatedId = FlexContainerController.generateId("", "");
        if (flexContainer.getName() != null) {
            if (!patterns.checkResourceName(flexContainer.getName())) {
                throw new BadRequestException("Name provided is incorrect. Must be:" + patterns.ID_STRING);
            }
            flexContainerEntity.setName(flexContainer.getName());
        } else {
            flexContainerEntity.setName("fcnt_" + generatedId);
        }
        flexContainerEntity.setResourceID("/" + Constants.CSE_ID + "/" + "fcnt" + Constants.PREFIX_SEPERATOR + generatedId);
        flexContainerEntity.setHierarchicalURI(String.valueOf(parentEntity.getHierarchicalURI()) + "/" + flexContainerEntity.getName());
        flexContainerEntity.setParentID(parentEntity.getResourceID());
        flexContainerEntity.setResourceType(28);
        switch (parentEntity.getResourceType().intValue()) {
            case 2: {
                flexContainerEntity.setParentAE((AeEntity)parentEntity);
                break;
            }
            case 28: {
                flexContainerEntity.setParentFlexContainer((FlexContainerEntity)parentEntity);
            }
        }
        if (!flexContainer.getAccessControlPolicyIDs().isEmpty()) {
            flexContainerEntity.setAccessControlPolicies(ControllerUtil.buildAcpEntityList(flexContainer.getAccessControlPolicyIDs(), this.transaction));
        } else {
            flexContainerEntity.getAccessControlPolicies().addAll(acpsToCheck);
        }
        if (!flexContainer.getDynamicAuthorizationConsultationIDs().isEmpty()) {
            flexContainerEntity.setDynamicAuthorizationConsultations(ControllerUtil.buildDacEntityList(flexContainer.getDynamicAuthorizationConsultationIDs(), this.transaction));
        }
        if (!UriMapper.addNewUri(flexContainerEntity.getHierarchicalURI(), flexContainerEntity.getResourceID(), 28)) {
            throw new ConflictException("Name already present in the parent collection.");
        }
        if (flexContainer.getOntologyRef() != null) {
            flexContainerEntity.setOntologyRef(flexContainer.getOntologyRef());
        }
        for (CustomAttribute ca : flexContainer.getCustomAttributes()) {
            flexContainerEntity.createOrUpdateCustomAttribute(ca.getCustomAttributeName(), (Object)ca.getCustomAttributeValue());
        }
        this.dbs.getDAOFactory().getFlexContainerDAO().create(this.transaction, (Object)flexContainerEntity);
        FlexContainerEntity flexContainerFromDB = (FlexContainerEntity)this.dbs.getDAOFactory().getFlexContainerDAO().find(this.transaction, (Object)flexContainerEntity.getResourceID());
        childFlexContainers.add(flexContainerFromDB);
        dao.update(this.transaction, (Object)parentEntity);
        for (DynamicAuthorizationConsultationEntity dace : flexContainerFromDB.getDynamicAuthorizationConsultations()) {
            DynamicAuthorizationConsultationEntity daceFromDB = (DynamicAuthorizationConsultationEntity)this.dbs.getDAOFactory().getDynamicAuthorizationDAO().find(this.transaction, (Object)dace.getResourceID());
            daceFromDB.getLinkedFlexContainerEntites().add(flexContainerFromDB);
            this.dbs.getDAOFactory().getDynamicAuthorizationDAO().update(this.transaction, (Object)daceFromDB);
        }
        this.transaction.commit();
        if (flexContainer.getAnnounceTo() != null && !flexContainer.getAnnounceTo().isEmpty()) {
            flexContainer.setName(flexContainerFromDB.getName());
            flexContainer.setResourceID(flexContainerFromDB.getResourceID());
            flexContainer.setResourceType(28);
            flexContainer.setParentID(flexContainerFromDB.getParentID());
            String hierachicalURI = flexContainerFromDB.getHierarchicalURI();
            String remoteLocation = hierachicalURI.substring(("/" + Constants.CSE_ID + "/" + Constants.CSE_NAME + "/").length());
            Announcer.announce(flexContainer.getAnnounceTo(), flexContainer.getAnnouncedAttribute(), (AnnounceableResource)flexContainer, request.getFrom(), remoteLocation);
        }
        Notifier.notify(subscriptions, (ResourceEntity)flexContainerFromDB, 1);
        response.setResponseStatusCode(ResponseStatusCode.CREATED);
        this.setLocationAndCreationContent(request, response, (ResourceEntity)flexContainerFromDB);
        return response;
    }

    @Override
    public ResponsePrimitive doRetrieve(RequestPrimitive request) {
        ResponsePrimitive response = new ResponsePrimitive(request);
        FlexContainerEntity flexContainerEntity = (FlexContainerEntity)this.dbs.getDAOFactory().getFlexContainerDAO().find(this.transaction, (Object)request.getTo());
        if (flexContainerEntity == null) {
            throw new ResourceNotFoundException("Resource not found");
        }
        flexContainerEntity.getAccessControlPolicies();
        this.checkPermissions(request, (ResourceEntity)flexContainerEntity, flexContainerEntity.getAccessControlPolicies());
        AbstractFlexContainer flexContainerResource = EntityMapperFactory.getFlexContainerMapper().mapEntityToResource(flexContainerEntity, request);
        response.setContent((Object)flexContainerResource);
        response.setResponseStatusCode(ResponseStatusCode.OK);
        return response;
    }

    @Override
    public ResponsePrimitive doUpdate(RequestPrimitive request) {
        return this.processInternalNotifyOrUpdate(request, false);
    }

    @Override
    public ResponsePrimitive doInternalNotify(RequestPrimitive request) {
        return this.processInternalNotifyOrUpdate(request, true);
    }

    private ResponsePrimitive processInternalNotifyOrUpdate(RequestPrimitive request, boolean isInternalNotify) {
        String contentFormat = System.getProperty("org.eclipse.om2m.registration.contentFormat", "application/xml");
        ResponsePrimitive response = new ResponsePrimitive(request);
        FlexContainerEntity flexContainerEntity = (FlexContainerEntity)this.dbs.getDAOFactory().getFlexContainerDAO().find(this.transaction, (Object)request.getTo());
        this.transaction.lock((Object)flexContainerEntity);
        if (flexContainerEntity == null) {
            throw new ResourceNotFoundException("Resource not found");
        }
        if (!isInternalNotify) {
            this.checkPermissions(request, (ResourceEntity)flexContainerEntity, flexContainerEntity.getAccessControlPolicies());
        }
        AbstractFlexContainer modifiedAttributes = FlexContainerFactory.getSpecializationFlexContainer((String)flexContainerEntity.getShortName());
        if (request.getContent() != null) {
            AbstractFlexContainer flexContainer = null;
            try {
                String payload = null;
                if (request.getRequestContentType().equals("application/obj")) {
                    flexContainer = (AbstractFlexContainer)request.getContent();
                    payload = DataMapperSelector.getDataMapperList().get(contentFormat).objToString((Object)flexContainer);
                } else {
                    flexContainer = (AbstractFlexContainer)DataMapperSelector.getDataMapperList().get(request.getRequestContentType()).stringToObj((String)request.getContent());
                    payload = request.getRequestContentType().equals(contentFormat) ? (String)request.getContent() : DataMapperSelector.getDataMapperList().get(contentFormat).objToString((Object)flexContainer);
                }
                if (contentFormat.equals("application/xml")) {
                    FlexContainerXMLValidator.validateXMLPayload(payload, flexContainer.getContainerDefinition());
                }
            }
            catch (ClassCastException e) {
                throw new BadRequestException("Incorrect resource representation in content", (Throwable)e);
            }
            if (flexContainer == null) {
                throw new BadRequestException("Error in provided content");
            }
            if (!flexContainer.getAccessControlPolicyIDs().isEmpty()) {
                flexContainerEntity.getAccessControlPolicies().clear();
                flexContainerEntity.setAccessControlPolicies(ControllerUtil.buildAcpEntityList(flexContainer.getAccessControlPolicyIDs(), this.transaction));
                modifiedAttributes.getAccessControlPolicyIDs().addAll(flexContainer.getAccessControlPolicyIDs());
            }
            if (!flexContainer.getDynamicAuthorizationConsultationIDs().isEmpty()) {
                flexContainerEntity.setDynamicAuthorizationConsultations(ControllerUtil.buildDacEntityList(flexContainer.getDynamicAuthorizationConsultationIDs(), this.transaction));
                for (DynamicAuthorizationConsultationEntity dace : flexContainerEntity.getDynamicAuthorizationConsultations()) {
                    DynamicAuthorizationConsultationEntity daceFromDB = (DynamicAuthorizationConsultationEntity)this.dbs.getDAOFactory().getDynamicAuthorizationDAO().find(this.transaction, (Object)dace.getResourceID());
                    daceFromDB.getLinkedFlexContainerEntites().add(flexContainerEntity);
                    this.dbs.getDAOFactory().getDynamicAuthorizationDAO().update(this.transaction, (Object)daceFromDB);
                }
            }
            if (!flexContainer.getLabels().isEmpty()) {
                flexContainerEntity.setLabelsEntitiesFromSring(flexContainer.getLabels());
                modifiedAttributes.getLabels().addAll(flexContainer.getLabels());
            }
            if (flexContainer.getExpirationTime() != null) {
                flexContainerEntity.setExpirationTime(flexContainer.getExpirationTime());
                modifiedAttributes.setExpirationTime(flexContainer.getExpirationTime());
            }
            if (!flexContainer.getAnnounceTo().isEmpty()) {
                flexContainerEntity.getAnnounceTo().clear();
                flexContainerEntity.getAnnounceTo().addAll(flexContainer.getAnnounceTo());
                modifiedAttributes.getAnnounceTo().addAll(flexContainer.getAnnounceTo());
            }
            if (!flexContainer.getAnnouncedAttribute().isEmpty()) {
                flexContainerEntity.getAnnouncedAttribute().clear();
                flexContainerEntity.getAnnouncedAttribute().addAll(flexContainer.getAnnouncedAttribute());
                modifiedAttributes.getAnnouncedAttribute().addAll(flexContainer.getAnnouncedAttribute());
            }
            if (flexContainer.getOntologyRef() != null) {
                flexContainerEntity.setOntologyRef(flexContainer.getOntologyRef());
                modifiedAttributes.setOntologyRef(flexContainer.getOntologyRef());
            }
            if (flexContainer.getContainerDefinition() != null && !flexContainerEntity.getContainerDefinition().equals(flexContainer.getContainerDefinition())) {
                throw new BadRequestException("unable to change the containerDefinition value");
            }
            if (!flexContainer.getCustomAttributes().isEmpty()) {
                for (CustomAttribute ca : flexContainer.getCustomAttributes()) {
                    flexContainerEntity.createOrUpdateCustomAttribute(ca.getCustomAttributeName(), (Object)ca.getCustomAttributeValue());
                }
                modifiedAttributes.setCustomAttributes(flexContainer.getCustomAttributes());
            }
        }
        flexContainerEntity.setLastModifiedTime(Util.DateUtil.now());
        modifiedAttributes.setLastModifiedTime(flexContainerEntity.getLastModifiedTime());
        if (!isInternalNotify) {
            LOGGER.info((Object)("flexContainer.getResourceID=" + flexContainerEntity.getResourceID()));
            FlexContainerService fcs = FlexContainerSelector.getFlexContainerService(flexContainerEntity.getResourceID());
            if (fcs != null) {
                fcs.setCustomAttributeValues(modifiedAttributes.getCustomAttributes(), request);
            }
        }
        response.setContent((Object)modifiedAttributes);
        this.dbs.getDAOFactory().getFlexContainerDAO().update(this.transaction, (Object)flexContainerEntity);
        this.transaction.commit();
        Notifier.notify(flexContainerEntity.getSubscriptions(), (ResourceEntity)flexContainerEntity, (Resource)modifiedAttributes, 3);
        response.setResponseStatusCode(ResponseStatusCode.UPDATED);
        return response;
    }

    @Override
    public ResponsePrimitive doDelete(RequestPrimitive request) {
        ResponsePrimitive response = new ResponsePrimitive(request);
        FlexContainerEntity flexContainerEntity = (FlexContainerEntity)this.dbs.getDAOFactory().getFlexContainerDAO().find(this.transaction, (Object)request.getTo());
        if (flexContainerEntity == null) {
            throw new ResourceNotFoundException("Resource not found");
        }
        this.transaction.lock((Object)flexContainerEntity);
        this.checkPermissions(request, (ResourceEntity)flexContainerEntity, flexContainerEntity.getAccessControlPolicies());
        UriMapper.deleteUri(flexContainerEntity.getHierarchicalURI());
        Notifier.notifyDeletion(flexContainerEntity.getSubscriptions(), (ResourceEntity)flexContainerEntity);
        this.dbs.getDAOFactory().getFlexContainerDAO().delete(this.transaction, (Object)flexContainerEntity);
        this.transaction.commit();
        Announcer.deAnnounce(flexContainerEntity.getAnnounceTo(), (ResourceEntity)flexContainerEntity, Constants.ADMIN_REQUESTING_ENTITY);
        response.setResponseStatusCode(ResponseStatusCode.DELETED);
        return response;
    }
}

