/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.entitymapper;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.om2m.commons.constants.ResultContent;
import org.eclipse.om2m.commons.entities.AeAnncEntity;
import org.eclipse.om2m.commons.entities.AnnouncedResourceEntity;
import org.eclipse.om2m.commons.entities.FlexContainerAnncEntity;
import org.eclipse.om2m.commons.entities.SubscriptionEntity;
import org.eclipse.om2m.commons.resource.AEAnnc;
import org.eclipse.om2m.commons.resource.AbstractFlexContainerAnnc;
import org.eclipse.om2m.commons.resource.AnnouncedResource;
import org.eclipse.om2m.commons.resource.ChildResourceRef;
import org.eclipse.om2m.commons.resource.Subscription;
import org.eclipse.om2m.core.entitymapper.EntityMapper;
import org.eclipse.om2m.core.entitymapper.EntityMapperFactory;
import org.eclipse.om2m.core.entitymapper.FlexContainerAnncMapper;
import org.eclipse.om2m.core.entitymapper.SubscriptionMapper;

public class AeAnncMapper
extends EntityMapper<AeAnncEntity, AEAnnc> {
    @Override
    protected void mapAttributes(AeAnncEntity entity, AEAnnc resource, int level, int offset) {
        if (level < 0) {
            return;
        }
        EntityMapperFactory.getAnnouncedResourceMapper().mapAttributes((AnnouncedResourceEntity)entity, (AnnouncedResource)resource, level, offset);
        resource.setAEID(entity.getAeid());
        resource.setAppID(entity.getAppID());
        resource.setExpirationTime(entity.getExpirationTime());
        resource.setAppName(entity.getAppName());
        resource.setNodeLink(entity.getNodeLink());
        resource.setLink(entity.getLink());
        resource.setOntologyRef(entity.getOntologyRef());
        resource.getPointOfAccess().addAll(entity.getPointOfAccess());
    }

    @Override
    protected void mapChildResourceRef(AeAnncEntity entity, AEAnnc resource, int level, int offset) {
        resource.getChildResource().addAll(this.getChildResourceRef(entity, level, offset));
    }

    @Override
    protected List<ChildResourceRef> getChildResourceRef(AeAnncEntity entity, int level, int offset) {
        ChildResourceRef child;
        ArrayList<ChildResourceRef> childRefs = new ArrayList<ChildResourceRef>();
        if (level == 0) {
            return childRefs;
        }
        for (FlexContainerAnncEntity flexContainerEntity : entity.getFlexContainerAnncs()) {
            child = new ChildResourceRef();
            child.setResourceName(flexContainerEntity.getName());
            child.setType(flexContainerEntity.getResourceType());
            child.setValue(flexContainerEntity.getResourceID());
            child.setSpid(flexContainerEntity.getContainerDefinition());
            childRefs.add(child);
            childRefs.addAll(new FlexContainerAnncMapper().getChildResourceRef(flexContainerEntity, level - 1, offset - 1));
        }
        for (SubscriptionEntity sub : entity.getSubscriptions()) {
            child = new ChildResourceRef();
            child.setResourceName(sub.getName());
            child.setType(BigInteger.valueOf(23L));
            child.setValue(sub.getResourceID());
            childRefs.add(child);
            childRefs.addAll(new SubscriptionMapper().getChildResourceRef(sub, level - 1, offset - 1));
        }
        return childRefs;
    }

    @Override
    protected void mapChildResources(AeAnncEntity entity, AEAnnc resource, int level, int offset) {
        if (level == 0) {
            return;
        }
        for (FlexContainerAnncEntity flexContainerEntity : entity.getFlexContainerAnncs()) {
            AbstractFlexContainerAnnc fcnt = (AbstractFlexContainerAnnc)new FlexContainerAnncMapper().mapEntityToResource(flexContainerEntity, ResultContent.ATTRIBUTES_AND_CHILD_RES, level - 1, offset - 1);
            resource.getContainerOrContainerAnncOrGroup().add(fcnt);
        }
        for (SubscriptionEntity sub : entity.getSubscriptions()) {
            Subscription subRes = (Subscription)new SubscriptionMapper().mapEntityToResource(sub, ResultContent.ATTRIBUTES_AND_CHILD_RES, level - 1, offset - 1);
            resource.getContainerOrContainerAnncOrGroup().add(subRes);
        }
    }

    @Override
    protected AEAnnc createResource() {
        return new AEAnnc();
    }
}

