/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.persistence.mongodb;

import com.mongodb.client.model.Filters;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.Document;
import org.eclipse.om2m.commons.entities.ResourceEntity;
import org.eclipse.om2m.persistence.mongodb.DBServiceImpl;
import org.eclipse.om2m.persistence.mongodb.DBTransactionImpl;
import org.eclipse.om2m.persistence.service.DAO;
import org.eclipse.om2m.persistence.service.DBTransaction;

public abstract class DAOImpl<T extends ResourceEntity>
implements DAO<T> {
    private static final Log LOGGER = LogFactory.getLog(DAOImpl.class);
    private final Class clazz;

    public DAOImpl(Class pClazz) {
        this.clazz = pClazz;
    }

    public void create(DBTransaction dbTransaction, T resource) {
        DBTransactionImpl cfr_ignored_0 = (DBTransactionImpl)dbTransaction;
        String json = DBServiceImpl.getInstance().getGson().toJson(resource);
        Document newOject = Document.parse((String)json);
        DBServiceImpl.getInstance().getResourceCollection().insertOne((Object)newOject);
    }

    public T find(DBTransaction dbTransaction, Object id) {
        DBTransactionImpl cfr_ignored_0 = (DBTransactionImpl)dbTransaction;
        Document doc = (Document)DBServiceImpl.getInstance().getResourceCollection().find(Filters.eq((String)"ResourceID", (Object)id)).first();
        Object toBeReturned = null;
        if (doc != null) {
            toBeReturned = DBServiceImpl.getInstance().getGson().fromJson(doc.toJson(), this.clazz);
        }
        return (T)((ResourceEntity)toBeReturned);
    }

    public void update(DBTransaction dbTransaction, T resource) {
        DBTransactionImpl cfr_ignored_0 = (DBTransactionImpl)dbTransaction;
        Document doc = (Document)DBServiceImpl.getInstance().getResourceCollection().find(Filters.eq((String)"ResourceID", (Object)resource.getResourceID())).first();
        if (doc != null) {
            String json = DBServiceImpl.getInstance().getGson().toJson(resource);
            Document newDoc = Document.parse((String)json);
            DBServiceImpl.getInstance().getResourceCollection().replaceOne(Filters.eq((String)"ResourceID", (Object)resource.getResourceID()), (Object)newDoc);
        }
    }

    public void delete(DBTransaction dbTransaction, T resource) {
        this.delete(resource.getResourceID());
    }

    private void delete(Object id) {
        DBServiceImpl.getInstance().getResourceCollection().deleteMany(Filters.eq((String)"ResourceID", (Object)id));
        for (Document doc : DBServiceImpl.getInstance().getResourceCollection().find(Filters.eq((String)"ParentID", (Object)id))) {
            Object idChild = doc.get((Object)"ResourceID");
            this.delete(idChild);
        }
    }
}

