/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.ipe.sdt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.resource.AE;
import org.eclipse.om2m.commons.resource.AEAnnc;
import org.eclipse.om2m.commons.resource.AccessControlPolicy;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.core.service.CseService;
import org.eclipse.om2m.ipe.sdt.CseUtil;
import org.eclipse.om2m.ipe.sdt.DeviceListListener;
import org.eclipse.om2m.ipe.sdt.SDTDeviceAdaptor;
import org.eclipse.om2m.sdt.Device;

public class SDTIpeApplication
implements DeviceListListener {
    private static Log logger = LogFactory.getLog(SDTIpeApplication.class);
    private static final String SEP = "/";
    private static final String APPLICATION_NAME = "SDT_IPE";
    private static final String DEFAULT_BASE_LOCATION = "/" + Constants.CSE_ID + "/" + Constants.CSE_NAME;
    private static final String DEFAULT_APPLICATION_LOCATION = String.valueOf(DEFAULT_BASE_LOCATION) + "/" + "SDT_IPE";
    private static final String POA = "sdt";
    private final CseService cseService;
    private final Map<Device, SDTDeviceAdaptor> devices = new HashMap<Device, SDTDeviceAdaptor>();
    private final String remoteCseId;
    private final String remoteCseName;
    private final String sdtIpeApplicationLocation;
    private final String sdtIpeBaseLocation;
    private final boolean ipeUnderAnnouncedResource;
    private final boolean hasToBeAnnounced;
    private AccessControlPolicy adminAccessControlPolicy;
    private AccessControlPolicy remoteAdminAccessControlPolicy;
    private AE registeredAe;

    public SDTIpeApplication(CseService pCseService, String announceCseId, String pRemoteCseName, boolean ipeUnder, boolean hasToBeAnnounced) {
        this.cseService = pCseService;
        this.remoteCseId = announceCseId;
        this.remoteCseName = pRemoteCseName;
        this.ipeUnderAnnouncedResource = ipeUnder;
        this.hasToBeAnnounced = hasToBeAnnounced;
        if (this.ipeUnderAnnouncedResource) {
            if (this.remoteCseId != null && this.remoteCseName != null) {
                this.sdtIpeBaseLocation = String.valueOf(DEFAULT_BASE_LOCATION) + SEP + this.remoteCseName;
                this.sdtIpeApplicationLocation = String.valueOf(this.sdtIpeBaseLocation) + SEP + APPLICATION_NAME;
            } else {
                this.sdtIpeApplicationLocation = DEFAULT_APPLICATION_LOCATION;
                this.sdtIpeBaseLocation = DEFAULT_BASE_LOCATION;
            }
        } else {
            this.sdtIpeApplicationLocation = DEFAULT_APPLICATION_LOCATION;
            this.sdtIpeBaseLocation = DEFAULT_BASE_LOCATION;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addSDTDevice(Device device) {
        logger.info((Object)("add SDT Device (id:" + device.getId() + ", name=" + device.getName() + ") into oneM2M"));
        SDTDeviceAdaptor sdtDeviceAdaptor = new SDTDeviceAdaptor(this.sdtIpeApplicationLocation, device, this.cseService, this.adminAccessControlPolicy.getResourceID(), this.remoteCseId, this.remoteCseName, this.hasToBeAnnounced);
        if (sdtDeviceAdaptor.publishIntoOM2MTree()) {
            Map<Device, SDTDeviceAdaptor> map = this.devices;
            synchronized (map) {
                this.devices.put(device, sdtDeviceAdaptor);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSDTDevice(Device device) {
        logger.info((Object)("remove SDT Device (id:" + device.getId() + ", name=" + device.getName() + ") into oneM2M"));
        SDTDeviceAdaptor sdtDeviceAdaptor = null;
        Map<Device, SDTDeviceAdaptor> map = this.devices;
        synchronized (map) {
            sdtDeviceAdaptor = this.devices.remove(device);
        }
        if (sdtDeviceAdaptor != null) {
            sdtDeviceAdaptor.unpublishIntoOM2MTree();
            sdtDeviceAdaptor = null;
        }
    }

    public void publishSDTIPEApplication() throws Exception {
        logger.info((Object)"create ipe application");
        AE ae = new AE();
        ae.setName(APPLICATION_NAME);
        ae.setAppID(APPLICATION_NAME);
        ae.setRequestReachability(Boolean.TRUE);
        ae.getPointOfAccess().add(POA);
        if (this.hasToBeAnnounced) {
            ae.getAnnounceTo().add(SEP + this.remoteCseId);
        }
        ResponsePrimitive resp = null;
        try {
            int i = 0;
            while (i < 3) {
                resp = CseUtil.sendCreateApplicationEntityRequest(this.cseService, ae, this.sdtIpeBaseLocation);
                if (!ResponseStatusCode.CREATED.equals(resp.getResponseStatusCode())) {
                    if (!ResponseStatusCode.CONFLICT.equals(resp.getResponseStatusCode())) {
                        logger.error((Object)("Unable to create SDT IPE Application:" + resp.getContent()), null);
                        throw new Exception("unable to create SDT Application Entity");
                    }
                    this.deleteIpeApplicationEntity();
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (Throwable _e) {
            logger.error((Object)"Error in CreateIPEApplication", _e);
            throw _e;
        }
        if (!ResponseStatusCode.CREATED.equals(resp.getResponseStatusCode())) {
            return;
        }
        this.registeredAe = (AE)resp.getContent();
        ResponsePrimitive response = CseUtil.sendCreateDefaultACP(this.cseService, this.sdtIpeBaseLocation, "ACP_Device_Admin_" + System.currentTimeMillis(), new ArrayList<String>());
        this.adminAccessControlPolicy = (AccessControlPolicy)response.getContent();
        if (this.hasToBeAnnounced) {
            response = CseUtil.sendCreateDefaultACP(this.cseService, SEP + this.remoteCseId + SEP + this.remoteCseName + SEP + Constants.CSE_NAME, "Remote_ACP_Device_Admin" + System.currentTimeMillis(), new ArrayList<String>());
            this.remoteAdminAccessControlPolicy = (AccessControlPolicy)response.getContent();
            AEAnnc sdtIpeAnnc = new AEAnnc();
            sdtIpeAnnc.getAccessControlPolicyIDs().add(this.remoteAdminAccessControlPolicy.getResourceID());
            CseUtil.sendUpdateApplicationAnncEntityRequest(this.cseService, sdtIpeAnnc, SEP + this.remoteCseId + SEP + this.remoteCseName + SEP + Constants.CSE_NAME + "/SDT_IPE_Annc");
        }
    }

    protected void deleteIpeApplicationEntity() {
        logger.info((Object)"delete ipe application");
        if (this.registeredAe != null) {
            ResponsePrimitive response = CseUtil.sendDeleteRequest(this.cseService, this.registeredAe.getResourceID());
            if (!response.getResponseStatusCode().equals(ResponseStatusCode.DELETED)) {
                logger.error((Object)("unable to delete SDT IPE Application entity:" + response.getContent()), null);
            }
            this.registeredAe = null;
        }
        if (this.adminAccessControlPolicy != null) {
            CseUtil.sendDeleteRequest(this.cseService, this.adminAccessControlPolicy.getResourceID());
            this.adminAccessControlPolicy = null;
        }
        if (this.remoteAdminAccessControlPolicy != null) {
            CseUtil.sendDeleteRequest(this.cseService, this.remoteAdminAccessControlPolicy.getResourceID());
            this.remoteAdminAccessControlPolicy = null;
        }
    }

    @Override
    public void notifyNewDevice(Device newDevice) {
        this.addSDTDevice(newDevice);
    }

    @Override
    public void notifyDeviceRemoved(Device toBeRemovedDevice) {
        this.removeSDTDevice(toBeRemovedDevice);
    }
}

