/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.persistence.eclipselink.internal.dao;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.om2m.commons.entities.LabelEntity;
import org.eclipse.om2m.commons.entities.ResourceEntity;
import org.eclipse.om2m.persistence.eclipselink.internal.DBTransactionJPAImpl;
import org.eclipse.om2m.persistence.service.DAO;
import org.eclipse.om2m.persistence.service.DBTransaction;

public abstract class AbstractDAO<T>
implements DAO<T> {
    public void create(DBTransaction dbTransaction, T resource) {
        DBTransactionJPAImpl transaction = (DBTransactionJPAImpl)dbTransaction;
        if (resource instanceof ResourceEntity) {
            List<LabelEntity> lbls = this.processLabels(dbTransaction, ((ResourceEntity)resource).getLabelsEntities());
            ((ResourceEntity)resource).setLabelsEntities(lbls);
        }
        transaction.getEm().persist(resource);
    }

    public abstract T find(DBTransaction var1, Object var2);

    public void update(DBTransaction dbTransaction, T resource) {
        DBTransactionJPAImpl transaction = (DBTransactionJPAImpl)dbTransaction;
        transaction.getEm().flush();
    }

    public abstract void delete(DBTransaction var1, T var2);

    protected List<LabelEntity> processLabels(DBTransaction dbTransaction, List<LabelEntity> toProcess) {
        ArrayList<LabelEntity> result = new ArrayList<LabelEntity>();
        DBTransactionJPAImpl transaction = (DBTransactionJPAImpl)dbTransaction;
        for (LabelEntity lbl : toProcess) {
            LabelEntity lblDb = (LabelEntity)transaction.getEm().find(LabelEntity.class, (Object)lbl.getLabel());
            if (lblDb == null) {
                lblDb = new LabelEntity(lbl.getLabel());
                transaction.getEm().persist((Object)lblDb);
                lblDb = (LabelEntity)transaction.getEm().find(LabelEntity.class, (Object)lbl.getLabel());
            }
            result.add(lblDb);
        }
        return result;
    }
}

