/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.driver;

import org.osgi.service.log.LogService;

public class Logger {
    private static final String PREFIX = "[ONEM2M.";
    private static final String[] LEVELS = new String[]{"ERROR ", "WARNING ", "INFO ", "DEBUG "};
    private static LogService logService;
    private String protocol;

    public Logger(String protocol) {
        this.protocol = protocol;
    }

    public final void setLogService(LogService log) {
        logService = log;
    }

    public final void unsetLogService() {
        logService = null;
    }

    public final void debug(String message) {
        this.print(4, null, message);
    }

    public final void debug(String message, Class<?> clazz) {
        this.print(4, clazz, message);
    }

    public final void info(String message) {
        this.print(3, null, message);
    }

    public final void info(String message, Class<?> clazz) {
        this.print(3, clazz, message);
    }

    public final void warning(String message) {
        this.print(2, null, message);
    }

    public final void warning(String message, Throwable e) {
        this.print(2, null, message, e);
    }

    public final void warning(String message, Class<?> clazz) {
        this.print(2, clazz, message);
    }

    public final void warning(String message, Class<?> clazz, Throwable e) {
        this.print(2, clazz, message, e);
    }

    public final void error(String message) {
        this.print(1, null, message);
    }

    public final void error(String message, Throwable e) {
        this.print(1, null, message, e);
    }

    public final void error(String message, Class<?> clazz) {
        this.print(1, clazz, message);
    }

    public final void error(String message, Class<?> clazz, Throwable e) {
        this.print(1, clazz, message, e);
    }

    private final void print(int level, Class<?> clazz, String message) {
        String msg = PREFIX + this.protocol + (clazz == null ? "] " : "." + clazz.getSimpleName() + "] ") + message;
        if (logService != null) {
            logService.log(level, msg);
        } else {
            System.out.println(String.valueOf(LEVELS[level - 1]) + msg);
        }
    }

    private final void print(int level, Class<?> clazz, String message, Throwable e) {
        String msg = PREFIX + this.protocol + (clazz == null ? "] " : "." + clazz.getSimpleName() + "] ") + message;
        if (logService != null) {
            logService.log(level, msg, e);
        } else {
            System.out.println(String.valueOf(LEVELS[level - 1]) + msg + ": " + e.getMessage());
        }
        if (e != null) {
            e.printStackTrace();
        }
    }
}

