/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.persistence.mongodb.resource;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.mongodb.client.model.Filters;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bson.Document;
import org.eclipse.om2m.commons.entities.AccessControlPolicyEntity;
import org.eclipse.om2m.commons.entities.AeAnncEntity;
import org.eclipse.om2m.commons.entities.AeEntity;
import org.eclipse.om2m.commons.entities.CSEBaseEntity;
import org.eclipse.om2m.commons.entities.ContainerEntity;
import org.eclipse.om2m.commons.entities.DynamicAuthorizationConsultationEntity;
import org.eclipse.om2m.commons.entities.FlexContainerAnncEntity;
import org.eclipse.om2m.commons.entities.FlexContainerEntity;
import org.eclipse.om2m.commons.entities.RemoteCSEEntity;
import org.eclipse.om2m.commons.entities.ResourceEntity;
import org.eclipse.om2m.persistence.mongodb.DBServiceImpl;

public class MongoChildLoader<T extends ResourceEntity> {
    public List<? extends ResourceEntity> loadChilds(T t, JsonArray json) {
        ArrayList<Object> toBeReturned = new ArrayList<Object>();
        for (JsonObject jsonObject : json) {
            Document doc;
            String resourceId = jsonObject.get("ResourceID").getAsString();
            BigInteger resourceType = jsonObject.get("ResourceType").getAsBigInteger();
            Class objectClass = this.getEntityClass(resourceType.intValue());
            if (objectClass == null || (doc = (Document)DBServiceImpl.getInstance().getResourceCollection().find(Filters.eq((String)"ResourceID", (Object)resourceId)).first()) == null) continue;
            Iterator it = doc.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                if (!((String)entry.getKey()).startsWith("#")) continue;
                it.remove();
            }
            Object object = DBServiceImpl.getInstance().getGson().fromJson(doc.toJson(), objectClass);
            toBeReturned.add(object);
        }
        return toBeReturned;
    }

    private Class getEntityClass(int resourceType) {
        switch (resourceType) {
            case 2: {
                return AeEntity.class;
            }
            case 10002: {
                return AeAnncEntity.class;
            }
            case 1: {
                return AccessControlPolicyEntity.class;
            }
            case 5: {
                return CSEBaseEntity.class;
            }
            case 28: {
                return FlexContainerEntity.class;
            }
            case 10028: {
                return FlexContainerAnncEntity.class;
            }
            case 3: {
                return ContainerEntity.class;
            }
            case 16: {
                return RemoteCSEEntity.class;
            }
            case 34: {
                return DynamicAuthorizationConsultationEntity.class;
            }
        }
        return null;
    }
}

