/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.modules;

import org.eclipse.om2m.sdt.DataPoint;
import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.Identifiers;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.datapoints.BooleanDataPoint;
import org.eclipse.om2m.sdt.exceptions.AccessException;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.types.ModuleType;

public class GenericSensor
extends Module {
    private BooleanDataPoint value;

    public GenericSensor(String name, Domain domain, BooleanDataPoint value) {
        this(name, domain, value, ModuleType.genericSensor);
    }

    public GenericSensor(String name, Domain domain, BooleanDataPoint value, Identifiers identifiers) {
        super(name, domain, identifiers);
        if (value == null) {
            domain.removeModule(this.getName());
            throw new IllegalArgumentException("Wrong value datapoint: " + value);
        }
        this.value = value;
        this.value.setWritable(false);
        this.value.setDoc("True = Sensed, False = Not Sensed");
        this.addDataPoint((DataPoint)this.value);
    }

    public boolean getValue() throws DataPointException, AccessException {
        return (Boolean)this.value.getValue();
    }
}

