/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.comm;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.binding.service.RestClientService;
import org.eclipse.om2m.commons.exceptions.InternalServerErrorException;
import org.eclipse.om2m.commons.exceptions.NotImplementedException;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;

public class RestClient {
    private static Log LOGGER = LogFactory.getLog(RestClient.class);
    public static Map<String, RestClientService> restClients = new HashMap<String, RestClientService>();

    public static ResponsePrimitive sendRequest(RequestPrimitive request) {
        ResponsePrimitive response;
        block4: {
            LOGGER.info((Object)("the requestIndication RC: " + request));
            response = new ResponsePrimitive();
            String protocol = request.getTo().split("://")[0];
            if (restClients.containsKey(protocol)) {
                try {
                    response = restClients.get(protocol).sendRequest(request);
                    if (response.getResponseStatusCode() == null) {
                        throw new Exception();
                    }
                    break block4;
                }
                catch (Exception e) {
                    LOGGER.error((Object)"RestClient error", (Throwable)e);
                    throw new InternalServerErrorException("RestClient Error", (Throwable)e);
                }
            }
            throw new NotImplementedException("No RestClient service found for protocol: " + protocol);
        }
        LOGGER.info((Object)response);
        return response;
    }

    public static Map<String, RestClientService> getRestClients() {
        return restClients;
    }

    public static void setRestClients(Map<String, RestClientService> sclClients) {
        restClients = sclClients;
    }
}

